/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.util.Arrays;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.dep.Repos;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public class RepositoryInstaller {
    public static void main(String[] args) {
        try {
            Scope scope = Scope.named((String)Props.get((String)"scope", (Context)Context.named((String)"ply")).value());
            String localRepoProp = Props.get((String)"localRepo", (Context)Context.named((String)"depmngr"), (Scope)scope).value();
            RepositoryAtom localRepo = RepositoryAtom.parse((String)localRepoProp);
            if (localRepo == null) {
                Output.print((String)"^error^ Local repository ^b^%s^r^ doesn't exist.", (Object[])new Object[]{localRepoProp});
                System.exit(1);
            }
            if (args.length > 3) {
                RepositoryInstaller.installFile(args, localRepo, scope);
            } else if (args.length == 0) {
                RepositoryInstaller.installProject(localRepo, scope);
            } else {
                Output.print((String)"^error^ Missing parameters to install-file.", (Object[])new Object[0]);
                Output.print((String)"^error^   expected: ^b^namespace^r^ ^b^name^r^ ^b^version^r^ ^b^file^r^ [ ^b^packaging^r^ ^b^classifier^r^ ^b^dependencies-file^r^ ]", (Object[])new Object[0]);
                Output.print((String)"^error^   given: ^b^%s^r^", (Object[])new Object[]{Arrays.toString(args)});
                System.exit(1);
            }
        }
        catch (Exception e) {
            Output.print((Throwable)e);
            System.exit(1);
        }
    }

    private static void installFile(String[] args, RepositoryAtom localRepo, Scope scope) {
        File artifact;
        String namespace = args[0];
        String name = args[1];
        String version = args[2];
        String file = args[3];
        int extensionIndex = file.lastIndexOf(".");
        String packaging = extensionIndex != -1 ? file.substring(extensionIndex + 1) : "jar";
        String classifier = "";
        String dependenciesFilePath = "";
        if (args.length == 7) {
            packaging = args[4];
            classifier = args[5];
            dependenciesFilePath = args[6];
        }
        if (!(artifact = new File(file)).exists()) {
            Output.print((String)"^error^ File to install ^b^%s^r^ doesn't exist.", (Object[])new Object[]{file});
            System.exit(1);
        }
        String artifactName = Deps.getArtifactName((String)name, (String)version, (String)classifier, (String)packaging);
        DependencyAtom dependencyAtom = Deps.getDepFromParts((String)namespace, (String)name, (String)version, (String)artifactName);
        File dependenciesFile = dependenciesFilePath.isEmpty() ? null : new File(dependenciesFilePath);
        Output.print((String)"^info^ Copying ^b^%s^r^ into ^b^%s^r^.", (Object[])new Object[]{file, localRepo.getPropertyName()});
        Output.print((String)"^info^ using namespace=^b^%s^r^ | name=^b^%s^r^ | version=^b^%s^r^ | packaging=^b^%s^r^ | classifier=^b^%s^r^ | dependencies-file=^b^%s^r^", (Object[])new Object[]{namespace, name, version, packaging, classifier, dependenciesFilePath});
        if (Repos.installArtifact((Scope)scope, (File)artifact, (File)dependenciesFile, (DependencyAtom)dependencyAtom, (RepositoryAtom)localRepo)) {
            Output.print((String)"Successfully copied ^b^%s^r^ into ^b^%s^r^.", (Object[])new Object[]{file, localRepo.getPropertyName()});
        } else {
            Output.print((String)"^error^ failed to copy ^b^%s^r^ into ^b^%s^r^.", (Object[])new Object[]{file, localRepo.getPropertyName()});
        }
    }

    private static void installProject(RepositoryAtom localRepo, Scope scope) {
        if (!Repos.install((Scope)scope, (RepositoryAtom)localRepo)) {
            Output.print((String)"^warn^ Could not copy artifact into local repository.", (Object[])new Object[0]);
            return;
        }
        if (RepositoryInstaller.getBoolean(Props.get((String)"includeSrc", (Context)Context.named((String)"package"), (Scope)scope).value())) {
            String artifactName = Props.get((String)"artifact.name", (Context)Context.named((String)"project"), (Scope)scope).value();
            if (artifactName == null || artifactName.lastIndexOf(".") == -1) {
                Output.print((String)"^warn^ No source artifact found [ ^yellow^%s^r^ ]", (Object[])new Object[]{artifactName});
                return;
            }
            artifactName = artifactName.substring(0, artifactName.lastIndexOf(".")) + "-sources" + artifactName.substring(artifactName.lastIndexOf("."));
            DependencyAtom dependencyAtom = Deps.getProjectDep();
            if (!Repos.install((Scope)scope, (RepositoryAtom)localRepo, (String)artifactName, (DependencyAtom)(dependencyAtom = dependencyAtom.withClassifier("sources")))) {
                Output.print((String)"^warn^ Could not copy source artifact into local repository [ %s ].", (Object[])new Object[]{artifactName});
            }
        }
    }

    static boolean getBoolean(String value) {
        return "true".equalsIgnoreCase(value);
    }
}

