/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.script.print.PrivilegedOutput;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class MavenReporter
extends RunListener {
    private final Map<String, ReportTestSuite> testSuites = new HashMap<String, ReportTestSuite>();
    private ReportTestSuite current;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunFinished(Result result) throws Exception {
        MavenReporter mavenReporter = this;
        synchronized (mavenReporter) {
            if (this.current != null) {
                this.current.finish();
            }
        }
        PropFile.Prop reportDirProp = Props.get((String)"reports.dir", (Context)Context.named((String)"project"));
        if (PropFile.Prop.Empty.equals((Object)reportDirProp)) {
            PrivilegedOutput.print("^warn^ Could not find property project.reports.dir, skipping report save.", new Object[0]);
            return;
        }
        File reportDir = new File(reportDirProp.value());
        reportDir.mkdirs();
        for (ReportTestSuite testSuite : this.testSuites.values()) {
            String fileName = MavenReporter.getReportName(testSuite.name);
            String xmlFileContent = testSuite.toXml();
            File file = new File(reportDir.getPath() + File.separator + fileName);
            OutputStreamWriter writer = null;
            try {
                file.createNewFile();
                writer = new FileWriter(file);
                writer.write(xmlFileContent);
            }
            catch (IOException ioe) {
                PrivilegedOutput.print(ioe);
            }
            finally {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) throws Exception {
        MavenReporter mavenReporter = this;
        synchronized (mavenReporter) {
            this.startTestSuiteIfNeeded(description);
            this.current.startTest(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        MavenReporter mavenReporter = this;
        synchronized (mavenReporter) {
            this.current.endTest(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        MavenReporter mavenReporter = this;
        synchronized (mavenReporter) {
            this.current.endTest(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnored(Description description) throws Exception {
        MavenReporter mavenReporter = this;
        synchronized (mavenReporter) {
            this.startTestSuiteIfNeeded(description);
            this.current.ignoreTest(description);
        }
    }

    public static String getReportName(String test) {
        return "TEST-" + test + ".xml";
    }

    private synchronized void startTestSuiteIfNeeded(Description description) {
        if (!this.testSuites.containsKey(description.getClassName())) {
            if (this.current != null) {
                this.current.finish();
            }
            this.current = new ReportTestSuite(description.getClassName());
            this.testSuites.put(this.current.name, this.current);
        }
    }

    private static class XmlEscaper {
        private static final Map<Character, String> XML_ESCAPES = new HashMap<Character, String>(5, 1.0f);

        private XmlEscaper() {
        }

        private static String escapeXml(String str) {
            if (str == null) {
                return null;
            }
            StringBuilder buffer = new StringBuilder((int)((double)str.length() + (double)str.length() * 0.1));
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                String entityName = XML_ESCAPES.get(Character.valueOf(c));
                if (entityName == null) {
                    if (c > '\u007f') {
                        buffer.append("&#");
                        buffer.append(Integer.toString(c, 10));
                        buffer.append(';');
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                buffer.append('&');
                buffer.append(entityName);
                buffer.append(';');
            }
            return buffer.toString();
        }

        static {
            XML_ESCAPES.put(Character.valueOf('\"'), "quot");
            XML_ESCAPES.put(Character.valueOf('&'), "amp");
            XML_ESCAPES.put(Character.valueOf('<'), "lt");
            XML_ESCAPES.put(Character.valueOf('>'), "gt");
            XML_ESCAPES.put(Character.valueOf('\''), "apos");
        }
    }

    private static class ReportTestFailure {
        private final String message;
        private final String exceptionType;
        private final String trace;

        private ReportTestFailure(Failure failure) {
            this.message = failure.getMessage();
            this.trace = failure.getTrace();
            this.exceptionType = failure.getException().getClass().getName();
        }

        private String toXml() {
            String failureType = ReportTestFailure.isError(this.exceptionType) ? "error" : "failure";
            StringBuilder xmlBuffer = new StringBuilder("<");
            xmlBuffer.append(failureType);
            xmlBuffer.append(" message=\"");
            xmlBuffer.append(XmlEscaper.escapeXml(this.message));
            xmlBuffer.append("\" type=\"");
            xmlBuffer.append(XmlEscaper.escapeXml(this.exceptionType));
            xmlBuffer.append("\">");
            xmlBuffer.append(XmlEscaper.escapeXml(this.trace));
            xmlBuffer.append("\n    </");
            xmlBuffer.append(failureType);
            xmlBuffer.append(">");
            return xmlBuffer.toString();
        }

        private static boolean isError(Failure failure) {
            Throwable excep = failure.getException();
            return ReportTestFailure.isError(excep.getClass().getName());
        }

        private static boolean isError(String exceptionType) {
            return !exceptionType.startsWith("junit");
        }
    }

    private static class ReportTest {
        private final String name;
        private final String className;
        private final String methodName;
        private final long startTime;
        private final AtomicLong duration = new AtomicLong();
        private final AtomicReference<ReportTestFailure> failure = new AtomicReference<Object>(null);
        private final AtomicBoolean ignored = new AtomicBoolean(false);

        private ReportTest(Description description) {
            this.name = description.getDisplayName();
            this.className = description.getClassName();
            this.methodName = description.getMethodName();
            this.startTime = System.currentTimeMillis();
        }

        private void finish() {
            this.duration.set(System.currentTimeMillis() - this.startTime);
        }

        private void finishByIgnore() {
            this.finish();
            this.ignored.set(true);
        }

        private void finish(Failure failure) {
            this.finish();
            this.failure.set(new ReportTestFailure(failure));
        }

        private String toXml() {
            StringBuilder xmlBuffer = new StringBuilder("<testcase time=\"");
            xmlBuffer.append(String.format("%.3f", Float.valueOf((float)this.duration.get() / 1000.0f)));
            xmlBuffer.append("\" classname=\"");
            xmlBuffer.append(this.className);
            xmlBuffer.append("\" name=\"");
            xmlBuffer.append(this.methodName);
            xmlBuffer.append("\"");
            if (this.failure.get() != null) {
                xmlBuffer.append(">\n    ");
                xmlBuffer.append(this.failure.get().toXml());
                xmlBuffer.append("\n  </testcase>");
            } else if (this.ignored.get()) {
                xmlBuffer.append(">\n    <skipped/>\n  </testcase>");
            } else {
                xmlBuffer.append("/>");
            }
            return xmlBuffer.toString();
        }
    }

    private static class ReportTestSuite {
        private final String name;
        private final AtomicInteger failureCount = new AtomicInteger(0);
        private final AtomicInteger errorsCount = new AtomicInteger(0);
        private final AtomicInteger skippedCount = new AtomicInteger(0);
        private final AtomicInteger totalCount = new AtomicInteger(0);
        private final long startTime;
        private final AtomicLong duration = new AtomicLong();
        private final List<ReportTest> tests = new ArrayList<ReportTest>();
        private final Map<String, Integer> reportNameMap = new HashMap<String, Integer>();

        private ReportTestSuite(String name) {
            this.name = name;
            this.startTime = System.currentTimeMillis();
        }

        private synchronized void startTest(Description description) {
            int index = this.tests.size();
            this.totalCount.addAndGet(1);
            ReportTest test = new ReportTest(description);
            this.tests.add(test);
            this.reportNameMap.put(test.name, index);
        }

        private synchronized void ignoreTest(Description description) {
            int index = this.tests.size();
            this.totalCount.addAndGet(1);
            this.skippedCount.addAndGet(1);
            ReportTest test = new ReportTest(description);
            test.finishByIgnore();
            this.tests.add(test);
            this.reportNameMap.put(test.name, index);
        }

        private synchronized void endTest(Description description) {
            int index = this.reportNameMap.get(description.getDisplayName());
            ReportTest test = this.tests.get(index);
            test.finish();
        }

        private synchronized void endTest(Failure failure) {
            int index = this.reportNameMap.get(failure.getDescription().getDisplayName());
            if (ReportTestFailure.isError(failure)) {
                this.errorsCount.addAndGet(1);
            } else {
                this.failureCount.addAndGet(1);
            }
            ReportTest test = this.tests.get(index);
            test.finish(failure);
        }

        private synchronized void finish() {
            this.duration.set(System.currentTimeMillis() - this.startTime);
        }

        private String toXml() {
            StringBuilder xmlBuffer = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<testsuite failures=\"");
            xmlBuffer.append(this.failureCount.get());
            xmlBuffer.append("\" time=\"");
            xmlBuffer.append(String.format("%.3f", Float.valueOf((float)this.duration.get() / 1000.0f)));
            xmlBuffer.append("\" errors=\"");
            xmlBuffer.append(this.errorsCount.get());
            xmlBuffer.append("\" skipped=\"");
            xmlBuffer.append(this.skippedCount.get());
            xmlBuffer.append("\" tests=\"");
            xmlBuffer.append(this.totalCount.get());
            xmlBuffer.append("\" name=\"");
            xmlBuffer.append(this.name);
            xmlBuffer.append("\">\n  <properties>\n");
            for (String propertyName : System.getProperties().stringPropertyNames()) {
                xmlBuffer.append("    <property name=\"");
                xmlBuffer.append(XmlEscaper.escapeXml(propertyName));
                xmlBuffer.append("\" value=\"");
                xmlBuffer.append(XmlEscaper.escapeXml(System.getProperties().getProperty(propertyName)));
                xmlBuffer.append("\"/>\n");
            }
            xmlBuffer.append("  </properties>");
            for (ReportTest test : this.tests) {
                xmlBuffer.append("\n  ");
                xmlBuffer.append(test.toXml());
            }
            xmlBuffer.append("\n</testsuite>");
            return xmlBuffer.toString();
        }
    }
}

