/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.script.AllFilterCollectPad;
import net.ocheyedan.ply.script.DescriptionMatcher;
import net.ocheyedan.ply.script.Junit4RunListener;
import net.ocheyedan.ply.script.MavenReporter;
import net.ocheyedan.ply.script.UnionFilter;
import net.ocheyedan.ply.script.print.PrivilegedOutput;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class Junit4Invoker
implements Runnable {
    private static final Comparator<Class> CLASS_NAME_COMPARATOR = new Comparator<Class>(){

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Set<Class> classes;
    private final Filter filter;
    private final AllFilterCollectPad padding;
    private final String originalMatchers;

    public Junit4Invoker(Set<Class> classes, String[] matchers, String unsplitMatchers) {
        this.classes = this.pruneNonTestAnnotated(classes);
        UnionFilter filter = null;
        if (matchers != null) {
            for (String matcher : matchers) {
                if (filter == null) {
                    filter = new UnionFilter();
                }
                filter.union(new DescriptionMatcher(matcher));
            }
        }
        this.padding = new AllFilterCollectPad();
        this.filter = filter == null ? this.padding : this.padding.intersect(filter);
        this.originalMatchers = unsplitMatchers;
    }

    @Override
    public void run() {
        Result result;
        int syntheticCount;
        if (this.classes.size() == 0) {
            PrivilegedOutput.print("No tests found, nothing to test.", new Object[0]);
            return;
        }
        JUnitCore jUnitCore = new JUnitCore();
        Junit4RunListener junit4RunListener = new Junit4RunListener(this.padding);
        jUnitCore.addListener((RunListener)junit4RunListener);
        jUnitCore.addListener((RunListener)new MavenReporter());
        ArrayList<Class> sorted = new ArrayList<Class>(this.classes);
        Collections.sort(sorted, CLASS_NAME_COMPARATOR);
        Request request = Request.classes((Class[])sorted.toArray(new Class[sorted.size()]));
        if (this.filter != null) {
            request = request.filterWith(this.filter);
        }
        if ((syntheticCount = this.countSynthetic(result = jUnitCore.run(request))) == result.getRunCount()) {
            if (this.originalMatchers != null) {
                PrivilegedOutput.print("^warn^ No tests matched ^b^%s^r^", this.originalMatchers);
            } else {
                PrivilegedOutput.print("No tests found, nothing to test.", new Object[0]);
            }
            return;
        }
        int runCount = result.getRunCount() - syntheticCount;
        int failCount = result.getFailureCount() - syntheticCount;
        if (runCount > 50 && failCount > 0) {
            PrivilegedOutput.print("\nMore than 50 tests, ^b^reprinting^r^ test failures for ease of review.\n", new Object[0]);
            junit4RunListener.printFailures();
        }
        PrivilegedOutput.print("\nRan ^b^%d^r^ test%s in ^b^%.3f seconds^r^ with %s%d%s^r^ failure%s and %s%d^r^ ignored.\n", runCount, runCount == 1 ? "" : "s", Float.valueOf((float)result.getRunTime() / 1000.0f), failCount > 0 ? "^red^^i^ " : "^green^", failCount, failCount == 0 ? "" : " ", failCount == 1 ? "" : "s", result.getIgnoreCount() > 0 ? "^yellow^^i^" : "^b^", result.getIgnoreCount());
        PropFile.Prop reportDirProp = Props.get((String)"reports.dir", (Context)Context.named((String)"project"));
        if (failCount > 0 && Output.isInfo() && !PropFile.Prop.Empty.equals((Object)reportDirProp)) {
            PrivilegedOutput.print("^info^ For %sdetailed test report%s: ", failCount == 1 ? "a " : "", failCount == 1 ? "" : "s");
            HashSet<String> encountered = new HashSet<String>(result.getFailureCount());
            for (Failure failure : result.getFailures()) {
                String reportName;
                if (Junit4RunListener.isSyntheticDescription(failure.getDescription()) || !encountered.add(reportName = FileUtil.pathFromParts((String[])new String[]{reportDirProp.value(), MavenReporter.getReportName(failure.getDescription().getClassName())}))) continue;
                PrivilegedOutput.print("^info^     ^b^less %s^r^", reportName);
            }
            PrivilegedOutput.print("", new Object[0]);
        }
        if (failCount != 0) {
            System.exit(1);
        }
    }

    private int countSynthetic(Result result) {
        int synthetic = 0;
        for (Failure failure : result.getFailures()) {
            if (!Junit4RunListener.isSyntheticDescription(failure.getDescription())) continue;
            ++synthetic;
        }
        return synthetic;
    }

    private boolean allSynthetic(Result result) {
        for (Failure failure : result.getFailures()) {
            if (Junit4RunListener.isSyntheticDescription(failure.getDescription())) continue;
            return false;
        }
        return result.getFailureCount() > 0;
    }

    private Set<Class> pruneNonTestAnnotated(Set<Class> classes) {
        HashSet<Class> pruned = new HashSet<Class>(classes.size());
        block0: for (Class clazz : classes) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Test.class) && !method.getName().startsWith("test")) continue;
                pruned.add(clazz);
                continue block0;
            }
        }
        return pruned;
    }
}

