/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.input.ClasspathResource;
import net.ocheyedan.ply.input.FileResource;
import net.ocheyedan.ply.input.Resource;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.script.IntellijUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ProjectUtil {
    public static void updateProject(File projectDir) {
        String projectName = Props.get((String)"name", (Context)Context.named((String)"project")).value();
        IprDocument iprDocument = ProjectUtil.getIprDocument(projectDir, projectName);
        ProjectUtil.setJdk(iprDocument.iprXmlDocument.getDocumentElement());
        Element component = IntellijUtil.findComponent(iprDocument.iprXmlDocument.getDocumentElement(), "ProjectModuleManager");
        Element modules = IntellijUtil.findElement(component, "modules");
        IntellijUtil.removeElements(modules, "module");
        ProjectUtil.addModule(modules, "", iprDocument.projectName);
        List<String> submodules = IntellijUtil.getModules();
        submodules.remove(iprDocument.projectName);
        ProjectUtil.addModules(modules, submodules);
        File projectConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)projectDir), ".ply", "config"});
        ProjectUtil.updateProject(iprDocument, projectConfigDir);
    }

    public static void updateProjectForSubmodule(File owningModuleDir, File submoduleProjectDir) {
        File owningModuleConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)owningModuleDir), ".ply", "config"});
        String projectName = Props.get((String)"name", (Context)Context.named((String)"project"), (Scope)Props.getScope(), (File)owningModuleConfigDir).value();
        IprDocument iprDocument = ProjectUtil.getIprDocument(owningModuleDir, projectName);
        File submoduleProjectConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)submoduleProjectDir), ".ply", "config"});
        ProjectUtil.updateProject(iprDocument, submoduleProjectConfigDir);
    }

    private static void updateProject(IprDocument iprDocument, File projectConfigDir) {
        String localRepoPathMacroName = IntellijUtil.setPlyLocalRepoMacro(iprDocument.projectName);
        ProjectUtil.addLibraryTable(localRepoPathMacroName, iprDocument.iprXmlDocument.getDocumentElement(), projectConfigDir);
        Element usedPathMacros = IntellijUtil.findElement(iprDocument.iprXmlDocument.getDocumentElement(), "UsedPathMacros");
        Element usedMacro = IntellijUtil.findElement(usedPathMacros, "macro", localRepoPathMacroName);
        usedMacro.setAttribute("name", localRepoPathMacroName);
        IntellijUtil.writeXmlDocument(iprDocument.iprXmlFile, iprDocument.iprXmlDocument);
    }

    private static IprDocument getIprDocument(File projectDir, String projectName) {
        String iprFileName = projectName + ".ipr";
        File iprFile = FileUtil.fromParts((String[])new String[]{projectDir.getPath(), iprFileName});
        Document iprDocument = IntellijUtil.readXmlDocument((Resource)new FileResource(iprFile.getPath()), (Resource)new ClasspathResource("etc/ply-intellij/templates/project.xml", ProjectUtil.class.getClassLoader()));
        return new IprDocument(iprDocument, projectName, iprFile);
    }

    private static void addLibraryTable(String localRepoPathMacroName, Element root, File projectConfigDir) {
        Element libraryTableElement = IntellijUtil.findComponent(root, "libraryTable");
        Set<DependencyAtom> allDeps = IntellijUtil.collectDependencies(projectConfigDir);
        allDeps.addAll(IntellijUtil.collectDependencies(projectConfigDir, Scope.named((String)"test")));
        for (DependencyAtom dep : allDeps) {
            String urlValue;
            String libraryName = "Ply: " + dep.getPropertyName() + ":" + dep.getPropertyValueWithoutTransient();
            Element libraryElement = IntellijUtil.findElement(libraryTableElement, "library", libraryName);
            libraryElement.setAttribute("name", libraryName);
            boolean isJar = "jar".equals(dep.getSyntheticPackaging());
            String urlProtocol = dep.getSyntheticPackaging() + "://$" + localRepoPathMacroName + "$";
            String urlBase = FileUtil.pathFromParts((String[])new String[]{urlProtocol, dep.namespace, dep.name, dep.version});
            if (!IntellijUtil.hasElement(libraryElement, "CLASSES")) {
                Element classesElement = IntellijUtil.createElement(libraryElement, "CLASSES");
                Element classesRootElement = IntellijUtil.createElement(classesElement, "root");
                String urlValue2 = FileUtil.pathFromParts((String[])new String[]{urlBase, dep.getArtifactName()});
                if (isJar) {
                    urlValue2 = urlValue2 + "!";
                }
                urlValue2 = urlValue2 + File.separator;
                classesRootElement.setAttribute("url", urlValue2);
            }
            if (!IntellijUtil.hasElement(libraryElement, "JAVADOC")) {
                Element javadocElement = IntellijUtil.createElement(libraryElement, "JAVADOC");
                Element javadocRootElement = IntellijUtil.createElement(javadocElement, "root");
                DependencyAtom javadocDep = dep.withClassifier("javadoc");
                urlValue = FileUtil.pathFromParts((String[])new String[]{urlBase, javadocDep.getArtifactName()});
                if (isJar) {
                    urlValue = urlValue + "!";
                }
                urlValue = urlValue + File.separator;
                javadocRootElement.setAttribute("url", urlValue);
            }
            if (IntellijUtil.hasElement(libraryElement, "SOURCES")) continue;
            Element sourcesElement = IntellijUtil.createElement(libraryElement, "SOURCES");
            Element sourcesRootElement = IntellijUtil.createElement(sourcesElement, "root");
            DependencyAtom sourcesDep = dep.withClassifier("sources");
            urlValue = FileUtil.pathFromParts((String[])new String[]{urlBase, sourcesDep.getArtifactName()});
            if (isJar) {
                urlValue = urlValue + "!";
            }
            urlValue = urlValue + File.separator;
            sourcesRootElement.setAttribute("url", urlValue);
        }
    }

    private static void setJdk(Element content) {
        Context intellijContext = Context.named((String)"intellij");
        Element component = IntellijUtil.findComponent(content, "ProjectRootManager");
        String javaVersion = IntellijUtil.getJavaVersion();
        String jdkName = Props.get((String)"project-jdk-name", (Context)intellijContext).value();
        if (jdkName.isEmpty()) {
            jdkName = javaVersion;
        }
        component.setAttribute("project-jdk-name", jdkName);
        String jdkType = Props.get((String)"project-jdk-type", (Context)intellijContext).value();
        if (!jdkType.isEmpty()) {
            component.setAttribute("project-jdk-type", jdkName);
        }
        IntellijUtil.setLanguageAttribute(component, "languageLevel");
        component.setAttribute("assert-keyword", "true");
        component.setAttribute("jdk-15", "true");
        component = IntellijUtil.findComponent(content, "JavacSettings");
        Element optionElement = IntellijUtil.createElement(component, "option");
        optionElement.setAttribute("ADDITIONAL_OPTIONS_STRING", "-target " + javaVersion);
    }

    private static void addModules(Element modulesElement, List<String> modules) {
        Iterator<String> i$ = modules.iterator();
        while (i$.hasNext()) {
            String module;
            String name = module = i$.next();
            if (module.lastIndexOf(File.separator) != -1) {
                name = name.substring(module.lastIndexOf(File.separator) + 1);
            }
            ProjectUtil.addModule(modulesElement, module, name);
        }
    }

    private static void addModule(Element modulesElement, String baseDir, String name) {
        Element moduleElement = IntellijUtil.createElement(modulesElement, "module");
        String filepath = FileUtil.pathFromParts((String[])new String[]{"$PROJECT_DIR$", baseDir, name + ".iml"});
        moduleElement.setAttribute("fileurl", "file://" + filepath);
        moduleElement.setAttribute("filepath", filepath);
    }

    private ProjectUtil() {
    }

    private static final class IprDocument {
        private final Document iprXmlDocument;
        private final String projectName;
        private final File iprXmlFile;

        private IprDocument(Document iprXmlDocument, String projectName, File iprXmlFile) {
            this.iprXmlDocument = iprXmlDocument;
            this.projectName = projectName;
            this.iprXmlFile = iprXmlFile;
        }
    }
}

