/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.input.ClasspathResource;
import net.ocheyedan.ply.input.FileResource;
import net.ocheyedan.ply.input.Resource;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Filter;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.script.IntellijUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuleUtil {
    public static void updateModule(File projectDir, File owningModule) {
        Context projectContext = Context.named((String)"project");
        String projectName = Props.get((String)"name", (Context)Context.named((String)"project")).value();
        String imlFileName = projectName + ".iml";
        File imlFile = FileUtil.fromParts((String[])new String[]{projectDir.getPath(), imlFileName});
        Document imlDocument = IntellijUtil.readXmlDocument((Resource)new FileResource(imlFile.getPath()), (Resource)new ClasspathResource("etc/ply-intellij/templates/module.xml", ModuleUtil.class.getClassLoader()));
        String projectDirPath = FileUtil.getCanonicalPath((File)projectDir);
        File projectConfigDir = FileUtil.fromParts((String[])new String[]{projectDirPath, ".ply", "config"});
        String packaging = Props.get((String)"packaging", (Context)projectContext, (Scope)Props.getScope(), (File)projectConfigDir).value();
        if ("war".equals(packaging)) {
            // empty if block
        }
        Element component = IntellijUtil.findComponent(imlDocument.getDocumentElement(), "NewModuleRootManager");
        IntellijUtil.setLanguageAttribute(component, "LANGUAGE_LEVEL");
        component.setAttribute("inherit-compiler-output", "false");
        IntellijUtil.removeElements(component, "output");
        IntellijUtil.removeElements(component, "output-test");
        IntellijUtil.removeElements(component, "orderEntry");
        Element inheritedJdkElement = IntellijUtil.createElement(component, "orderEntry");
        inheritedJdkElement.setAttribute("type", "inheritedJdk");
        String outputValue = Props.get((String)"build.path", (Context)Context.named((String)"compiler"), (Scope)Props.getScope(), (File)projectConfigDir).value();
        Element output = IntellijUtil.createElement(component, "output");
        output.setAttribute("url", "file://$MODULE_DIR$/" + outputValue);
        Element content = IntellijUtil.findElement(component, "content");
        IntellijUtil.removeElements(content, "sourceFolder");
        IntellijUtil.removeElements(content, "excludeFolder");
        content.setAttribute("url", "file://$MODULE_DIR$");
        String sourceFolderValue = Props.get((String)"src.dir", (Context)projectContext, (Scope)Props.getScope(), (File)projectConfigDir).value();
        Element sourceFolder = IntellijUtil.createElement(content, "sourceFolder");
        sourceFolder.setAttribute("url", "file://$MODULE_DIR$/" + sourceFolderValue);
        sourceFolder.setAttribute("isTestSource", "false");
        String resourceFolderValue = Props.get((String)"res.dir", (Context)projectContext, (Scope)Props.getScope(), (File)projectConfigDir).value();
        Element resourceFolder = IntellijUtil.createElement(content, "sourceFolder");
        resourceFolder.setAttribute("url", "file://$MODULE_DIR$/" + resourceFolderValue);
        resourceFolder.setAttribute("isTestSource", "false");
        String excludeFolderValue = Props.get((String)"build.dir", (Context)projectContext, (Scope)Props.getScope(), (File)projectConfigDir).value();
        Element excludeFolder = IntellijUtil.createElement(content, "excludeFolder");
        excludeFolder.setAttribute("url", "file://$MODULE_DIR$/" + excludeFolderValue);
        String testOutputValue = ModuleUtil.getTestPropValue("build.path", Context.named((String)"compiler"), projectConfigDir);
        Element testOutput = IntellijUtil.createElement(component, "output-test");
        testOutput.setAttribute("url", "file://$MODULE_DIR$/" + testOutputValue);
        String testSourceFolderValue = ModuleUtil.getTestPropValue("src.dir", projectContext, projectConfigDir);
        Element testSourceFolder = IntellijUtil.createElement(content, "sourceFolder");
        testSourceFolder.setAttribute("url", "file://$MODULE_DIR$/" + testSourceFolderValue);
        testSourceFolder.setAttribute("isTestSource", "true");
        String testResourceFolderValue = ModuleUtil.getTestPropValue("res.dir", projectContext, projectConfigDir);
        Element testResourceFolder = IntellijUtil.createElement(content, "sourceFolder");
        testResourceFolder.setAttribute("url", "file://$MODULE_DIR$/" + testResourceFolderValue);
        testResourceFolder.setAttribute("isTestSource", "true");
        Element sourceFolderElement = IntellijUtil.createElement(component, "orderEntry");
        sourceFolderElement.setAttribute("type", "sourceFolder");
        sourceFolderElement.setAttribute("forTests", "false");
        ModuleUtil.addDependencies(component, projectDir, owningModule);
        IntellijUtil.writeXmlDocument(imlFile, imlDocument);
    }

    private static void addDependencies(Element to, File projectDir, File owningModule) {
        List<String> modules;
        Scope defaultScope = Scope.named((String)Props.get((String)"scope", (Context)Context.named((String)"ply")).value());
        Scope testScope = Scope.named((String)"test");
        File projectConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)projectDir), ".ply", "config"});
        if (owningModule != null) {
            File owningModuleConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)owningModule), ".ply", "config"});
            modules = IntellijUtil.getModules(owningModuleConfigDir);
        } else {
            modules = IntellijUtil.getModules();
        }
        HashSet<DependencyAtom> excludes = new HashSet<DependencyAtom>();
        excludes.add(ModuleUtil.getSelf());
        excludes.addAll(ModuleUtil.addDependencies(to, projectConfigDir, defaultScope, "", modules, excludes));
        ModuleUtil.addDependencies(to, projectConfigDir, testScope, "TEST", modules, excludes);
    }

    private static DependencyAtom getSelf() {
        DependencyAtom self = Deps.getProjectDep();
        return new DependencyAtom(self.namespace, self.name, self.version, self.getArtifactName(), self.transientDep);
    }

    private static Set<DependencyAtom> addDependencies(Element to, File projectConfigDir, Scope scope, String intellijScope, List<String> modules, Set<DependencyAtom> excludes) {
        Set<DependencyAtom> dependencies = IntellijUtil.collectDependencies(projectConfigDir, scope);
        for (DependencyAtom dep : dependencies) {
            if (excludes.contains(dep)) continue;
            Element orderEntry = IntellijUtil.createElement(to, "orderEntry");
            if (ModuleUtil.isModule(dep, modules)) {
                orderEntry.setAttribute("type", "module");
                orderEntry.setAttribute("module-name", dep.name);
            } else {
                orderEntry.setAttribute("type", "library");
                orderEntry.setAttribute("name", "Ply: " + dep.getPropertyName() + ":" + dep.getPropertyValueWithoutTransient());
                orderEntry.setAttribute("level", "project");
            }
            if (intellijScope.isEmpty()) continue;
            orderEntry.setAttribute("scope", intellijScope);
        }
        return dependencies;
    }

    private static boolean isModule(DependencyAtom dep, List<String> modules) {
        if (modules == null) {
            return false;
        }
        Iterator<String> i$ = modules.iterator();
        while (i$.hasNext()) {
            String module;
            String moduleName = module = i$.next();
            if (module.endsWith("/") || module.endsWith("\\")) {
                moduleName = moduleName.substring(0, moduleName.length() - 1);
            }
            if (moduleName.lastIndexOf(File.separator) != -1) {
                moduleName = moduleName.substring(module.lastIndexOf(File.separator) + 1);
            }
            if (!moduleName.equals(dep.name)) continue;
            return true;
        }
        return false;
    }

    private static String getTestPropValue(String propertyName, Context context, File projectConfigDir) {
        PropFile systemPropFile;
        PropFile localPropFile;
        String propertyFileName = context.name + ".test.properties";
        String localPath = FileUtil.pathFromParts((String[])new String[]{FileUtil.getCanonicalPath((File)projectConfigDir), propertyFileName});
        if (new File(localPath).exists() && (localPropFile = PropFiles.load((String)localPath, (boolean)false, (boolean)true)) != null && localPropFile.contains(propertyName)) {
            PropFile.Prop prop = localPropFile.get(propertyName);
            return Filter.filter((String)prop.value(), (Context)prop.context(), (String)String.valueOf(System.identityHashCode(prop.value())), (Map)Props.get());
        }
        String systemPath = FileUtil.pathFromParts((String[])new String[]{FileUtil.getCanonicalPath((File)PlyUtil.SYSTEM_CONFIG_DIR), propertyFileName});
        if (new File(systemPath).exists() && (systemPropFile = PropFiles.load((String)systemPath, (boolean)false, (boolean)true)) != null) {
            PropFile.Prop prop = systemPropFile.get(propertyName);
            return Filter.filter((String)prop.value(), (Context)prop.context(), (String)String.valueOf(System.identityHashCode(prop.value())), (Map)Props.get());
        }
        return "";
    }
}

