/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.input.FileResource;
import net.ocheyedan.ply.input.Resource;
import net.ocheyedan.ply.jna.JnaUtil;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Filter;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class IntellijUtil {
    public static List<String> getModules() {
        Scope scope = IntellijUtil.getSubmodulesScope();
        return IntellijUtil.getModules(Props.get((Context)Context.named((String)"submodules"), (Scope)scope), Props.get((String)"name", (Context)Context.named((String)"project")).value());
    }

    public static List<String> getModules(File projectConfigDir) {
        String projectName = Props.get((String)"name", (Context)Context.named((String)"project"), (Scope)Props.getScope(), (File)projectConfigDir).value();
        return IntellijUtil.getModules(Props.get((Context)Context.named((String)"submodules"), (Scope)IntellijUtil.getSubmodulesScope(), (File)projectConfigDir), projectName);
    }

    private static List<String> getModules(PropFileChain submodules, String projectName) {
        ArrayList<String> submoduleNames = new ArrayList<String>();
        for (PropFile.Prop submodule : submodules.props()) {
            if ("exclude".equals(submodule.value())) continue;
            submoduleNames.add(submodule.name);
        }
        if (!projectName.isEmpty()) {
            submoduleNames.add(projectName);
        }
        return submoduleNames;
    }

    public static String setPlyLocalRepoMacro(String projectName) {
        File intellijDir;
        String localRepoValue = Props.get((String)"localRepo", (Context)Context.named((String)"depmngr")).value();
        String systemLocalRepoValue = IntellijUtil.getSystemLocalRepo();
        systemLocalRepoValue = Filter.filter((String)systemLocalRepoValue, (Context)Context.named((String)"depmngr"), (String)systemLocalRepoValue, (Map)Props.get());
        RepositoryAtom localRepo = RepositoryAtom.parse((String)localRepoValue);
        String plyRepoPathMacroName = "PLY_REPO";
        if (!localRepoValue.equals(systemLocalRepoValue)) {
            plyRepoPathMacroName = plyRepoPathMacroName + "_" + projectName;
        }
        if ((intellijDir = IntellijUtil.getAndSaveIntellijDirectory()) == null || !intellijDir.exists()) {
            Output.print((String)"^error^ Could not determine your user's Intellij configuration directory.", (Object[])new Object[0]);
            Output.print((String)"^error^ see http://www.jetbrains.com/idea/webhelp/project-and-ide-settings.html#topicSeeAlsoTopicsList", (Object[])new Object[0]);
            Output.print((String)"^error^ going to continue by assuming existence of intellij path-macro of PLY_REPO=%s", (Object[])new Object[]{localRepo.getPropertyName()});
            return "PLY_REPO";
        }
        File intellijConfigOptionsDir = JnaUtil.getOperatingSystem() == JnaUtil.Os.OSX ? FileUtil.fromParts((String[])new String[]{intellijDir.getPath(), "options"}) : FileUtil.fromParts((String[])new String[]{intellijDir.getPath(), "config", "options"});
        if (!intellijConfigOptionsDir.exists()) {
            Output.print((String)"^error^ Found something which looks like an Intellij configuration directory (%s)", (Object[])new Object[]{intellijDir.getPath()});
            Output.print((String)"^error^ However it does not contain the ^b^options^r^ sub-directory.", (Object[])new Object[0]);
            Output.print((String)"^error^ see http://www.jetbrains.com/idea/webhelp/project-and-ide-settings.html#topicSeeAlsoTopicsList", (Object[])new Object[0]);
            Output.print((String)"^error^ going to continue by assuming existence of intellij path-macro of PLY_REPO=%s", (Object[])new Object[]{localRepo.getPropertyName()});
            return "PLY_REPO";
        }
        File pathMacrosXmlFile = FileUtil.fromParts((String[])new String[]{intellijConfigOptionsDir.getPath(), "path.macros.xml"});
        Document pathMacrosXmlFileDoc = IntellijUtil.readXmlDocument((Resource)new FileResource(pathMacrosXmlFile.getPath()), null);
        if (pathMacrosXmlFileDoc == null) {
            Output.print((String)"^error^ Could not open the ^b^path.macros.xml^r^ file within ^b^%s^r^", (Object[])new Object[]{intellijConfigOptionsDir.getPath()});
            Output.print((String)"^error^ going to continue by assuming existence of intellij path-macro of PLY_REPO=%s", (Object[])new Object[]{localRepo.getPropertyName()});
            return "PLY_REPO";
        }
        Element componentElement = IntellijUtil.findComponent(pathMacrosXmlFileDoc.getDocumentElement(), "PathMacrosImpl");
        String localRepoPath = localRepo.getPropertyName();
        localRepoPath = FileUtil.stripFileUriPrefix((String)localRepoPath);
        Element plyRepoPathMacroElement = IntellijUtil.findMacroElementByNameAndValue(componentElement, plyRepoPathMacroName, localRepoPath);
        plyRepoPathMacroElement.setAttribute("value", localRepoPath);
        IntellijUtil.writeXmlDocument(pathMacrosXmlFile, pathMacrosXmlFileDoc);
        return plyRepoPathMacroName;
    }

    private static Element findMacroElementByNameAndValue(Element componentElement, String macroName, String macroValue) {
        Element childElement;
        Node child;
        int i;
        NodeList children = componentElement.getElementsByTagName("macro");
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!(child instanceof Element) || !(childElement = (Element)child).hasAttribute("name") || !macroName.equals(childElement.getAttribute("name"))) continue;
            return childElement;
        }
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!(child instanceof Element) || !(childElement = (Element)child).hasAttribute("value") || !macroValue.equals(childElement.getAttribute("value"))) continue;
            return childElement;
        }
        Element createdElement = IntellijUtil.createElement(componentElement, "macro");
        createdElement.setAttribute("name", macroName);
        return createdElement;
    }

    private static String getSystemLocalRepo() {
        Scope scope = Props.getScope();
        String path = FileUtil.pathFromParts((String[])new String[]{PlyUtil.SYSTEM_CONFIG_DIR.getPath(), "depmngr" + scope.getFileSuffix() + ".properties"});
        PropFile systemDepmngrProps = PropFiles.load((String)path, (boolean)false, (boolean)false);
        if (!systemDepmngrProps.contains("localRepo")) {
            return null;
        }
        return systemDepmngrProps.get("localRepo").value();
    }

    private static File getIntellijDirectory() {
        String userHome = System.getProperty("user.home");
        File userHomeBasePath = JnaUtil.getOperatingSystem() == JnaUtil.Os.OSX ? FileUtil.fromParts((String[])new String[]{userHome, "Library", "Preferences"}) : new File(userHome);
        if (!userHomeBasePath.exists()) {
            return null;
        }
        File[] intellijDirectories = userHomeBasePath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(".IntelliJIdea") || name.startsWith(".IdeaIC") || name.startsWith("IntelliJIdea") || name.startsWith("IdeaIC");
            }
        });
        if (intellijDirectories == null || intellijDirectories.length == 0) {
            return null;
        }
        if (intellijDirectories.length > 1 && !PlyUtil.isHeadless()) {
            return IntellijUtil.getChosenDirectory(intellijDirectories);
        }
        return intellijDirectories[0];
    }

    private static File getAndSaveIntellijDirectory() {
        PropFile.Prop configDirProp = Props.get((String)"config.dir", (Context)Context.named((String)"intellij"));
        File configDir = new File(configDirProp.value());
        if (PropFile.Prop.Empty.equals((Object)configDirProp) || !configDir.exists()) {
            configDir = IntellijUtil.getIntellijDirectory();
            if (configDir == null) {
                return null;
            }
            String configDirValue = FileUtil.getCanonicalPath((File)configDir);
            PropFile intellijSystemPropFile = new PropFile(Context.named((String)"intellij"), PropFile.Loc.System);
            String systemConfigIntellijPath = FileUtil.getCanonicalPath((File)FileUtil.fromParts((String[])new String[]{PlyUtil.SYSTEM_CONFIG_DIR.getPath(), "intellij.properties"}));
            PropFiles.load((String)systemConfigIntellijPath, (PropFile)intellijSystemPropFile, (boolean)true, (boolean)false);
            intellijSystemPropFile.add("config.dir", configDirValue);
            PropFiles.store((PropFile)intellijSystemPropFile, (String)systemConfigIntellijPath, (boolean)true);
        }
        return configDir;
    }

    private static File getChosenDirectory(File[] intellijDirectories) {
        String options = "[num|abort]";
        Output.print((String)"^ply^ Found multiple Intellij config directories:", (Object[])new Object[0]);
        int choice = 1;
        for (File intellijDirectory : intellijDirectories) {
            Output.print((String)"^ply^ [^b^%d^r^] %s", (Object[])new Object[]{choice++, intellijDirectory.getPath()});
        }
        System.out.println(String.format("^no_line^^ply^ use configuration from %s? ", options));
        try {
            while (true) {
                CharBuffer buffer = CharBuffer.allocate(Math.max(Integer.valueOf(intellijDirectories.length).toString().length() + 1, "abort".length()));
                new InputStreamReader(System.in).read(buffer);
                buffer.rewind();
                String answer = buffer.toString().trim();
                Integer answerAsNumber = null;
                try {
                    answerAsNumber = Integer.parseInt(answer);
                }
                catch (NumberFormatException nfe) {
                    answerAsNumber = null;
                }
                if (answerAsNumber != null) {
                    int index = answerAsNumber - 1;
                    if (index >= 0 && index < intellijDirectories.length) {
                        return intellijDirectories[index];
                    }
                    System.out.println(String.format("^no_line^^ply^ ^red^invalid number^r^; must be between %d and %d, parse configuration %s ", 1, intellijDirectories.length, options));
                    continue;
                }
                if ("abort".equals(answer)) break;
                System.out.println(String.format("^no_line^^ply^ ^red^invalid option^r^, parse configuration %s ", options));
            }
            return null;
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            return null;
        }
    }

    public static Set<DependencyAtom> collectDependencies(File projectConfigDir) {
        return IntellijUtil.collectDependencies(projectConfigDir, Props.getScope());
    }

    public static Set<DependencyAtom> collectDependencies(File projectConfigDir, Scope scope) {
        PropFile properties = Deps.getResolvedProperties((File)projectConfigDir, (Scope)scope, (boolean)false);
        HashSet<DependencyAtom> dependencyAtoms = new HashSet<DependencyAtom>(properties.size());
        for (PropFile.Prop dependencyAtom : properties.props()) {
            DependencyAtom parsed = DependencyAtom.parse((String)dependencyAtom.name, null);
            if (parsed != null) {
                dependencyAtoms.add(parsed);
                continue;
            }
            Output.print((String)"^warn^ Could not parse dependency ^b^%s^r^.", (Object[])new Object[]{dependencyAtom.name});
        }
        return dependencyAtoms;
    }

    public static Document readXmlDocument(Resource xmlResource, Resource altXmlResource) throws SystemExit {
        InputStream stream;
        block10: {
            Resource resource = xmlResource;
            if (xmlResource == null || xmlResource.getOntology() == Resource.Ontology.DoesNotExist) {
                resource = altXmlResource;
            }
            if (resource == null) {
                return null;
            }
            stream = null;
            try {
                stream = resource.open();
            }
            catch (IOException ioe) {
                if (resource != xmlResource) break block10;
                try {
                    stream = altXmlResource.open();
                }
                catch (IOException altIoe) {
                    Output.print((Throwable)altIoe);
                    throw new SystemExit(1);
                }
            }
        }
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
        }
        catch (ParserConfigurationException pce) {
            Output.print((Throwable)pce);
            throw new SystemExit(1);
        }
        catch (SAXException saxe) {
            Output.print((Throwable)saxe);
            throw new SystemExit(1);
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            throw new SystemExit(1);
        }
    }

    public static void writeXmlDocument(File file, Document document) throws SystemExit {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            Output.print((Throwable)tce);
            throw new SystemExit(1);
        }
        catch (TransformerException te) {
            Output.print((Throwable)te);
            throw new SystemExit(1);
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
            throw new SystemExit(1);
        }
    }

    public static Element findComponent(Element element, String attributeValue) {
        return IntellijUtil.findElement(element, "component", attributeValue);
    }

    public static Element findElement(Element element, String elementName, String attributeValue) {
        NodeList children = element.getElementsByTagName(elementName);
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Node child = children.item(i);
            if (!(child instanceof Element) || !(childElement = (Element)child).hasAttribute("name") || !attributeValue.equals(childElement.getAttribute("name"))) continue;
            return childElement;
        }
        Element createdElement = IntellijUtil.createElement(element, elementName);
        createdElement.setAttribute("name", attributeValue);
        return createdElement;
    }

    public static Element findElement(Element element, String elementName) {
        NodeList elements = element.getElementsByTagName(elementName);
        if (elements == null || elements.getLength() == 0) {
            return IntellijUtil.createElement(element, elementName);
        }
        return (Element)elements.item(0);
    }

    protected static Element createElement(Element element, String name) {
        Element child = element.getOwnerDocument().createElement(name);
        element.appendChild(child);
        return child;
    }

    public static boolean hasElement(Element element, String elementName) {
        NodeList elements = element.getElementsByTagName(elementName);
        return elements != null && elements.getLength() != 0;
    }

    public static void removeElements(Element from, String named) {
        NodeList children = from.getChildNodes();
        boolean removeNextNewline = false;
        ArrayList<Node> removes = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child != null && named.equals(child.getNodeName())) {
                removes.add(child);
                removeNextNewline = true;
                continue;
            }
            if (removeNextNewline && child != null && child instanceof Text && child.getNodeValue().trim().isEmpty()) {
                removes.add(child);
                continue;
            }
            removeNextNewline = false;
        }
        for (Node node : removes) {
            from.removeChild(node);
        }
    }

    public static void setLanguageAttribute(Element component, String attributeName) {
        String languageLevel = Props.get((String)"languageLevel", (Context)Context.named((String)"intellij")).value();
        if (languageLevel.isEmpty()) {
            languageLevel = "JDK_" + IntellijUtil.getJavaVersion().replace(".", "_");
        }
        component.setAttribute(attributeName, languageLevel);
    }

    public static String getJavaVersion() {
        String version = Props.get((String)"java.source", (Context)Context.named((String)"compiler")).value();
        if (version.isEmpty()) {
            version = System.getProperty("java.version");
        }
        if (version.length() > 2 && version.charAt(1) == '.') {
            version = version.substring(0, 3);
        }
        return version;
    }

    public static Scope getSubmodulesScope() {
        PropFile.Prop submodulesScopeProp = Props.get((String)"submodules.scope", (Context)Context.named((String)"project"), (Scope)Props.getScope());
        return PropFile.Prop.Empty.equals((Object)submodulesScopeProp) ? Props.getScope() : Scope.named((String)submodulesScopeProp.value());
    }
}

