/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;
import net.ocheyedan.ply.script.IntellijUtil;
import net.ocheyedan.ply.script.ModuleUtil;
import net.ocheyedan.ply.script.ProjectUtil;

public class IntellijScript {
    public static void main(String[] args) {
        File owningModuleDir;
        String plyProjectPath = Props.get((String)"project.dir", (Context)Context.named((String)"ply")).value();
        File projectDir = FileUtil.fromParts((String[])new String[]{plyProjectPath, ".."});
        if (!projectDir.exists()) {
            Output.print((String)"^error^ Could not determine project directory [ ^b^%s^r^ ].", (Object[])new Object[]{projectDir.getPath()});
            System.exit(1);
        }
        if ((owningModuleDir = IntellijScript.getOwningModule(projectDir)) != null) {
            Output.print((String)"^info^ Updating submodule %s for owning project %s", (Object[])new Object[]{plyProjectPath, owningModuleDir.getName()});
            ProjectUtil.updateProjectForSubmodule(owningModuleDir, projectDir);
        } else {
            ProjectUtil.updateProject(projectDir);
        }
        ModuleUtil.updateModule(projectDir, owningModuleDir);
        Output.print((String)"Successfully created file-based Intellij structure.", (Object[])new Object[0]);
    }

    private static File getOwningModule(File projectDir) {
        boolean isSubmodule = false;
        File parentDir = projectDir;
        String moduleName = "";
        String projectDirPath = FileUtil.getCanonicalPath((File)projectDir);
        int i = 0;
        block2: while (!isSubmodule && i++ < 3) {
            File possibleParentConfigDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)parentDir), "..", ".ply", "config"});
            parentDir = FileUtil.fromParts((String[])new String[]{FileUtil.getCanonicalPath((File)possibleParentConfigDir), "..", ".."});
            try {
                moduleName = projectDirPath.substring(FileUtil.getCanonicalPath((File)parentDir).length() + 1);
            }
            catch (IndexOutOfBoundsException ioobe) {
                break;
            }
            Output.print((String)"^dbug^ Checking if %s is a submodule in %s", (Object[])new Object[]{moduleName, possibleParentConfigDir.getPath()});
            if (!possibleParentConfigDir.exists()) continue;
            Scope scope = IntellijUtil.getSubmodulesScope();
            Output.print((String)"^dbug^ Using scope %s to get submodules for %s", (Object[])new Object[]{scope.name, possibleParentConfigDir.getPath()});
            PropFileChain parentSubmodules = Props.get((Context)Context.named((String)"submodules"), (Scope)scope, (File)possibleParentConfigDir);
            for (PropFile.Prop parentSubmodule : parentSubmodules.props()) {
                if (!parentSubmodule.name.equals(moduleName)) continue;
                isSubmodule = true;
                continue block2;
            }
        }
        return isSubmodule ? parentDir : null;
    }
}

