/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import net.ocheyedan.ply.Output;

public class FileFilterer {
    private static final int BUF_SIZE = 8192;
    private final File file;
    private final Provider provider;

    public FileFilterer(File file, Provider provider) {
        this.file = file;
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter() {
        AbstractInterruptibleChannel fc = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
            fc = randomAccessFile.getChannel();
            ByteBuffer readBuf = ByteBuffer.allocateDirect(8192);
            long position = 0L;
            int read = 0;
            int totalRead = 0;
            do {
                int numberRead = 0;
                do {
                    read = ((FileChannel)fc).read(readBuf);
                    numberRead += read;
                } while (read != -1 && readBuf.hasRemaining() && (long)(totalRead += read) < ((FileChannel)fc).size());
                String converted = readBuf.asCharBuffer().toString();
                converted = this.provider.filter(converted);
                ByteBuffer writeBuf = ByteBuffer.wrap(converted.getBytes(), 0, numberRead);
                ((FileChannel)fc).position(position);
                while (writeBuf.hasRemaining()) {
                    ((FileChannel)fc).write(writeBuf);
                }
                readBuf.rewind();
            } while ((long)totalRead < ((FileChannel)fc).size());
        }
        catch (IOException ioe) {
            Output.print((Throwable)ioe);
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
    }

    public static interface Provider {
        public String filter(String var1);
    }
}

