/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Scope {
    public static final Scope Default = new Scope("");
    private static final Map<String, Scope> interned = new ConcurrentHashMap<String, Scope>();
    public final String name;

    public static Scope named(String name) {
        if (name == null || name.isEmpty()) {
            return Default;
        }
        if (interned.containsKey(name)) {
            return interned.get(name);
        }
        Scope scope = new Scope(name);
        interned.put(name, scope);
        return scope;
    }

    public Scope(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getFileSuffix() {
        return this.name == null || this.name.isEmpty() ? "" : "." + this.name;
    }

    public String getPrettyPrint() {
        return this.name == null || this.name.isEmpty() ? "" : "^b^" + this.name + "^r^ ";
    }

    public String getScriptPrefix() {
        return this.name == null || this.name.isEmpty() ? "" : this.name + ":";
    }

    public String getAdHocSuffix() {
        return this.name == null || this.name.isEmpty() ? "" : "#" + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope = (Scope)o;
        return this.name == null ? scope.name == null : this.name.equals(scope.name);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }
}

