/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileReader;
import net.ocheyedan.ply.props.PropFileWriter;
import net.ocheyedan.ply.props.Scope;

public final class PropFiles {
    public static boolean load(String path, PropFile into) throws PropFileReader.Invalid {
        return PropFiles.load(path, PropFileReader.Default, into, false, true);
    }

    public static boolean load(String path, PropFile into, boolean create) throws PropFileReader.Invalid {
        return PropFiles.load(path, PropFileReader.Default, into, create, true);
    }

    public static boolean load(String path, PropFile into, boolean create, boolean printOnFNF) throws PropFileReader.Invalid {
        return PropFiles.load(path, PropFileReader.Default, into, create, printOnFNF);
    }

    public static PropFile load(String path, boolean create, boolean nullOnFNF) throws PropFileReader.Invalid {
        Context context;
        if (path == null) {
            throw new NullPointerException("The path to load must not be null.");
        }
        String name = new File(path).getPath();
        if (name.endsWith(".properties")) {
            name = name.substring(0, name.length() - ".properties".length());
        }
        Scope scope = Scope.Default;
        if (name.contains(".")) {
            int index = name.indexOf(".");
            context = Context.named(name.substring(0, index));
            scope = Scope.named(name.substring(index + 1));
        } else {
            context = Context.named(name);
        }
        PropFile propFile = new PropFile(context, scope, PropFile.Loc.System);
        if (PropFiles.load(path, PropFileReader.Default, propFile, create, nullOnFNF)) {
            return propFile;
        }
        if (nullOnFNF) {
            return null;
        }
        return propFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(String path, PropFileReader propFileReader, PropFile into, boolean create, boolean printOnFNF) throws PropFileReader.Invalid {
        if (path == null || propFileReader == null || into == null) {
            throw new NullPointerException("The path to load and the PropFile must not be null.");
        }
        File propertiesFile = new File(path);
        BufferedReader reader = null;
        try {
            if (create && !propertiesFile.exists()) {
                propertiesFile.getParentFile().mkdirs();
                propertiesFile.createNewFile();
            }
            reader = new BufferedReader(new FileReader(propertiesFile));
            propFileReader.load(reader, into);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            if (printOnFNF) {
                Output.print("Cannot load properties file, %s, it does not exist.", path);
                Output.print(fnfe);
            }
        }
        catch (IOException ioe) {
            Output.print(ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
        return false;
    }

    public static boolean store(PropFile propFile, String to) {
        return PropFiles.store(propFile, PropFileWriter.Default, to, false);
    }

    public static boolean store(PropFile propFile, String to, boolean create) {
        return PropFiles.store(propFile, PropFileWriter.Default, to, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean store(PropFile propFile, PropFileWriter propFileWriter, String to, boolean create) {
        if (propFile == null || propFileWriter == null || to == null) {
            return false;
        }
        to = FileUtil.stripFileUriPrefix(to);
        File propertiesFile = new File(to);
        BufferedWriter writer = null;
        try {
            if (create && !propertiesFile.exists()) {
                propertiesFile.getParentFile().mkdirs();
                propertiesFile.createNewFile();
            } else if (!create && !propertiesFile.exists()) {
                boolean bl = false;
                return bl;
            }
            writer = new BufferedWriter(new FileWriter(propertiesFile));
            propFileWriter.store(writer, propFile);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            Output.print("Cannot store properties file, %s, it does not exist.", to);
            Output.print(fnfe);
        }
        catch (IOException ioe) {
            Output.print("^error^ Cannot store properties file, %s", to);
            Output.print(ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            }
        }
        return false;
    }

    public static String getFileName(PropFile propFile) {
        Context context = propFile.context();
        Scope scope = propFile.scope();
        return String.format("%s%s.properties", context.name, scope.getFileSuffix());
    }

    private PropFiles() {
    }
}

