/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ocheyedan.ply.props.PropFile;

public interface PropFileWriter {
    public static final PropFileWriter Default = new PropFileWriter(){
        final Pattern commentRegex = Pattern.compile("([^\r\n&&[^\r]&&[^\n]]+)");

        @Override
        public void store(BufferedWriter writer, PropFile propFile) throws IOException {
            for (PropFile.Prop prop : propFile.props()) {
                if (!prop.comments().isEmpty()) {
                    Matcher matcher = this.commentRegex.matcher(prop.comments());
                    while (matcher.find()) {
                        String comment = matcher.group();
                        writer.write(String.format("#%s%n", comment));
                    }
                }
                String line = this.escape(prop);
                writer.write(String.format("%s%n", line));
            }
        }

        private String escape(PropFile.Prop prop) {
            String key = this.escape(prop.name);
            String value = this.escape(prop.unfilteredValue);
            return String.format("%s=%s", key, value);
        }

        private String escape(String string) {
            StringBuilder buffer = new StringBuilder();
            for (char character : string.toCharArray()) {
                switch (character) {
                    case '=': {
                        buffer.append('\\');
                    }
                }
                buffer.append(character);
            }
            return buffer.toString();
        }
    };

    public void store(BufferedWriter var1, PropFile var2) throws IOException;
}

