/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Filter;
import net.ocheyedan.ply.props.PropFile;

public final class PropFileChain {
    private final Impl delegate;
    private final Iterable<PropFile.Prop> props;

    PropFileChain(Map<Context, PropFileChain> filterConsultant) {
        this(Impl.Empty, filterConsultant);
    }

    PropFileChain(PropFileChain defaultChain, Map<Context, PropFileChain> filterConsultant) {
        this(defaultChain == null ? Impl.Empty : defaultChain.delegate, filterConsultant);
    }

    private PropFileChain(Impl defaultChain, Map<Context, PropFileChain> filterConsultant) {
        this.delegate = new Impl(defaultChain, filterConsultant);
        this.props = new Iterable<PropFile.Prop>(){

            @Override
            public Iterator<PropFile.Prop> iterator() {
                return PropFileChain.this.delegate.iterator();
            }
        };
    }

    void set(PropFile propFile, PropFile.Loc at) {
        if (propFile == null || at == null) {
            throw new NullPointerException("PropFile and PropFile.Loc must not be null.");
        }
        this.delegate.set(propFile, at);
    }

    public PropFile.Prop get(String named) {
        return this.delegate.get(named);
    }

    public final Iterable<PropFile.Prop> props() {
        return this.props;
    }

    final void invalidateFilteredCache() {
        this.delegate.filteredCache.clear();
    }

    private static class Impl {
        private static final Impl Empty = new Impl(null, Collections.emptyMap()){

            @Override
            protected PropFile.Prop get(String named) {
                return PropFile.Prop.Empty;
            }

            @Override
            protected PropFile.Prop internalGet(String named) {
                return PropFile.Prop.Empty;
            }

            @Override
            protected Iterator<PropFile.Prop> iterator() {
                return PropFile.EmptyIterator;
            }
        };
        private final List<PropFile> chain = new ArrayList<PropFile>(3);
        private final Impl defaultChain;
        private final Map<Context, PropFileChain> filterConsultant;
        private final Map<String, PropFile.Prop> filteredCache;

        private Impl(Impl defaultChain, Map<Context, PropFileChain> filterConsultant) {
            this.chain.add(PropFile.Empty);
            this.chain.add(PropFile.Empty);
            this.chain.add(PropFile.Empty);
            this.defaultChain = defaultChain;
            this.filterConsultant = filterConsultant;
            this.filteredCache = new ConcurrentHashMap<String, PropFile.Prop>();
        }

        private void set(PropFile propFile, PropFile.Loc at) {
            this.filteredCache.clear();
            switch (at) {
                case AdHoc: {
                    this.chain.set(0, propFile);
                    break;
                }
                case Local: {
                    this.chain.set(1, propFile);
                    break;
                }
                case System: {
                    this.chain.set(2, propFile);
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unsupported PropFile.Loc value %s", at.name()));
                }
            }
        }

        protected PropFile.Prop get(String named) {
            PropFile.Prop unfiltered;
            if (this.filteredCache.containsKey(named)) {
                return this.filteredCache.get(named);
            }
            PropFile.Prop filtered = unfiltered = this.internalGet(named);
            if (PropFile.Prop.Empty != unfiltered) {
                filtered = Filter.filter(unfiltered, String.valueOf(System.identityHashCode(this)), this.filterConsultant);
            }
            this.filteredCache.put(named, filtered);
            return filtered;
        }

        protected PropFile.Prop internalGet(String named) {
            for (PropFile propFile : this.chain) {
                PropFile.Prop prop;
                if (propFile == PropFile.Empty || (prop = propFile.get(named)) == PropFile.Prop.Empty) continue;
                return prop;
            }
            return this.defaultChain.get(named);
        }

        protected Iterator<PropFile.Prop> iterator() {
            return new ImplIterator(this.chain, this.defaultChain){

                @Override
                public PropFile.Prop next() {
                    if (!this.incremented) {
                        this.hasNext();
                    }
                    this.incremented = false;
                    return Impl.this.get(this.current.name);
                }
            };
        }

        private static abstract class ImplIterator
        implements Iterator<PropFile.Prop> {
            final Set<PropFile.Prop> encountered = new HashSet<PropFile.Prop>();
            int index = 0;
            Iterator<PropFile.Prop> curIter;
            PropFile.Prop current = PropFile.Prop.Empty;
            boolean incremented = false;
            boolean hasNext = true;
            final List<PropFile> chain;
            final Impl defaultChain;

            private ImplIterator(List<PropFile> chain, Impl defaultChain) {
                this.chain = chain;
                this.defaultChain = defaultChain;
            }

            @Override
            public boolean hasNext() {
                if (this.incremented) {
                    return this.hasNext;
                }
                this.incremented = true;
                if (this.curIter == null || !this.curIter.hasNext()) {
                    if (this.index < 3) {
                        this.curIter = this.chain.get(this.index++).props().iterator();
                    } else if (this.index++ == 3) {
                        this.curIter = this.defaultChain.iterator();
                    } else {
                        this.hasNext = false;
                        return false;
                    }
                }
                while ((this.hasNext = this.curIter.hasNext()) && !this.encountered.add(this.current = this.curIter.next())) {
                }
                if (!this.hasNext && this.index < 4) {
                    this.incremented = false;
                    return this.hasNext();
                }
                return this.hasNext;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

