/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.EmptyConcurrentMap;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Scope;

public final class PropFile {
    public static final PropFile Empty = new PropFile(Context.named(""), Scope.Default, Loc.System, Impl.access$000());
    static final Iterator<Prop> EmptyIterator = new Iterator<Prop>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Prop next() {
            return Prop.Empty;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private final Impl delegate;
    private final Iterable<Prop> props;

    public PropFile(Context context, Loc loc) {
        this(context, Scope.Default, loc);
    }

    public PropFile(Context context, Scope scope, Loc loc) {
        this(context, scope, loc, null);
    }

    private PropFile(Context context, Scope scope, Loc loc, Impl delegate) {
        if (context == null || scope == null || loc == null) {
            throw new NullPointerException("Context|Scope|Loc cannot be null.");
        }
        this.delegate = delegate == null ? new Impl(context, scope, loc) : delegate;
        this.props = new Iterable<Prop>(){

            @Override
            public Iterator<Prop> iterator() {
                return PropFile.this.delegate.iterator();
            }
        };
    }

    public final Prop add(String name, String value) {
        return this.delegate.add(name, value, "", null);
    }

    public final Prop add(String name, String value, String comments) {
        return this.delegate.add(name, value, comments, null);
    }

    public final Prop set(String name, String value) {
        return this.delegate.set(name, value);
    }

    public final boolean contains(String name) {
        return this.delegate.contains(name);
    }

    public final Prop get(String name) {
        return this.delegate.get(name);
    }

    public final int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public final Prop remove(String name) {
        return this.delegate.remove(name);
    }

    public final Iterable<Prop> props() {
        return this.props;
    }

    final Context context() {
        return this.delegate.context;
    }

    final Scope scope() {
        return this.delegate.scope;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.delegate.equals(((PropFile)o).delegate);
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    private static class Impl {
        private static final Impl Empty = new Impl(Context.named(""), Scope.Default, Loc.System, (ConcurrentMap)EmptyConcurrentMap.get(), Collections.emptyList()){

            @Override
            protected boolean contains(String name) {
                return false;
            }

            @Override
            protected Prop get(String name) {
                return Prop.Empty;
            }

            @Override
            protected int size() {
                return 0;
            }

            @Override
            protected boolean isEmpty() {
                return true;
            }

            @Override
            protected Iterator<Prop> iterator() {
                return EmptyIterator;
            }

            @Override
            public boolean equals(Object o) {
                return this == o;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }
        };
        private final Context context;
        private final Scope scope;
        private final Loc loc;
        private final ConcurrentMap<String, Prop> props;
        private final List<Prop> order;

        private Impl(Context context, Scope scope, Loc loc) {
            this(context, scope, loc, new ConcurrentHashMap<String, Prop>(), new ArrayList<Prop>());
        }

        private Impl(Context context, Scope scope, Loc loc, ConcurrentMap<String, Prop> props, List<Prop> order) {
            this.context = context;
            this.scope = scope;
            this.loc = loc;
            this.props = props;
            this.order = order;
        }

        private Prop add(String name, String value, String comments, Integer at) {
            Prop prop;
            Prop existing = this.props.putIfAbsent(name = name.trim(), prop = new Prop(this, name, value, comments));
            if (existing == null) {
                if (at == null) {
                    this.order.add(prop);
                } else {
                    this.order.add(at, prop);
                }
            } else {
                prop = existing;
            }
            return prop;
        }

        private Prop set(String name, String value) {
            Prop newlyAdded;
            if (this.props.containsKey(name)) {
                int index = this.order.indexOf(this.props.get(name));
                Prop old = this.remove(name);
                newlyAdded = this.add(name, value, old.comments(), index);
            } else {
                newlyAdded = this.add(name, value, "", null);
            }
            return newlyAdded;
        }

        protected boolean contains(String name) {
            return this.props.containsKey(name);
        }

        protected Prop get(String name) {
            return this.props.containsKey(name) ? (Prop)this.props.get(name) : Prop.Empty;
        }

        protected int size() {
            return this.order.size();
        }

        protected boolean isEmpty() {
            return this.order.isEmpty();
        }

        private Prop remove(String name) {
            Prop removed = (Prop)this.props.remove(name);
            if (removed != null) {
                this.order.remove(removed);
            }
            return removed;
        }

        protected Iterator<Prop> iterator() {
            return this.order.iterator();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (o == Empty) {
                return false;
            }
            Impl impl = (Impl)o;
            return this.context.equals(impl.context) && this.scope.equals(impl.scope) && this.loc == impl.loc;
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = 31 * result + this.scope.hashCode();
            result = 31 * result + this.loc.hashCode();
            return result;
        }

        static /* synthetic */ Impl access$000() {
            return Empty;
        }
    }

    public static enum Loc {
        System,
        Local,
        AdHoc;

    }

    public static final class Prop
    implements Comparable<Prop> {
        public static final Prop Empty = new Prop(Impl.access$000(), "", "", "");
        public final String name;
        public final String unfilteredValue;
        private final Impl owner;
        private final AtomicReference<String> comments;
        private final AtomicReference<String> filteredValue;
        private final AtomicReference<String> filteredValueMarked;

        Prop(Impl owner, String name, String unfilteredValue, String comments) {
            if (name == null || owner == null) {
                throw new NullPointerException("Properties' names cannot be null.");
            }
            this.name = name;
            this.unfilteredValue = unfilteredValue;
            this.owner = owner;
            this.comments = new AtomicReference<String>(comments);
            this.filteredValue = new AtomicReference<String>(unfilteredValue);
            this.filteredValueMarked = new AtomicReference<String>(unfilteredValue);
        }

        public final String comments() {
            return this.comments.get();
        }

        public final String value() {
            return this.filteredValue.get();
        }

        public final String valueDecorated() {
            return this.filteredValueMarked.get();
        }

        public final Context context() {
            return this.owner.context;
        }

        public final Scope scope() {
            return this.owner.scope;
        }

        public final Loc loc() {
            return this.owner.loc;
        }

        final Prop withComments(String comments) {
            this.comments.set(comments);
            return this;
        }

        final Prop with(String filteredValue, String filteredValueMarked) {
            Prop filtered = new Prop(this.owner, this.name, this.unfilteredValue, this.comments.get());
            filtered.filteredValue.set(filteredValue);
            filtered.filteredValueMarked.set(filteredValueMarked);
            return filtered;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Prop that = (Prop)o;
            return this.name.equals(that.name) && this.owner.context.equals(that.owner.context);
        }

        public int hashCode() {
            int result = this.owner.context.hashCode();
            return 31 * result + this.name.hashCode();
        }

        @Override
        public int compareTo(Prop prop) {
            if (prop == null) {
                return 1;
            }
            int nameCompare = this.name.compareTo(prop.name);
            if (nameCompare != 0) {
                return nameCompare;
            }
            return this.owner.context.compareTo(prop.owner.context);
        }
    }
}

