/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.util.ArrayList;
import java.util.List;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;

public class PrefixedProps {
    public static List<String> getArguments(Context context, String propertyPrefix) {
        return PrefixedProps.getArguments(context, propertyPrefix, "");
    }

    public static List<String> getArguments(Context context, String propertyPrefix, String separator) {
        PropFileChain chain = Props.get(context);
        return PrefixedProps.getArguments(chain, propertyPrefix, separator);
    }

    public static List<String> getArguments(PropFileChain props, String propertyPrefix) {
        return PrefixedProps.getArguments(props, propertyPrefix, "");
    }

    public static List<String> getArguments(PropFileChain props, String propertyPrefix, String separator) {
        ArrayList<String> arguments = new ArrayList<String>(1);
        for (PropFile.Prop prop : props.props()) {
            if (!prop.name.startsWith(propertyPrefix) || prop.name.length() <= propertyPrefix.length()) continue;
            String keyName = prop.name.substring(propertyPrefix.length());
            String keyValue = prop.value();
            arguments.add(String.format("%s%s", keyName, PrefixedProps.isEmpty(keyValue) ? "" : String.format("%s%s", separator, keyValue)));
        }
        return arguments;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

