/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.props.AdHoc;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

final class Loader {
    static final FilenameFilter PROPERTIES_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".properties") && !name.startsWith(".");
        }
    };
    private static final Map<String, Map<Scope, Map<Context, PropFileChain>>> cache = new ConcurrentHashMap<String, Map<Scope, Map<Context, PropFileChain>>>(3, 1.0f);
    private static final AtomicBoolean systemCacheLoaded = new AtomicBoolean(false);
    private static final Map<Scope, Map<Context, PropFile>> systemCache = new ConcurrentHashMap<Scope, Map<Context, PropFile>>(3, 1.0f);

    static Map<Scope, Map<Context, PropFileChain>> load(File configurationDirectory) {
        String cacheKey = FileUtil.getCanonicalPath(configurationDirectory);
        if (cache.containsKey(cacheKey)) {
            return cache.get(cacheKey);
        }
        Map<Scope, Map<Context, PropFileChain>> loaded = Loader.shouldLoadFromEnv(configurationDirectory) ? Loader.loadFromEnv() : Loader.loadChain(configurationDirectory);
        cache.put(cacheKey, loaded);
        return loaded;
    }

    static void invalidateCaches(File configurationDirectory) {
        String cacheKey = FileUtil.getCanonicalPath(configurationDirectory);
        cache.remove(cacheKey);
    }

    private static boolean shouldLoadFromEnv(File configDirectory) {
        return configDirectory == PlyUtil.LOCAL_CONFIG_DIR && System.getenv("ply_ply.invoker") != null;
    }

    private static Map<Scope, Map<Context, PropFileChain>> loadFromEnv() {
        ConcurrentHashMap<Scope, Map<Context, PropFileChain>> props = new ConcurrentHashMap<Scope, Map<Context, PropFileChain>>(2, 1.0f);
        Scope scope = Props.getScope();
        ConcurrentHashMap<Context, PropFileChain> contexts = new ConcurrentHashMap<Context, PropFileChain>(13, 1.0f);
        props.put(scope, contexts);
        ConcurrentHashMap<Context, PropFile> propFiles = new ConcurrentHashMap<Context, PropFile>(13, 1.0f);
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            if (!key.startsWith("ply_")) continue;
            String propertyValue = env.get(key);
            int index = (key = key.substring(4)).indexOf(".");
            if (index == -1) continue;
            Context context = Context.named(key.substring(0, index));
            key = key.substring(index + 1);
            PropFile propFile = (PropFile)propFiles.get(context);
            if (propFile == null) {
                propFile = new PropFile(context, scope, PropFile.Loc.System);
                propFiles.put(context, propFile);
            }
            propFile.add(key, propertyValue);
        }
        for (Context context : propFiles.keySet()) {
            PropFile propFile = (PropFile)propFiles.get(context);
            PropFileChain chain = new PropFileChain(contexts);
            chain.set(propFile, PropFile.Loc.System);
            contexts.put(context, chain);
        }
        return props;
    }

    private static Map<Scope, Map<Context, PropFileChain>> loadChain(File configurationDirectory) {
        if (!systemCacheLoaded.getAndSet(true)) {
            Loader.load(PlyUtil.SYSTEM_CONFIG_DIR, PropFile.Loc.System, systemCache);
        }
        ConcurrentHashMap<Scope, Map<Context, PropFile>> local = new ConcurrentHashMap<Scope, Map<Context, PropFile>>(3, 1.0f);
        Loader.load(configurationDirectory, PropFile.Loc.Local, local);
        Map<Scope, Map<Context, PropFile>> adHoc = AdHoc.produceFor(systemCache, local);
        return Loader.chain(systemCache, local, adHoc);
    }

    private static Map<Scope, Map<Context, PropFileChain>> chain(Map<Scope, Map<Context, PropFile>> system, Map<Scope, Map<Context, PropFile>> local, Map<Scope, Map<Context, PropFile>> adHoc) {
        ConcurrentHashMap<Scope, Map<Context, PropFileChain>> chain = new ConcurrentHashMap<Scope, Map<Context, PropFileChain>>(3, 1.0f);
        ConcurrentHashMap<Context, PropFileChain> defaultScopeChain = new ConcurrentHashMap<Context, PropFileChain>(13, 1.0f);
        chain.put(Scope.Default, defaultScopeChain);
        Set<Scope> allScopes = Loader.collectScopes(system, local, adHoc);
        Set<Context> allContexts = Loader.collectContexts(system, local, adHoc);
        Loader.chain(system.containsKey(Scope.Default) ? system.get(Scope.Default) : Collections.emptyMap(), local.containsKey(Scope.Default) ? local.get(Scope.Default) : Collections.emptyMap(), adHoc.containsKey(Scope.Default) ? adHoc.get(Scope.Default) : Collections.emptyMap(), defaultScopeChain, allContexts, null);
        for (Scope scope : allScopes) {
            if (Scope.Default.equals(scope)) continue;
            Map<Context, PropFile> systemFiles = system.get(scope);
            Map<Context, PropFile> localFiles = local.get(scope);
            Map<Context, PropFile> adHocFiles = adHoc.get(scope);
            ConcurrentHashMap<Context, PropFileChain> scopedChain = new ConcurrentHashMap<Context, PropFileChain>(13, 1.0f);
            chain.put(scope, scopedChain);
            Loader.chain(systemFiles == null ? Collections.emptyMap() : systemFiles, localFiles == null ? Collections.emptyMap() : localFiles, adHocFiles == null ? Collections.emptyMap() : adHocFiles, scopedChain, allContexts, defaultScopeChain);
        }
        return chain;
    }

    private static void chain(Map<Context, PropFile> system, Map<Context, PropFile> local, Map<Context, PropFile> adHoc, Map<Context, PropFileChain> chain, Set<Context> allContexts, Map<Context, PropFileChain> defaultChain) {
        Loader.chain(system, PropFile.Loc.System, chain, allContexts, defaultChain);
        Loader.chain(local, PropFile.Loc.Local, chain, allContexts, defaultChain);
        Loader.chain(adHoc, PropFile.Loc.AdHoc, chain, allContexts, defaultChain);
    }

    private static void chain(Map<Context, PropFile> files, PropFile.Loc loc, Map<Context, PropFileChain> chain, Set<Context> contexts, Map<Context, PropFileChain> defaultChain) {
        for (Context context : contexts) {
            PropFileChain contextChain = chain.get(context);
            if (contextChain == null) {
                PropFileChain contextDefault = defaultChain == null ? null : defaultChain.get(context);
                contextChain = new PropFileChain(contextDefault, chain);
                chain.put(context, contextChain);
            }
            if (!files.containsKey(context)) continue;
            contextChain.set(files.get(context), loc);
        }
    }

    private static Set<Scope> collectScopes(Map<Scope, Map<Context, PropFile>> system, Map<Scope, Map<Context, PropFile>> local, Map<Scope, Map<Context, PropFile>> adHoc) {
        HashSet<Scope> scopes = new HashSet<Scope>(system.keySet());
        scopes.addAll(local.keySet());
        scopes.addAll(adHoc.keySet());
        return scopes;
    }

    private static Set<Context> collectContexts(Map<Scope, Map<Context, PropFile>> system, Map<Scope, Map<Context, PropFile>> local, Map<Scope, Map<Context, PropFile>> adHoc) {
        HashSet<Context> contexts = new HashSet<Context>();
        for (Scope scope : system.keySet()) {
            contexts.addAll(system.get(scope).keySet());
        }
        for (Scope scope : local.keySet()) {
            contexts.addAll(local.get(scope).keySet());
        }
        for (Scope scope : adHoc.keySet()) {
            contexts.addAll(adHoc.get(scope).keySet());
        }
        return contexts;
    }

    private static void load(File configurationDirectory, PropFile.Loc loc, Map<Scope, Map<Context, PropFile>> into) {
        File[] subFiles = configurationDirectory.listFiles(PROPERTIES_FILENAME_FILTER);
        if (subFiles == null) {
            return;
        }
        for (File subFile : subFiles) {
            Context context;
            if (subFile.isDirectory()) continue;
            String fileName = subFile.getName();
            int index = fileName.lastIndexOf(".properties");
            fileName = fileName.substring(0, index);
            Scope scope = Scope.Default;
            if (fileName.lastIndexOf(".") != -1) {
                index = fileName.lastIndexOf(".");
                context = new Context(fileName.substring(0, index));
                scope = new Scope(fileName.substring(index + 1));
            } else {
                context = new Context(fileName.substring(0, index));
            }
            Map<Context, PropFile> contexts = into.get(scope);
            if (contexts == null) {
                contexts = new HashMap<Context, PropFile>(12, 1.0f);
                into.put(scope, contexts);
            }
            PropFile propFile = new PropFile(context, scope, loc);
            PropFiles.load(FileUtil.getCanonicalPath(subFile), propFile);
            contexts.put(context, propFile);
        }
    }

    private Loader() {
    }
}

