/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public final class AdHoc {
    static final Map<Scope, Map<Context, PropFile>> adHocProps = new ConcurrentHashMap<Scope, Map<Context, PropFile>>(3, 1.0f);

    public static void add(List<String> adHocProps) {
        if (adHocProps == null) {
            return;
        }
        for (String adHocProp : adHocProps) {
            AdHoc.parseAndAdd(adHocProp);
        }
    }

    static Map<Scope, Map<Context, PropFile>> produceFor(Map<Scope, Map<Context, PropFile>> system, Map<Scope, Map<Context, PropFile>> local) {
        PropFile adHocPropFile;
        Map<Context, PropFile> contexts;
        Map<Context, PropFile> adHocContexts;
        Map<Context, PropFile> existingContexts;
        ConcurrentHashMap<Scope, Map<Context, PropFile>> adHocPropFiles = new ConcurrentHashMap<Scope, Map<Context, PropFile>>(3, 1.0f);
        for (Scope scope : system.keySet()) {
            existingContexts = adHocProps.get(scope);
            if (existingContexts == null) {
                existingContexts = new ConcurrentHashMap<Context, PropFile>(13, 1.0f);
                adHocProps.put(scope, existingContexts);
            }
            adHocContexts = new ConcurrentHashMap(13, 1.0f);
            adHocPropFiles.put(scope, adHocContexts);
            contexts = system.get(scope);
            for (Context context : contexts.keySet()) {
                adHocPropFile = existingContexts.get(context);
                if (adHocPropFile == null) {
                    adHocPropFile = new PropFile(context, scope, PropFile.Loc.AdHoc);
                    existingContexts.put(context, adHocPropFile);
                }
                adHocContexts.put(context, adHocPropFile);
            }
        }
        for (Scope scope : local.keySet()) {
            existingContexts = adHocProps.get(scope);
            if (existingContexts == null) {
                existingContexts = new ConcurrentHashMap<Context, PropFile>(13, 1.0f);
                adHocProps.put(scope, existingContexts);
            }
            if ((adHocContexts = (Map)adHocPropFiles.get(scope)) == null) {
                adHocContexts = new ConcurrentHashMap(13, 1.0f);
                adHocPropFiles.put(scope, adHocContexts);
            }
            contexts = local.get(scope);
            for (Context context : contexts.keySet()) {
                adHocPropFile = existingContexts.get(context);
                if (adHocPropFile == null) {
                    adHocPropFile = new PropFile(context, scope, PropFile.Loc.AdHoc);
                    existingContexts.put(context, adHocPropFile);
                }
                if (adHocContexts.containsKey(context)) continue;
                adHocContexts.put(context, adHocPropFile);
            }
        }
        for (Scope scope : adHocProps.keySet()) {
            ConcurrentHashMap<Context, PropFile> contexts2 = (ConcurrentHashMap<Context, PropFile>)adHocPropFiles.get(scope);
            if (contexts2 == null) {
                contexts2 = new ConcurrentHashMap<Context, PropFile>(12, 1.0f);
                adHocPropFiles.put(scope, contexts2);
            }
            Map<Context, PropFile> existing = adHocProps.get(scope);
            for (Context context : existing.keySet()) {
                if (contexts2.containsKey(context)) continue;
                contexts2.put(context, existing.get(context));
            }
        }
        return adHocPropFiles;
    }

    public static Map<Scope, Map<Context, PropFile>> get() {
        return Collections.unmodifiableMap(adHocProps);
    }

    static void parseAndAdd(String prop) {
        if (prop == null) {
            return;
        }
        try {
            PropFile adHocPropFile;
            String scope;
            String context;
            int index = prop.indexOf("#");
            if (index != -1) {
                context = prop.substring(0, index);
                int n = index + 1;
                index = prop.indexOf(".", index);
                scope = prop.substring(n, index);
            } else {
                index = prop.indexOf(".");
                context = prop.substring(0, index);
                scope = "";
            }
            int n = index + 1;
            index = prop.indexOf("=", index);
            String propName = prop.substring(n, index);
            String propValue = prop.substring(index + 1);
            Context propContext = Context.named(context);
            Scope propScope = Scope.named(scope);
            Map<Context, PropFile> contexts = adHocProps.get(propScope);
            if (contexts == null) {
                contexts = new ConcurrentHashMap<Context, PropFile>(12, 1.0f);
                adHocProps.put(propScope, contexts);
            }
            if ((adHocPropFile = contexts.get(propContext)) == null) {
                adHocPropFile = new PropFile(propContext, propScope, PropFile.Loc.AdHoc);
                contexts.put(propContext, adHocPropFile);
                Props.addAdHoc(propScope, propContext, adHocPropFile);
            }
            if (adHocPropFile.contains(propName)) {
                PropFile.Prop adHocProp = adHocPropFile.get(propName);
                Output.print("^warn^ Found two ad-hoc property values for ^b^%s%s.%s^r^ [ ^b^%s^r^ and ^b^%s^r^ ] using first encountered, ^b^%s^r^", context, propScope.getAdHocSuffix(), propName, adHocProp.value(), propValue, adHocProp.value());
            } else {
                adHocPropFile.add(propName, propValue);
            }
        }
        catch (Exception e) {
            Output.print("^error^ Could not parse ad-hoc property ^b^%s^r^.", prop);
        }
    }
}

