/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.input;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.input.Resource;

public class UrlResource
implements Resource {
    private final String name;
    private final URL url;
    private final AtomicReference<InputStream> ref;
    private final Map<String, String> headers;

    public UrlResource(String url, Map<String, String> headers) throws MalformedURLException {
        this.name = url;
        this.url = new URL(url);
        this.ref = new AtomicReference();
        this.headers = headers;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public InputStream open() throws IOException {
        URLConnection urlConnection = this.url.openConnection();
        if (this.headers != null && urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        this.ref.set(urlConnection.getInputStream());
        return this.ref.get();
    }

    @Override
    public Resource.Ontology getOntology() {
        return Resource.Ontology.Unknown;
    }

    @Override
    public void close() {
        InputStream stream = this.ref.get();
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }
    }
}

