/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public final class InterruptibleInputReader
extends InputStreamReader {
    private static final long DEFAULT_PAUSE_MS = 100L;
    private final long pauseMs;

    public InterruptibleInputReader(InputStream in) {
        this(in, 100L);
    }

    public InterruptibleInputReader(InputStream in, long pauseMs) {
        super(in);
        this.pauseMs = pauseMs;
    }

    public InterruptibleInputReader(InputStream in, String charsetName, long pauseMs) throws UnsupportedEncodingException {
        super(in, charsetName);
        this.pauseMs = pauseMs;
    }

    public InterruptibleInputReader(InputStream in, Charset cs, long pauseMs) {
        super(in, cs);
        this.pauseMs = pauseMs;
    }

    public InterruptibleInputReader(InputStream in, CharsetDecoder dec, long pauseMs) {
        super(in, dec);
        this.pauseMs = pauseMs;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException, InterruptedRuntimeException {
        while (!Thread.currentThread().isInterrupted()) {
            if (this.ready()) {
                return super.read(cbuf, off, len);
            }
            try {
                Thread.sleep(this.pauseMs);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new InterruptedRuntimeException((Throwable)ie);
            }
        }
        throw new InterruptedRuntimeException(null);
    }

    @Override
    public int read() throws IOException, InterruptedRuntimeException {
        return super.read();
    }

    @Override
    public int read(CharBuffer target) throws IOException, InterruptedRuntimeException {
        return super.read(target);
    }

    @Override
    public int read(char[] cbuf) throws IOException, InterruptedRuntimeException {
        return super.read(cbuf);
    }

    public String readLine() throws IOException, InterruptedRuntimeException {
        StringBuilder buffer = new StringBuilder();
        char[] charBuffer = new char[1];
        int read;
        while ((read = this.read(charBuffer, 0, charBuffer.length)) != -1) {
            if (read <= 0) continue;
            if (charBuffer[0] == '\n' || charBuffer[0] == '\r') {
                return buffer.toString();
            }
            buffer.append(charBuffer[0]);
        }
        return null;
    }

    public final class InterruptedRuntimeException
    extends RuntimeException {
        public InterruptedRuntimeException(Throwable cause) {
            super(cause);
        }
    }
}

