/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.input.Resource;

public class FileResource
implements Resource {
    private final String name;
    private final File file;
    private final AtomicReference<InputStream> ref;

    public FileResource(String file) {
        this.name = file;
        file = FileUtil.stripFileUriPrefix(file);
        file = FileUtil.resolveUnixTilde(file);
        this.file = new File(file);
        this.ref = new AtomicReference();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public InputStream open() throws IOException {
        this.ref.set(new FileInputStream(this.file));
        return this.ref.get();
    }

    @Override
    public Resource.Ontology getOntology() {
        return this.file.exists() ? Resource.Ontology.Exists : Resource.Ontology.DoesNotExist;
    }

    @Override
    public void close() {
        InputStream stream = this.ref.get();
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }
    }
}

