/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.input;

import java.io.IOException;
import java.io.InputStream;
import net.ocheyedan.ply.input.Resource;

public class ClasspathResource
implements Resource {
    private final String name;
    private final InputStream stream;

    public ClasspathResource(String resource, ClassLoader classLoader) {
        this.name = resource;
        ClassLoader loader = classLoader == null ? (ClasspathResource.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : ClasspathResource.class.getClassLoader()) : classLoader;
        this.stream = loader.getResourceAsStream(resource);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public InputStream open() throws IOException {
        return this.stream;
    }

    @Override
    public Resource.Ontology getOntology() {
        return Resource.Ontology.Unknown;
    }

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }
    }
}

