/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.graph;

import java.util.List;
import net.ocheyedan.ply.graph.Vertex;

public interface Graph<T> {
    public Vertex<T> addVertex(T var1);

    public void addEdge(Vertex<T> var1, Vertex<T> var2) throws CycleException;

    public void removeEdge(Vertex<T> var1, Vertex<T> var2);

    public Vertex<T> getVertex(T var1);

    public boolean hasVertex(T var1);

    public boolean hasEdge(Vertex<T> var1, Vertex<T> var2);

    public boolean isCyclic();

    public List<Vertex<T>> getVertices();

    public List<Vertex<T>> getRootVertices();

    public static class CycleException
    extends RuntimeException {
        final List<Vertex<?>> cycle;
        final List<Vertex<?>> path;

        public CycleException(String message, List cycle, List path) {
            super(message);
            this.cycle = cycle;
            this.path = path;
        }

        public List<Vertex<?>> getCycle() {
            return this.cycle;
        }

        public boolean isEmptyPath() {
            return this.path == null || this.path.isEmpty();
        }

        public List<Vertex<?>> getPath() {
            return this.path;
        }
    }
}

