/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ocheyedan.ply.graph.CycleDetector;
import net.ocheyedan.ply.graph.Graph;
import net.ocheyedan.ply.graph.Vertex;

public class DirectedAcyclicGraph<T>
implements Graph<T> {
    private final Map<T, Vertex<T>> vertices = new LinkedHashMap<T, Vertex<T>>();

    @Override
    public Vertex<T> addVertex(T of) {
        Vertex<T> vertex;
        if (this.vertices.containsKey(of)) {
            vertex = this.vertices.get(of);
        } else {
            vertex = new Vertex<T>(of);
            this.vertices.put(of, vertex);
        }
        return vertex;
    }

    @Override
    public void addEdge(Vertex<T> from, Vertex<T> to) throws Graph.CycleException {
        if (from == null || to == null || !this.vertices.containsKey(from.getValue()) || !this.vertices.containsKey(to.getValue())) {
            return;
        }
        from.addEdgeTo(to);
        to.addEdgeFrom(from);
        List<Vertex<T>> cycle = CycleDetector.introducesCycle(to);
        if (cycle != null) {
            this.removeEdge(from, to);
            List<Vertex<T>> path = this.getAnyPathToRoot(to);
            String message = String.format("Edge between '%s' and '%s' would introduce a cycle into the graph.", from.getValue().toString(), to.getValue().toString());
            throw new Graph.CycleException(message, cycle, path);
        }
    }

    protected List<Vertex<T>> getAnyPathToRoot(Vertex<T> from) {
        ArrayList<Vertex<T>> path = new ArrayList<Vertex<T>>();
        while (from != null && !from.isRoot()) {
            path.add(from);
            from = from.getAnyParent();
        }
        if (from != null && from.isRoot() && !path.isEmpty()) {
            path.add(from);
        }
        Collections.reverse(path);
        return path;
    }

    @Override
    public void removeEdge(Vertex<T> from, Vertex<T> to) {
        if (from == null || to == null || !this.vertices.containsKey(from.getValue()) || !this.vertices.containsKey(to.getValue())) {
            return;
        }
        from.removeEdgeTo(to);
        to.removeEdgeFrom(from);
    }

    @Override
    public Vertex<T> getVertex(T of) {
        return this.vertices.get(of);
    }

    @Override
    public boolean hasVertex(T of) {
        return this.vertices.containsKey(of);
    }

    @Override
    public boolean hasEdge(Vertex<T> from, Vertex<T> to) {
        return from != null && to != null && this.vertices.containsKey(from.getValue()) && this.vertices.containsKey(to.getValue()) && from.hasEdgeTo(to);
    }

    @Override
    public boolean isCyclic() {
        return false;
    }

    @Override
    public List<Vertex<T>> getVertices() {
        return new ArrayList<Vertex<T>>(this.vertices.values());
    }

    @Override
    public List<Vertex<T>> getRootVertices() {
        ArrayList<Vertex<T>> roots = new ArrayList<Vertex<T>>();
        for (Vertex<T> vertex : this.vertices.values()) {
            if (!vertex.isRoot() || roots.contains(vertex)) continue;
            roots.add(vertex);
        }
        return roots;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Vertex<T> vertex : this.getRootVertices()) {
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append("[ ");
            buffer.append(vertex.toExtendedString());
            buffer.append(" ]");
        }
        return buffer.toString();
    }
}

