/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep.visitors;

import net.ocheyedan.ply.dep.visitors.Dependencies;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

class DependencyVisitors {
    DependencyVisitors() {
    }

    static void addName(String name, Dependencies dependencies) {
        if (name == null) {
            return;
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            name = name.substring(2, name.length() - 1);
        }
        name = name.replace('/', '.');
        dependencies.add(name);
    }

    static void addNames(String[] names, Dependencies dependencies) {
        if (names == null) {
            return;
        }
        for (String name : names) {
            DependencyVisitors.addName(name, dependencies);
        }
    }

    static void addType(Type type, Dependencies dependencies) {
        if (type == null) {
            return;
        }
        switch (type.getSort()) {
            case 9: {
                DependencyVisitors.addType(type.getElementType(), dependencies);
                break;
            }
            case 10: {
                DependencyVisitors.addName(type.getClassName(), dependencies);
            }
        }
    }

    static void addDescription(String description, Dependencies dependencies) {
        DependencyVisitors.addType(Type.getType((String)description), dependencies);
    }

    static void addMethodDescription(String methodDescription, Dependencies dependencies) {
        Type[] types;
        DependencyVisitors.addType(Type.getReturnType((String)methodDescription), dependencies);
        for (Type type : types = Type.getArgumentTypes((String)methodDescription)) {
            DependencyVisitors.addType(type, dependencies);
        }
    }

    static void addSignature(String signature, SignatureVisitor signatureVisitor) {
        if (signature == null) {
            return;
        }
        new SignatureReader(signature).accept(signatureVisitor);
    }

    static void addTypeSignature(String signature, SignatureVisitor signatureVisitor) {
        if (signature == null) {
            return;
        }
        new SignatureReader(signature).acceptType(signatureVisitor);
    }
}

