/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PwdUtil;
import net.ocheyedan.ply.dep.Auth;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

final class GitHubAuth
implements Auth {
    private final String username;
    private final String encryptedPwd;
    private final RepositoryAtom repositoryAtom;
    private final Map<String, String> headers;
    private final File configDir;
    private final Scope scope;

    GitHubAuth(String username, String encryptedPwd, RepositoryAtom repositoryAtom, File configDir, Scope scope) {
        this.username = username;
        this.encryptedPwd = encryptedPwd;
        this.repositoryAtom = repositoryAtom;
        this.headers = new HashMap<String, String>(2, 1.0f);
        this.configDir = configDir;
        this.scope = scope;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getEncryptedPwd() {
        return this.encryptedPwd;
    }

    @Override
    public RepositoryAtom getRepositoryAtom() {
        return this.repositoryAtom;
    }

    @Override
    public String getPropertyValue() {
        return String.format("git:%s:%s", this.username, this.encryptedPwd);
    }

    @Override
    public String getArtifactPath(String remotePathDir, DependencyAtom dependencyAtom) {
        return FileUtil.pathFromParts(remotePathDir, dependencyAtom.getArtifactName());
    }

    @Override
    public String getDependenciesPath(String remotePathDir, String name) {
        return FileUtil.pathFromParts(remotePathDir, name);
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.headers.isEmpty()) {
            String authToken = this.getAuthToken(this.configDir, this.scope);
            if (authToken == null || authToken.isEmpty()) {
                Output.print("^error^ Could not get git-hub auth token for ^b^%s^r^ in repo ^b^%s^r^", this.username, this.repositoryAtom.getPreResolvedUri());
                Output.print("^error^ Fix by running command: ^b^ply repo auth %s git %s^r^", this.repositoryAtom.getPreResolvedUri(), this.username);
                System.exit(1);
            }
            this.headers.put("Authorization", String.format("token %s", authToken));
            this.headers.put("Accept", "application/vnd.github.v3.raw");
        }
        return this.headers;
    }

    @Override
    public void acquireAccess(Auth.Acquisition acquisition) {
        if (!this.createAuthToken(acquisition)) {
            Output.print("^error^ Could not create git-hub auth token for ^b^%s^r^ in repo ^b^%s^r^", this.username, this.repositoryAtom.getPreResolvedUri());
            Output.print("^error^ Perhaps you entered the wrong password?", new Object[0]);
            System.exit(1);
        }
    }

    private String getAuthToken(File configDir, Scope scope) {
        PropFile.Prop authToken = Props.get(this.username, Context.named("repogithub"), scope, configDir);
        if (PropFile.Prop.Empty.equals(authToken)) {
            return null;
        }
        return PwdUtil.decrypt(authToken.value());
    }

    private boolean createAuthToken(Auth.Acquisition acquisition) {
        String authToken = acquisition.getAccess(this.username, this.encryptedPwd);
        if (authToken == null) {
            return false;
        }
        String encrypted = PwdUtil.encrypt(authToken);
        String propsFilePath = FileUtil.pathFromParts(this.configDir.getPath(), "repogithub" + this.scope.getFileSuffix() + ".properties");
        PropFile repogithub = PropFiles.load(propsFilePath, true, false);
        if (repogithub.contains(this.username)) {
            repogithub.remove(this.username);
        }
        repogithub.add(this.username, encrypted);
        return PropFiles.store(repogithub, propsFilePath, true);
    }
}

