/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.dep.Auth;
import net.ocheyedan.ply.dep.ConflictingVersionVisitor;
import net.ocheyedan.ply.dep.Dep;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Repos;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.dep.RepositoryRegistry;
import net.ocheyedan.ply.graph.DirectedAcyclicGraph;
import net.ocheyedan.ply.graph.Graph;
import net.ocheyedan.ply.graph.Graphs;
import net.ocheyedan.ply.graph.Vertex;
import net.ocheyedan.ply.mvn.MavenPom;
import net.ocheyedan.ply.mvn.MavenPomParser;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public final class Deps {
    public static DependencyAtom getMinimumVersion(DependencyAtom left, DependencyAtom right) {
        String leftVersion = left.getPropertyValue();
        String rightVersion = right.getPropertyValue();
        if (leftVersion == null || rightVersion == null || leftVersion.equals(rightVersion)) {
            return null;
        }
        String[] leftVersions = leftVersion.split("\\.");
        String[] rightVersions = rightVersion.split("\\.");
        for (int i = 0; i < leftVersions.length; ++i) {
            String leftCandidate = leftVersions[i];
            String rightCandidate = null;
            if (rightVersions.length > i) {
                rightCandidate = rightVersions[i];
            }
            if (rightCandidate == null) {
                return right;
            }
            if (leftCandidate.startsWith("v") || leftCandidate.startsWith("V")) {
                leftCandidate = leftCandidate.substring(1);
            }
            if (rightCandidate.startsWith("v") || rightCandidate.startsWith("V")) {
                rightCandidate = rightCandidate.substring(1);
            }
            boolean leftRc = false;
            boolean rightRc = false;
            if (leftCandidate.endsWith("-rc")) {
                leftCandidate = leftCandidate.substring(0, leftCandidate.length() - 3);
                leftRc = true;
            }
            if (rightCandidate.endsWith("-rc")) {
                rightCandidate = rightCandidate.substring(0, rightCandidate.length() - 3);
                rightRc = true;
            }
            boolean leftSnapshot = false;
            boolean rightSnapshot = false;
            if (leftCandidate.endsWith("-SNAPSHOT")) {
                leftCandidate = leftCandidate.substring(0, leftCandidate.length() - 9);
                leftSnapshot = true;
            }
            if (rightCandidate.endsWith("-SNAPSHOT")) {
                rightCandidate = rightCandidate.substring(0, rightCandidate.length() - 9);
                rightSnapshot = true;
            }
            try {
                Long leftPortion = Long.valueOf(leftCandidate);
                Long rightPortion = Long.valueOf(rightCandidate);
                if (leftPortion > rightPortion) {
                    return right;
                }
                if (rightPortion > leftPortion) {
                    return left;
                }
                if (leftRc && !rightRc || leftSnapshot && !rightSnapshot) {
                    return left;
                }
                if ((!rightRc || leftRc) && (!rightSnapshot || leftSnapshot)) continue;
                return right;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return rightVersions.length > leftVersion.length() ? left : null;
    }

    public static DirectedAcyclicGraph<Dep> getDependencyGraph(List<DependencyAtom> dependencyAtoms, Set<DependencyAtom> exclusionAtoms, RepositoryRegistry repositoryRegistry) {
        return Deps.getDependencyGraph(dependencyAtoms, exclusionAtoms, repositoryRegistry, null, true);
    }

    public static DirectedAcyclicGraph<Dep> getDependencyGraph(List<DependencyAtom> dependencyAtoms, Set<DependencyAtom> exclusionAtoms, RepositoryRegistry repositoryRegistry, String classifier, boolean failMissingDependency) {
        return Deps.getDependencyGraph(dependencyAtoms, exclusionAtoms, repositoryRegistry, classifier, failMissingDependency, new ConflictingVersionVisitor(){

            @Override
            public void visit(Dep diffVersionDep, Dep resolvedDep, Vertex<Dep> parentVertex, DependencyAtom dependencyAtom, Graph<Dep> graph) {
                Deps.warnAboutMultipleVersions(diffVersionDep, resolvedDep, parentVertex, dependencyAtom, graph);
            }
        });
    }

    public static DirectedAcyclicGraph<Dep> getDependencyGraph(List<DependencyAtom> dependencyAtoms, Set<DependencyAtom> exclusionAtoms, RepositoryRegistry repositoryRegistry, String classifier, boolean failMissingDependency, ConflictingVersionVisitor conflictingVersionVisitor) {
        DirectedAcyclicGraph<Dep> dependencyDAG = new DirectedAcyclicGraph<Dep>();
        HashSet<String> alreadyPrinted = new HashSet<String>(exclusionAtoms == null ? 16 : exclusionAtoms.size());
        Deps.fillDependencyGraph(null, dependencyAtoms, exclusionAtoms, classifier, repositoryRegistry, dependencyDAG, new FillGraphState(), alreadyPrinted, false, failMissingDependency, conflictingVersionVisitor);
        return dependencyDAG;
    }

    private static void fillDependencyGraph(Vertex<Dep> parentVertex, List<DependencyAtom> dependencyAtoms, Set<DependencyAtom> exclusionAtoms, String classifier, RepositoryRegistry repositoryRegistry, DirectedAcyclicGraph<Dep> graph, FillGraphState state, Set<String> alreadyPrinted, boolean pomSufficient, boolean failMissingDependency, ConflictingVersionVisitor conflictingVersionVisitor) {
        if (repositoryRegistry.isEmpty()) {
            Output.print("^error^ No repositories found, cannot resolve dependencies.", new Object[0]);
            SystemExit.exit(1);
        }
        for (DependencyAtom dependencyAtom : dependencyAtoms) {
            Set<Dep> resolved;
            String path;
            Dep resolvedDep;
            if (parentVertex != null && dependencyAtom.transientDep) continue;
            DependencyAtom exclusionCheck = dependencyAtom.withoutClassifier();
            if (parentVertex != null && (exclusionAtoms.contains(exclusionCheck) || exclusionAtoms.contains(dependencyAtom))) {
                String key = String.format("exclusions:%s", dependencyAtom.toString());
                if (alreadyPrinted.contains(key)) continue;
                alreadyPrinted.add(key);
                Output.print("^info^ Skipping excluded dependency ^b^%s^r^.", dependencyAtom.toString());
                continue;
            }
            if (parentVertex == null && exclusionAtoms.contains(dependencyAtom)) {
                Output.print("^error^ Direct dependency ^b^%s^r^ listed in exclusions, remove as dependency or as exclusion.", dependencyAtom.toString());
                SystemExit.exit(1);
            }
            try {
                if (state.resolved.containsKey(dependencyAtom)) {
                    resolvedDep = state.resolved.get(dependencyAtom);
                } else {
                    String key;
                    Set<Dep> alreadyResolved;
                    resolvedDep = Deps.resolveDependency(dependencyAtom, classifier, repositoryRegistry, pomSufficient || dependencyAtom.transientDep, failMissingDependency);
                    if (resolvedDep != null) {
                        state.resolved.put(dependencyAtom, resolvedDep);
                    }
                    if ((alreadyResolved = state.unversionedResolved.get(key = resolvedDep == null ? dependencyAtom.getPropertyName() : resolvedDep.toString())) == null) {
                        alreadyResolved = new HashSet<Dep>(4, 1.0f);
                        state.unversionedResolved.put(key, alreadyResolved);
                    }
                    alreadyResolved.add(resolvedDep);
                }
                if (resolvedDep == null && !failMissingDependency) {
                    if (!Output.isInfo()) continue;
                    Output.print("^info^ Could not resolve dependency ^b^%s^r^.", dependencyAtom.toString());
                    path = Deps.getPathAsString(parentVertex, dependencyAtom);
                    if (path == null) continue;
                    Output.print("^info^ path to unresolved dependency [ %s ].", path);
                    continue;
                }
            }
            catch (Throwable t) {
                Output.print(t);
                resolvedDep = null;
            }
            if (resolvedDep == null) {
                path = Deps.getPathAsString(parentVertex, dependencyAtom);
                if (path != null) {
                    Output.print("^error^ path to missing dependency [ %s ].", path);
                }
                SystemExit.exit(1);
            }
            Vertex<Dep> vertex = graph.addVertex(resolvedDep);
            if (parentVertex != null) {
                try {
                    graph.addEdge(parentVertex, vertex);
                }
                catch (Graph.CycleException gce) {
                    Output.print("^error^ circular dependency [ %s ].", Deps.getCycleAsString(gce));
                    SystemExit.exit(1);
                }
            }
            if ((resolved = state.unversionedResolved.get(resolvedDep.toString())) != null && resolved.size() > 1 && !state.unversionedResolvedAlreadyVisited.contains(resolvedDep.toString())) {
                Dep diffVersionDep = null;
                for (Dep dep : resolved) {
                    if (dep == null || dep.toVersionString().equals(resolvedDep.toVersionString())) continue;
                    diffVersionDep = dep;
                    break;
                }
                if (diffVersionDep != null) {
                    conflictingVersionVisitor.visit(diffVersionDep, resolvedDep, parentVertex, dependencyAtom, graph);
                    state.unversionedResolvedAlreadyVisited.add(resolvedDep.toString());
                }
            }
            if (dependencyAtom.transientDep) continue;
            Deps.fillDependencyGraph(vertex, vertex.getValue().dependencies, exclusionAtoms, classifier, repositoryRegistry, graph, state, alreadyPrinted, true, failMissingDependency, conflictingVersionVisitor);
        }
    }

    private static void warnAboutMultipleVersions(Dep diffVersionDep, Dep resolvedDep, Vertex<Dep> parentVertex, DependencyAtom dependencyAtom, Graph<Dep> graph) {
        Vertex<Dep> diffVersionParent = graph.getVertex(diffVersionDep).getAnyParent();
        String diffVersionPath = Deps.getPathAsString(diffVersionParent, diffVersionDep.dependencyAtom);
        String path = Deps.getPathAsString(parentVertex, dependencyAtom);
        Output.print("^warn^ Dependency graph contains conflicting versions for ^b^%s^r^ [ ^yellow^%s^r^ ] and [ ^yellow^%s^r^ ].", resolvedDep.toString(), diffVersionDep.dependencyAtom.getPropertyValue(), resolvedDep.dependencyAtom.getPropertyValue());
        Output.print("^warn^   ^b^%s^r^ => %s", diffVersionDep.dependencyAtom.getPropertyValue(), diffVersionPath == null ? "<direct dependency>" : diffVersionPath);
        Output.print("^warn^   ^b^%s^r^ => %s", resolvedDep.dependencyAtom.getPropertyValue(), path == null ? "<direct dependency>" : path);
        Output.print("^warn^ You can resolve this warning by excluding one of these versions from your project's dependency graph: ^b^ply dep exclude^r^ [ ^b^%s^r^ | ^b^%s^r^ ]", diffVersionDep.toVersionString(), resolvedDep.toVersionString());
    }

    private static String getCycleAsString(Graph.CycleException gce) {
        int i;
        StringBuilder buffer = new StringBuilder();
        List<Vertex<?>> cycle = gce.getCycle();
        List<Vertex<?>> path = gce.getPath();
        for (i = 0; i < path.size() - 1; ++i) {
            Vertex<?> vertex = path.get(i);
            if (buffer.length() > 0) {
                buffer.append(" -> ");
            }
            buffer.append(((Dep)vertex.getValue()).toVersionString());
        }
        for (i = 0; i < cycle.size(); ++i) {
            boolean decorate;
            if (buffer.length() > 0) {
                buffer.append(" -> ");
            }
            boolean bl = decorate = i == 0 || i == cycle.size() - 1;
            if (decorate) {
                buffer.append("^red^");
            }
            buffer.append(((Dep)cycle.get(i).getValue()).toVersionString());
            if (!decorate) continue;
            buffer.append("^r^");
        }
        return buffer.toString();
    }

    public static String getPathAsString(Vertex<Dep> vertex, DependencyAtom dependencyAtom) {
        if (vertex == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> vertices = new ArrayList<String>();
        while (vertex != null) {
            vertices.add(vertex.getValue().toString());
            vertex = vertex.getAnyParent();
        }
        Collections.reverse(vertices);
        for (String vertexAsString : vertices) {
            if (buffer.length() > 0) {
                buffer.append(" -> ");
            }
            buffer.append(vertexAsString);
        }
        buffer.append(String.format(" -> ^b^%s:%s^r^", dependencyAtom.namespace, dependencyAtom.name));
        return buffer.toString();
    }

    static Dep resolveDependency(DependencyAtom dependencyAtom, String classifier, RepositoryRegistry repositoryRegistry, boolean pomSufficient, boolean failMissingDependency) {
        RepositoryAtom localRepo = repositoryRegistry.localRepository;
        if (repositoryRegistry.syntheticRepository != null && repositoryRegistry.syntheticRepository.containsKey(dependencyAtom)) {
            LocalPaths localPaths = LocalPaths.get(dependencyAtom, localRepo);
            return new Dep(dependencyAtom, repositoryRegistry.syntheticRepository.get(dependencyAtom), localPaths.localDirPath);
        }
        Dep resolved = Deps.resolveDependency(dependencyAtom, classifier, repositoryRegistry, localRepo, pomSufficient);
        if (resolved != null) {
            return resolved;
        }
        if (failMissingDependency) {
            Output.print("^error^ Dependency ^b^%s^r^ not found in any repository; ensure repositories are accessible.", dependencyAtom.toString());
            Output.print("^error^ Project's local repository is ^b^%s^r^.", localRepo.toString());
            int remoteRepoSize = repositoryRegistry.remoteRepositories.size();
            Output.print("^error^ Project has ^b^%d^r^ other repositor%s %s", remoteRepoSize, remoteRepoSize != 1 ? "ies" : "y", remoteRepoSize > 0 ? repositoryRegistry.remoteRepositories.toString() : "");
        }
        return null;
    }

    private static Dep resolveDependency(DependencyAtom dependencyAtom, String classifier, RepositoryRegistry repositoryRegistry, RepositoryAtom localRepo, boolean pomSufficient) {
        LocalPaths localPaths = LocalPaths.get(dependencyAtom, localRepo);
        DependencyAtom pomDependencyAtom = dependencyAtom.with("pom");
        LocalPaths localPomPaths = LocalPaths.get(pomDependencyAtom, localRepo);
        File localDepFile = new File(localPaths.localUrl.getFile());
        File localPomDepFile = new File(localPomPaths.localUrl.getFile());
        if (localDepFile.exists()) {
            return Deps.resolveDependency(dependencyAtom, classifier, localRepo, localPaths.localDirUrlPath, localPaths.localDirPath);
        }
        if (pomSufficient && localPomDepFile.exists()) {
            return Deps.resolveDependency(pomDependencyAtom, classifier, localRepo, localPomPaths.localDirUrlPath, localPomPaths.localDirPath);
        }
        Dep resolved = Deps.resolveDependencyFromRemoteRepos(dependencyAtom, classifier, repositoryRegistry, localPaths, localDepFile);
        if (resolved == null && pomSufficient) {
            resolved = Deps.resolveDependencyFromRemoteRepos(pomDependencyAtom, classifier, repositoryRegistry, localPomPaths, localPomDepFile);
        }
        return resolved;
    }

    private static Dep resolveDependencyFromRemoteRepos(DependencyAtom dependencyAtom, String classifier, RepositoryRegistry repositoryRegistry, LocalPaths localPaths, File localDepFile) {
        List<RepositoryAtom> nonLocalRepos = repositoryRegistry.remoteRepositories;
        for (RepositoryAtom remoteRepo : nonLocalRepos) {
            String remotePathDir;
            if (!Deps.downloadDependencyFromRemoteRepo(remoteRepo, remotePathDir = Deps.getDependencyDirectoryPathForRepo(dependencyAtom, remoteRepo), dependencyAtom, localDepFile)) continue;
            return Deps.resolveDependency(dependencyAtom, classifier, remoteRepo, remotePathDir, localPaths.localDirPath);
        }
        return null;
    }

    private static boolean downloadDependencyFromRemoteRepo(RepositoryAtom remoteRepo, String remotePathDir, DependencyAtom dependencyAtom, File localDepFile) {
        String remotePath;
        String unauthRemotePath = FileUtil.pathFromParts(remotePathDir, dependencyAtom.getArtifactName());
        Auth auth = remoteRepo.getAuth();
        Map<String, String> headers = Collections.emptyMap();
        if (auth != null) {
            remotePath = auth.getArtifactPath(remotePathDir, dependencyAtom);
            headers = auth.getHeaders();
        } else {
            remotePath = unauthRemotePath;
        }
        URL remoteUrl = Deps.getUrl(remotePath);
        return FileUtil.download(remoteUrl, headers, localDepFile, dependencyAtom.toString(), remoteRepo.toString(), true);
    }

    private static Dep resolveDependency(DependencyAtom dependencyAtom, String classifier, RepositoryAtom repositoryAtom, String repoDirPath, String saveToRepoDirPath) {
        PropFile dependenciesFile = Deps.getDependenciesFile(dependencyAtom, repositoryAtom, repoDirPath);
        if (dependenciesFile == null) {
            Output.print("^dbug^ No dependencies file found for %s in repo %s.", dependencyAtom.toString(), repositoryAtom.toString());
            dependenciesFile = new PropFile(Context.named("dependencies"), PropFile.Loc.Local);
        }
        Deps.storeDependenciesFile(dependenciesFile, saveToRepoDirPath);
        List<DependencyAtom> dependencyAtoms = Deps.parse(dependenciesFile, classifier);
        return new Dep(dependencyAtom, dependencyAtoms, saveToRepoDirPath);
    }

    public static List<DependencyAtom> parse(PropFile dependencies, String classifier) {
        ArrayList<DependencyAtom> dependencyAtoms = new ArrayList<DependencyAtom>();
        AtomicReference<Object> error = new AtomicReference<Object>();
        for (PropFile.Prop dependency : dependencies.props()) {
            error.set(null);
            DependencyAtom dependencyAtom = Deps.parse(dependency);
            if (dependencyAtom == null) continue;
            if (classifier == null) {
                dependencyAtoms.add(dependencyAtom);
                continue;
            }
            dependencyAtoms.add(dependencyAtom.withClassifier(classifier));
        }
        return dependencyAtoms;
    }

    public static DependencyAtom parse(PropFile.Prop dependencyProp) {
        if (dependencyProp == null) {
            return null;
        }
        AtomicReference<String> error = new AtomicReference<String>();
        String dependencyValue = dependencyProp.value();
        return Deps.parse(dependencyProp.name, dependencyValue, error);
    }

    private static DependencyAtom parse(String name, String value, AtomicReference<String> error) {
        DependencyAtom dependency = DependencyAtom.parse(name + ":" + value, error);
        if (dependency == null) {
            Output.print("^warn^ Invalid dependency %s:%s; %s", name, value, error.get());
            return null;
        }
        return dependency;
    }

    public static List<DependencyAtom> parseExclusions(PropFile exclusions, String classifier) {
        ArrayList<DependencyAtom> exclusionAtoms = new ArrayList<DependencyAtom>();
        AtomicReference<String> error = new AtomicReference<String>();
        for (PropFile.Prop exclusion : exclusions.props()) {
            if (exclusion.value().contains(" ")) {
                String[] versions;
                for (String version : versions = exclusion.value().split(" ")) {
                    error.set(null);
                    Deps.parseExclusionVersion(exclusion, exclusionAtoms, version, classifier, error);
                }
                continue;
            }
            error.set(null);
            Deps.parseExclusionVersion(exclusion, exclusionAtoms, exclusion.value(), classifier, error);
        }
        return exclusionAtoms;
    }

    private static void parseExclusionVersion(PropFile.Prop exclusion, List<DependencyAtom> exclusionAtoms, String version, String classifier, AtomicReference<String> error) {
        DependencyAtom exclusionAtom = Deps.parse(exclusion.name, version, error);
        if (exclusionAtom == null) {
            return;
        }
        if (classifier == null) {
            exclusionAtoms.add(exclusionAtom);
        } else {
            exclusionAtoms.add(exclusionAtom.withClassifier(classifier));
        }
    }

    public static PropFile convertToResolvedPropertiesFile(DirectedAcyclicGraph<Dep> graph) {
        final PropFile props = new PropFile(Context.named("resolved-deps"), PropFile.Loc.Local);
        Graphs.visit(graph, new Graphs.Visitor<Dep>(){

            @Override
            public void visit(Vertex<Dep> vertex) {
                Dep dep = vertex.getValue();
                if (!vertex.isRoot() && dep.dependencyAtom.transientDep) {
                    return;
                }
                String dependencyAtomKey = dep.dependencyAtom.getPropertyName() + ":" + dep.dependencyAtom.getPropertyValue();
                String location = FileUtil.pathFromParts(dep.localRepositoryDirectory, dep.dependencyAtom.getArtifactName());
                if (!props.contains(dependencyAtomKey)) {
                    props.add(dependencyAtomKey, location);
                }
            }
        });
        return props;
    }

    public static PropFile getResolvedProperties(boolean nullOnFNF) {
        Scope scope = Scope.named(Props.get("scope", Context.named("ply")).value());
        return Deps.getResolvedProperties(PlyUtil.LOCAL_CONFIG_DIR, scope, nullOnFNF);
    }

    public static PropFile getResolvedProperties(File projectConfigDir, Scope scope, boolean nullOnFNF) {
        String buildDir = Props.get("build.dir", Context.named("project"), Props.getScope(), projectConfigDir).value();
        File dependenciesFile = FileUtil.fromParts(FileUtil.getCanonicalPath(FileUtil.fromParts(projectConfigDir.getPath(), "..", "..")), buildDir, "resolved-deps" + scope.getFileSuffix() + ".properties");
        PropFile resolvedDeps = new PropFile(Context.named("resolved-deps"), PropFile.Loc.Local);
        if (!dependenciesFile.exists()) {
            return nullOnFNF ? null : resolvedDeps;
        }
        return PropFiles.load(dependenciesFile.getPath(), false, nullOnFNF);
    }

    public static String getClasspath(PropFile resolvedDependencies, String ... supplemental) {
        StringBuilder classpath = new StringBuilder();
        for (PropFile.Prop resolvedDependency : resolvedDependencies.props()) {
            if (DependencyAtom.isTransient(resolvedDependency.name)) continue;
            classpath.append(resolvedDependency.value());
            classpath.append(File.pathSeparator);
        }
        for (String sup : supplemental) {
            classpath.append(sup);
        }
        return classpath.toString();
    }

    public static DependencyAtom getProjectDep() {
        Context projectContext = Context.named("project");
        String namespace = Props.get("namespace", projectContext).value();
        String name = Props.get("name", projectContext).value();
        String version = Props.get("version", projectContext).value();
        String artifactName = Props.get("artifact.name", projectContext).value();
        return Deps.getDepFromParts(namespace, name, version, artifactName);
    }

    public static DependencyAtom getDepFromParts(String namespace, String name, String version, String artifactName) {
        String defaultArtifactName = Deps.getArtifactName(name, version, "", "jar");
        if (artifactName.equals(defaultArtifactName)) {
            return new DependencyAtom(namespace, name, version);
        }
        return new DependencyAtom(namespace, name, version, artifactName);
    }

    public static String getArtifactName(String name, String version, String classifier, String packaging) {
        String string = packaging = packaging == null || packaging.isEmpty() ? "jar" : packaging;
        if (classifier == null || classifier.isEmpty()) {
            return name + "-" + version + "." + packaging;
        }
        return name + "-" + version + "-" + classifier + packaging;
    }

    public static String getDependencyDirectoryPathForRepo(DependencyAtom dependencyAtom, RepositoryAtom repositoryAtom) {
        String startPath = Repos.getDirectoryPathForRepo(repositoryAtom);
        RepositoryAtom.Type type = repositoryAtom.getResolvedType();
        String namespace = type == RepositoryAtom.Type.ply ? dependencyAtom.namespace : dependencyAtom.namespace.replaceAll("\\.", File.separator);
        String endPath = FileUtil.pathFromParts(namespace, dependencyAtom.name, dependencyAtom.version);
        return FileUtil.pathFromParts(startPath, endPath);
    }

    public static String getDependencyArtifactPathForRepo(DependencyAtom dependencyAtom, RepositoryAtom repositoryAtom) {
        String dependencyDirectoryPath = Deps.getDependencyDirectoryPathForRepo(dependencyAtom, repositoryAtom);
        return FileUtil.pathFromParts(dependencyDirectoryPath, dependencyAtom.getArtifactName());
    }

    public static void addChangedDependency(Scope scope, DependencyAtom dependency) {
        PropFile.Prop localRepoProp = Props.get("localRepo", Context.named("depmngr"), scope, PlyUtil.LOCAL_CONFIG_DIR);
        RepositoryAtom localRepo = RepositoryAtom.parse(localRepoProp.value());
        PropFile changedDeps = Deps.loadChangedDependencies(scope);
        String location = FileUtil.pathFromParts(Deps.getDependencyDirectoryPathForRepo(dependency, localRepo), dependency.getArtifactName());
        if (!changedDeps.contains(dependency.getPropertyName())) {
            changedDeps.add(dependency.getPropertyName(), location);
        }
        Deps.storeDependenciesChangedFile(changedDeps, scope);
    }

    private static PropFile loadChangedDependencies(Scope scope) {
        PropFile propFile;
        String storePath = Deps.getBuildDirStorePath("changed-deps", scope);
        if (!PropFiles.load(storePath, propFile = new PropFile(Context.named("changed-deps"), PropFile.Loc.AdHoc), true, false)) {
            Output.print("^error^Could not load ^b^%s^r^", storePath);
            System.exit(1);
        }
        return propFile;
    }

    private static void storeDependenciesChangedFile(PropFile changedDependencies, Scope scope) {
        String storePath = Deps.getBuildDirStorePath("changed-deps", scope);
        if (!PropFiles.store(changedDependencies, storePath, true)) {
            System.exit(1);
        }
    }

    private static String getBuildDirStorePath(String name, Scope scope) {
        String buildDirPath = Props.get("build.dir", Context.named("project")).value();
        return buildDirPath + (buildDirPath.endsWith(File.separator) ? "" : File.separator) + name + scope.getFileSuffix() + ".properties";
    }

    private static URL getUrl(String path) {
        try {
            path = Deps.ensureProtocol(path);
            return new URI(path.replaceAll("\\\\", "/")).toURL();
        }
        catch (URISyntaxException urise) {
            Output.print(urise);
            Output.print("^error^ for %s", path);
        }
        catch (MalformedURLException murle) {
            Output.print(murle);
            Output.print("^error^ for %s", path);
        }
        catch (IllegalArgumentException iae) {
            Output.print(iae);
            Output.print("^error^ for %s", path);
        }
        return null;
    }

    private static PropFile getDependenciesFile(DependencyAtom dependencyAtom, RepositoryAtom repositoryAtom, String repoDepDir) {
        if (repositoryAtom.getResolvedType() == RepositoryAtom.Type.ply) {
            String path;
            Auth auth = repositoryAtom.getAuth();
            Map<String, String> headers = Collections.emptyMap();
            if (auth != null) {
                path = auth.getDependenciesPath(repoDepDir, "dependencies.properties");
                headers = auth.getHeaders();
            } else {
                path = FileUtil.pathFromParts(repoDepDir, "dependencies.properties");
            }
            return Deps.getDependenciesFromPlyRepo(path, headers);
        }
        DependencyAtom pom = dependencyAtom.withoutClassifier().with("pom");
        String pomName = pom.getArtifactName();
        return Deps.getDependenciesFromMavenRepo(FileUtil.pathFromParts(repoDepDir, pomName), repositoryAtom);
    }

    private static PropFile getDependenciesFromPlyRepo(String urlPath, Map<String, String> headers) {
        URL url = Deps.getUrl(urlPath);
        if (url == null) {
            return null;
        }
        String localPath = FileUtil.getLocalPath(url, headers, urlPath, "[tmp location]");
        if (localPath == null || !new File(localPath).exists()) {
            return null;
        }
        PropFile loaded = PropFiles.load(localPath, false, false);
        if (loaded.isEmpty()) {
            return null;
        }
        return loaded;
    }

    private static PropFile getDependenciesFromMavenRepo(String pomUrlPath, RepositoryAtom repositoryAtom) {
        MavenPomParser mavenPomParser = new MavenPomParser();
        MavenPom mavenPom = mavenPomParser.parsePom(pomUrlPath, repositoryAtom);
        return mavenPom == null ? new PropFile(Context.named("dependencies"), PropFile.Loc.Local) : mavenPom.dependencies;
    }

    private static void storeDependenciesFile(PropFile transitiveDependencies, String localRepoDepDirPath) {
        PropFiles.store(transitiveDependencies, FileUtil.pathFromParts(localRepoDepDirPath, "dependencies.properties").replaceAll("\\\\", "/"), true);
    }

    private static String ensureProtocol(String localPath) {
        if (!localPath.contains(":")) {
            if (!localPath.startsWith("/")) {
                localPath = "/" + localPath;
            }
            localPath = "file://" + localPath;
        }
        return localPath;
    }

    private Deps() {
    }

    private static class FillGraphState {
        Map<DependencyAtom, Dep> resolved = new ConcurrentHashMap<DependencyAtom, Dep>();
        Map<String, Set<Dep>> unversionedResolved = new ConcurrentHashMap<String, Set<Dep>>();
        Set<String> unversionedResolvedAlreadyVisited = new HashSet<String>();

        private FillGraphState() {
        }
    }

    static class LocalPaths {
        final String localPath;
        final URL localUrl;
        final String localDirUrlPath;
        final String localDirPath;

        LocalPaths(String localPath, URL localUrl, String localDirUrlPath, String localDirPath) {
            this.localPath = localPath;
            this.localUrl = localUrl;
            this.localDirUrlPath = localDirUrlPath;
            this.localDirPath = localDirPath;
        }

        static LocalPaths get(DependencyAtom dependencyAtom, RepositoryAtom localRepo) {
            String localDirUrlPath = Deps.getDependencyDirectoryPathForRepo(dependencyAtom, localRepo);
            String localPath = Deps.getDependencyArtifactPathForRepo(dependencyAtom, localRepo);
            URL localUrl = Deps.getUrl(localPath = Deps.ensureProtocol(localPath));
            if (localUrl == null) {
                throw new AssertionError((Object)String.format("The local path is not valid [ %s ]", localPath));
            }
            String localDirPath = FileUtil.stripFileUriPrefix(localDirUrlPath);
            return new LocalPaths(localPath, localUrl, localDirUrlPath, localDirPath);
        }
    }
}

