/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep;

import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependencyAtom {
    public static final String DEFAULT_PACKAGING = "jar";
    private static final Pattern WHITE_SPACE_REGEX = Pattern.compile("\\s");
    public final String namespace;
    public final String name;
    public final String version;
    public final String artifactName;
    public final boolean transientDep;

    public DependencyAtom(String namespace, String name, String version, String artifactName, boolean transientDep) {
        this.namespace = namespace;
        this.name = name;
        this.version = version;
        this.artifactName = artifactName;
        this.transientDep = transientDep;
    }

    public DependencyAtom(String namespace, String name, String version, String artifactName) {
        this(namespace, name, version, artifactName, false);
    }

    public DependencyAtom(String namespace, String name, String version, boolean transientDep) {
        this(namespace, name, version, null, transientDep);
    }

    public DependencyAtom(String namespace, String name, String version) {
        this(namespace, name, version, null, false);
    }

    public String getPropertyName() {
        return this.namespace + ":" + this.name;
    }

    public String getPropertyValue() {
        return this.getPropertyValueWithoutTransient() + this.getTransient();
    }

    public String getPropertyValueWithoutTransient() {
        return (this.version == null ? "" : this.version) + (this.artifactName != null ? ":" + this.artifactName : "");
    }

    public String getResolvedPropertyValue() {
        return this.version + ":" + this.getArtifactName() + this.getTransient();
    }

    public String getArtifactName() {
        return this.artifactName == null ? DependencyAtom.composeArtifact(this.name, this.version, null, DEFAULT_PACKAGING) : this.artifactName;
    }

    private String getTransient() {
        return this.transientDep ? ":transient" : "";
    }

    public DependencyAtom with(String packaging) {
        if (packaging == null || DEFAULT_PACKAGING.equals(packaging)) {
            return new DependencyAtom(this.namespace, this.name, this.version, this.transientDep);
        }
        if (this.artifactName == null) {
            return new DependencyAtom(this.namespace, this.name, this.version, DependencyAtom.composeArtifact(this.name, this.version, null, packaging), this.transientDep);
        }
        int index = this.artifactName.lastIndexOf(".");
        if (index == -1) {
            return new DependencyAtom(this.namespace, this.name, this.version, this.artifactName + "." + packaging, this.transientDep);
        }
        String artifactWithoutPackaging = this.artifactName.substring(0, index);
        return new DependencyAtom(this.namespace, this.name, this.version, artifactWithoutPackaging + "." + packaging, this.transientDep);
    }

    public DependencyAtom withClassifier(String classifier) {
        if (classifier == null || classifier.isEmpty()) {
            return this;
        }
        Matcher whiteSpaceMatcher = WHITE_SPACE_REGEX.matcher(classifier);
        if (whiteSpaceMatcher.find()) {
            throw new IllegalArgumentException("DependencyAtom objects cannot contain whitespace.");
        }
        return new DependencyAtom(this.namespace, this.name, this.version, DependencyAtom.composeArtifact(this.name, this.version, classifier, this.getSyntheticPackaging()), this.transientDep);
    }

    public DependencyAtom withoutClassifier() {
        if (this.artifactName == null) {
            return this;
        }
        String packaging = this.getSyntheticPackaging();
        if (DEFAULT_PACKAGING.equals(packaging)) {
            return new DependencyAtom(this.namespace, this.name, this.version, this.transientDep);
        }
        return new DependencyAtom(this.namespace, this.name, this.version, DependencyAtom.composeArtifact(this.name, this.version, null, packaging), this.transientDep);
    }

    public String getSyntheticPackaging() {
        if (this.artifactName == null) {
            return DEFAULT_PACKAGING;
        }
        int index = this.artifactName.lastIndexOf(".");
        if (index == -1) {
            return DEFAULT_PACKAGING;
        }
        return this.artifactName.substring(index + 1);
    }

    public String toString() {
        return this.getPropertyName() + ":" + this.getResolvedPropertyValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyAtom that = (DependencyAtom)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return this.artifactName == null ? that.artifactName == null : this.artifactName.equals(that.artifactName);
    }

    public int hashCode() {
        int result = this.namespace != null ? this.namespace.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.artifactName != null ? this.artifactName.hashCode() : 0);
        return result;
    }

    public static boolean isTransient(String atom) {
        return atom != null && atom.endsWith(":transient");
    }

    public static String stripTransient(String atom) {
        if (DependencyAtom.isTransient(atom)) {
            atom = atom.substring(0, atom.length() - ":transient".length());
        }
        return atom;
    }

    public static DependencyAtom parse(String atom, AtomicReference<String> error) {
        if (atom == null) {
            return null;
        }
        if ((atom = atom.trim()).contains(" ")) {
            if (error != null) {
                error.set("has spaces which are not allowed in dependency atoms.");
            }
            return null;
        }
        String[] parsed = atom.split(":");
        if (parsed.length < 3 || parsed.length > 5) {
            if (error != null) {
                if (parsed.length == 1 && parsed[0].isEmpty()) {
                    parsed = new String[]{};
                }
                switch (parsed.length) {
                    case 0: {
                        error.set("missing namespace, name and version");
                        break;
                    }
                    case 1: {
                        error.set("missing name and version");
                        break;
                    }
                    default: {
                        error.set("missing version");
                    }
                }
            }
            return null;
        }
        if (parsed.length == 5 && !"transient".equalsIgnoreCase(parsed[4])) {
            error.set("transient");
            return null;
        }
        return parsed.length == 3 ? new DependencyAtom(parsed[0], parsed[1], parsed[2]) : (parsed.length == 4 ? ("transient".equalsIgnoreCase(parsed[3]) ? new DependencyAtom(parsed[0], parsed[1], parsed[2], true) : new DependencyAtom(parsed[0], parsed[1], parsed[2], parsed[3])) : new DependencyAtom(parsed[0], parsed[1], parsed[2], parsed[3], "transient".equalsIgnoreCase(parsed[4])));
    }

    private static String composeArtifact(String name, String version, String classifier, String packaging) {
        if (classifier != null) {
            return name + "-" + version + "-" + classifier + "." + packaging;
        }
        return name + "-" + version + "." + packaging;
    }
}

