/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.dep;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.dep.visitors.DependencyVisitor;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;

public class ClassDeps {
    public void processClassDependencies() {
        String classPath = Props.get("build.path", Context.named("compiler")).value();
        File classPathFile = new File(classPath);
        Set<String> classes = this.collectClasses(classPathFile);
        this.processClassDependencies(classPath, classes);
    }

    public void processClassDependencies(String classPath, Set<String> classes) {
        Map<String, Set<String>> dependencies = this.collectDependencies(classPath, classes);
        String classDepsPath = Props.get("class.deps", Context.named("compiler")).value();
        File classDepsDirectory = new File(classDepsPath);
        if (!classDepsDirectory.exists() && !classDepsDirectory.mkdirs()) {
            Output.print("^error^Could not create directory ^b^%s^r^", classDepsPath);
            SystemExit.exit(1);
        }
        Context context = new Context("classdeps");
        for (Map.Entry<String, Set<String>> entry : dependencies.entrySet()) {
            String className = entry.getKey();
            PropFile propFile = new PropFile(context, PropFile.Loc.AdHoc);
            for (String dependency : entry.getValue()) {
                propFile.add(dependency, "");
            }
            File location = FileUtil.fromParts(classDepsPath, className);
            String fileName = String.format("%s.properties", location.getAbsolutePath());
            PropFiles.store(propFile, fileName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Set<String> getClasses(String pathToJar) {
        Object name;
        ZipInputStream jarInputStream;
        block12: {
            jarInputStream = null;
            HashSet<String> jarClasses = new HashSet<String>();
            jarInputStream = new JarInputStream(new FileInputStream(pathToJar));
            JarEntry entry = null;
            while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                name = entry.getName();
                if (!((String)name).endsWith(".class")) continue;
                jarClasses.add(((String)name).replace('/', '.'));
            }
            name = jarClasses;
            if (jarInputStream == null) break block12;
            try {
                jarInputStream.close();
            }
            catch (IOException ioe) {
                Output.print("^warn^Could not close JAR file ^b^%s^r^", pathToJar);
            }
        }
        return name;
        catch (IOException ioe) {
            Set<String> set;
            block13: {
                try {
                    Output.print("^error^Could not load JAR file ^b^%s^r^", pathToJar);
                    SystemExit.exit(1);
                    set = Collections.emptySet();
                    if (jarInputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jarInputStream != null) {
                        try {
                            jarInputStream.close();
                        }
                        catch (IOException ioe2) {
                            Output.print("^warn^Could not close JAR file ^b^%s^r^", pathToJar);
                        }
                    }
                    throw throwable;
                }
                try {
                    jarInputStream.close();
                }
                catch (IOException ioe3) {
                    Output.print("^warn^Could not close JAR file ^b^%s^r^", pathToJar);
                }
            }
            return set;
        }
    }

    private Set<String> collectClasses(File classPath) {
        File[] subfiles = classPath.listFiles();
        if (subfiles == null) {
            return Collections.emptySet();
        }
        HashSet<String> classes = new HashSet<String>();
        for (File file : subfiles) {
            if (file.isDirectory()) {
                classes.addAll(this.collectClasses(file));
                continue;
            }
            classes.add(file.getAbsolutePath());
        }
        return classes;
    }

    public Map<String, Set<String>> collectDependencies(String classBaseDir, Set<String> filePaths) {
        ConcurrentHashMap<String, String> files = new ConcurrentHashMap<String, String>(filePaths.size(), 1.0f);
        for (String filePath : filePaths) {
            if (!filePath.endsWith(".class")) {
                Output.print("^warn^Given non-class file for dependency capture [ ^b^%s^r^ ]", filePath);
                continue;
            }
            int pathStart = filePath.indexOf(classBaseDir);
            String filePackageClassName = filePath.substring(pathStart + classBaseDir.length());
            int start = filePackageClassName.startsWith(File.separator) ? 1 : 0;
            String packageClassName = filePackageClassName.substring(start, filePackageClassName.length() - 6).replace(File.separatorChar, '.');
            files.put(packageClassName, filePath);
        }
        ConcurrentHashMap<String, Set<String>> dependencies = new ConcurrentHashMap<String, Set<String>>(files.size(), 1.0f);
        this.collectDependencies(files, dependencies);
        return dependencies;
    }

    private void collectDependencies(Map<String, String> files, Map<String, Set<String>> dependencies) {
        for (Map.Entry<String, String> entry : files.entrySet()) {
            this.collectDependencies(entry.getKey(), new File(entry.getValue()), dependencies);
        }
    }

    private void collectDependencies(String className, File classFile, Map<String, Set<String>> inverted) {
        Set<String> dependencies = this.getDependencies(className, classFile);
        for (String dependency : dependencies) {
            Set<String> invertedDependencies = inverted.get(dependency);
            if (invertedDependencies == null) {
                invertedDependencies = new HashSet<String>();
                inverted.put(dependency, invertedDependencies);
            }
            invertedDependencies.add(className);
        }
    }

    public Set<String> getDependencies(String className, File classFile) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(classFile);
        }
        catch (IOException ioe) {
            Output.print(ioe);
            SystemExit.exit(1);
            return Collections.emptySet();
        }
        BufferedInputStream buffer = new BufferedInputStream(inputStream);
        DependencyVisitor visitor = new DependencyVisitor(className);
        visitor.visit(buffer);
        return visitor.getDependencies();
    }
}

