/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.input.InterruptibleInputReader;

public final class SlowTaskThread {
    public static <T> BuilderStart<T> after(long ms) {
        if (ms < 1L) {
            throw new IllegalArgumentException("Wait duration must be greater than 0.");
        }
        return new BuilderStart(ms);
    }

    private static String getAlreadyAnsweredKey(BuilderOngoing.Logging logging, String message) {
        return String.format("%s%s", logging.name(), message);
    }

    private SlowTaskThread() {
    }

    private static final class SlowTaskThreadImpl
    extends Thread {
        private final Runner runner;

        private SlowTaskThreadImpl(BuilderOngoing<?> builder) {
            this(new Runner(builder));
        }

        private SlowTaskThreadImpl(Runner runner) {
            super(runner);
            this.setDaemon(true);
            this.runner = runner;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.runner.ensureNewLine();
        }
    }

    private static final class Runner
    implements Runnable {
        private final String message;
        private final long wait;
        private final String logMessage;
        private final BuilderOngoing.Logging logging;
        private final String alreadyAnswered;

        Runner(BuilderOngoing<?> builder) {
            this.message = ((BuilderOngoing)builder).warning;
            this.wait = ((BuilderOngoing)builder).builder.ms;
            this.logMessage = ((BuilderOngoing.Logging)((Object)((BuilderOngoing)builder).logging.get())).message;
            this.logging = (BuilderOngoing.Logging)((Object)((BuilderOngoing)builder).logging.get());
            this.alreadyAnswered = SlowTaskThread.getAlreadyAnsweredKey(this.logging, this.message);
        }

        @Override
        public void run() {
            block11: {
                boolean invokedByPly = "ply".equals(System.getenv("ply_ply.invoker"));
                try {
                    Thread.sleep(this.wait);
                    if (Thread.currentThread().isInterrupted()) break block11;
                    Output.print(this.message, new Object[0]);
                    AtomicBoolean printedNewLine = new AtomicBoolean(false);
                    if (PlyUtil.isHeadless()) {
                        Output.print(this.logMessage, new Object[0]);
                    } else {
                        if (invokedByPly) {
                            System.out.println(String.format("^no_line^%s Enable now? [Y/n] ", this.logMessage));
                        } else {
                            Output.printNoLine("%s Enable now? [Y/n] ", this.logMessage);
                        }
                        this.setupOutput(printedNewLine, invokedByPly);
                    }
                    if (PlyUtil.isHeadless()) break block11;
                    InterruptibleInputReader reader = new InterruptibleInputReader(System.in);
                    try {
                        String answer = reader.readLine();
                        printedNewLine.set(true);
                        if (answer != null) {
                            if ("y".equalsIgnoreCase(answer.trim()) || "yes".equalsIgnoreCase(answer.trim())) {
                                this.logging.enableLogging();
                            }
                            PlyUtil.addInvocationProperties("slowthread", PlyUtil.varargs(this.alreadyAnswered), "true");
                        }
                    }
                    catch (IOException ioe) {
                        throw new AssertionError((Object)ioe);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptibleInputReader.InterruptedRuntimeException interruptedRuntimeException) {
                    // empty catch block
                }
            }
        }

        private PrintStream setupOutput(final AtomicBoolean printedNewLine, final boolean invokedByPly) {
            final PrintStream old = System.out;
            PrintStream tabbed = new PrintStream(new ByteArrayOutputStream()){
                final Object[] nil;
                {
                    super(x0);
                    this.nil = new Object[0];
                }

                @Override
                public void print(String out) {
                    if (printedNewLine.getAndSet(true)) {
                        old.print(out);
                    } else {
                        if (invokedByPly) {
                            old.print(String.format("^no_prefix^%n%s", out));
                        } else {
                            Output.printNoLine(String.format("%n%s", out), new Object[0]);
                        }
                        System.setOut(old);
                    }
                }

                @Override
                public void println(String out) {
                    if (printedNewLine.getAndSet(true)) {
                        old.println(out);
                    } else {
                        if (invokedByPly) {
                            old.println(String.format("^no_prefix^%n%s", out));
                        } else {
                            Output.print(String.format("%n%s", out), new Object[0]);
                        }
                        System.setOut(old);
                    }
                }
            };
            System.setOut(tabbed);
            return old;
        }

        private void ensureNewLine() {
            System.out.print("");
        }
    }

    public static final class BuilderEnd<T> {
        private final BuilderOngoing<T> builder;
        private final Callable<T> task;

        private BuilderEnd(BuilderOngoing<T> builder, Callable<T> task) {
            this.builder = builder;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T start() throws Exception {
            Thread slowTaskThread = null;
            boolean alreadyAnswered = PlyUtil.matchingInvocationProperty("slowthread", SlowTaskThread.getAlreadyAnsweredKey((BuilderOngoing.Logging)((Object)((BuilderOngoing)this.builder).logging.get()), ((BuilderOngoing)this.builder).warning), "true");
            if (!(alreadyAnswered || ((BuilderOngoing.Logging)((Object)((BuilderOngoing)this.builder).logging.get())).isLoggingEnabled() || ((BuilderOngoing)this.builder).ignoreIfHeadless.get() && PlyUtil.isHeadless())) {
                slowTaskThread = new SlowTaskThreadImpl(this.builder);
                slowTaskThread.start();
            }
            T result = null;
            try {
                result = this.task.call();
            }
            finally {
                if (slowTaskThread != null) {
                    slowTaskThread.interrupt();
                }
            }
            return result;
        }
    }

    public static final class BuilderOngoing<T> {
        private final BuilderStart<T> builder;
        private final String warning;
        private final AtomicReference<Logging> logging;
        private final AtomicBoolean ignoreIfHeadless;

        private BuilderOngoing(BuilderStart<T> builder, String warning) {
            this.builder = builder;
            this.warning = warning;
            this.logging = new AtomicReference<Logging>(Logging.Warn);
            this.ignoreIfHeadless = new AtomicBoolean(true);
        }

        public BuilderOngoing<T> onlyIfNotLoggingInfo() {
            this.logging.set(Logging.Info);
            return this;
        }

        public BuilderOngoing<T> onlyIfNotLoggingDebug() {
            this.logging.set(Logging.Debug);
            return this;
        }

        public BuilderOngoing<T> evenIfHeadless() {
            this.ignoreIfHeadless.set(false);
            return this;
        }

        public BuilderEnd<T> whenDoing(Callable<T> task) {
            return new BuilderEnd(this, task);
        }

        private static enum Logging {
            Warn("You can always run with ^b^-Pply.log.levels=warn^r^ to see more log messages."),
            Info("You can always run with ^b^-Pply.log.levels=info^r^ to see more log messages."),
            Debug("You can always run with ^b^-Pply.log.levels=debug^r^ to see more log messages.");

            private final String message;

            private Logging(String message) {
                this.message = message;
            }

            private boolean isLoggingEnabled() {
                switch (this) {
                    case Warn: {
                        return Output.isWarn();
                    }
                    case Info: {
                        return Output.isInfo();
                    }
                    case Debug: {
                        return Output.isDebug();
                    }
                }
                throw new AssertionError((Object)String.format("Unknown logging type %s", this.name()));
            }

            private void enableLogging() {
                switch (this) {
                    case Warn: {
                        PlyUtil.addInvocationProperties("ply.log.levels", PlyUtil.varargs("warn"), "true");
                        Output.enableWarn();
                        break;
                    }
                    case Info: {
                        PlyUtil.addInvocationProperties("ply.log.levels", PlyUtil.varargs("info"), "true");
                        Output.enableInfo();
                        break;
                    }
                    case Debug: {
                        PlyUtil.addInvocationProperties("ply.log.levels", PlyUtil.varargs("debug"), "true");
                        Output.enableDebug();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)String.format("Unknown logging type %s", this.name()));
                    }
                }
            }
        }
    }

    public static final class BuilderStart<T> {
        private final long ms;

        private BuilderStart(long ms) {
            this.ms = ms;
        }

        public BuilderOngoing<T> warn(String warning) {
            return new BuilderOngoing(this, warning);
        }
    }
}

