/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Props;

public final class Output {
    private static final List<Message> queue = new ArrayList<Message>();
    private static final AtomicBoolean warnLevel = new AtomicBoolean(true);
    private static final AtomicBoolean infoLevel = new AtomicBoolean(true);
    private static final AtomicBoolean dbugLevel = new AtomicBoolean(true);
    private static final AtomicBoolean coloredOutput = new AtomicBoolean(true);
    private static final AtomicBoolean decorated = new AtomicBoolean(true);
    private static final AtomicBoolean withinTerminal = new AtomicBoolean(true);
    private static final AtomicBoolean beingPiped = new AtomicBoolean(false);
    private static final Map<String, TermCode> TERM_CODES = new HashMap<String, TermCode>();
    private static AtomicBoolean inited = new AtomicBoolean(false);

    static void init() {
        Context plyContext = Context.named("ply");
        Output.init(Props.get("color", plyContext).value(), Props.get("decorated", plyContext).value(), Props.get("log.levels", plyContext).value());
    }

    static void init(String coloredOutput, String decorated, String logLevels) {
        String terminal;
        if (inited.getAndSet(true)) {
            return;
        }
        if (!logLevels.contains("warn")) {
            warnLevel.set(false);
        }
        if (!logLevels.contains("info")) {
            infoLevel.set(false);
        }
        if (!logLevels.contains("debug") && !logLevels.contains("dbug")) {
            dbugLevel.set(false);
        }
        if (logLevels.contains("+debug") || logLevels.contains("+dbug")) {
            infoLevel.set(true);
            warnLevel.set(true);
        }
        if (logLevels.contains("+info")) {
            warnLevel.set(true);
        }
        if (PlyUtil.matchingInvocationProperty("ply.log.levels", "warn", "true")) {
            warnLevel.set(true);
        }
        if (PlyUtil.matchingInvocationProperty("ply.log.levels", "info", "true")) {
            infoLevel.set(true);
        }
        if (PlyUtil.matchingInvocationProperty("ply.log.levels", "debug", "true")) {
            dbugLevel.set(true);
        }
        if ("false".equalsIgnoreCase(decorated)) {
            Output.decorated.set(false);
        }
        withinTerminal.set((terminal = System.getenv("TERM")) != null);
        String piped = System.getProperty("ply.piped");
        beingPiped.set(piped != null && "true".equalsIgnoreCase(piped));
        boolean useColor = withinTerminal.get() && !"false".equalsIgnoreCase(coloredOutput) && !beingPiped.get();
        Output.coloredOutput.set(useColor);
        String terminalBold = "xterm".equals(terminal) ? "1" : "0";
        TERM_CODES.put("ply", new TermCode(Pattern.compile("\\^ply\\^"), "[\u001b[0;33mply\u001b[0m]", "[ply]"));
        TERM_CODES.put("error", new TermCode(Pattern.compile("\\^error\\^"), "[\u001b[1;31merr!\u001b[0m]", "[err!]"));
        TERM_CODES.put("warn", new TermCode(Pattern.compile("\\^warn\\^"), "[\u001b[1;33mwarn\u001b[0m]", "[warn]"));
        TERM_CODES.put("info", new TermCode(Pattern.compile("\\^info\\^"), "[\u001b[1;34minfo\u001b[0m]", "[info]"));
        TERM_CODES.put("dbug", new TermCode(Pattern.compile("\\^dbug\\^"), "[\u001b[1;30mdbug\u001b[0m]", "[dbug]"));
        TERM_CODES.put("reset", new TermCode(Pattern.compile("\\^r\\^"), "\u001b[0m", ""));
        TERM_CODES.put("bold", new TermCode(Pattern.compile("\\^b\\^"), "\u001b[1m", ""));
        TERM_CODES.put("normal", new TermCode(Pattern.compile("\\^n\\^"), "\u001b[2m", ""));
        TERM_CODES.put("inverse", new TermCode(Pattern.compile("\\^i\\^"), "\u001b[7m", ""));
        TERM_CODES.put("black", new TermCode(Pattern.compile("\\^black\\^"), "\u001b[" + terminalBold + ";30m", ""));
        TERM_CODES.put("grey", new TermCode(Pattern.compile("\\^grey\\^"), "\u001b[1;30m", ""));
        TERM_CODES.put("red", new TermCode(Pattern.compile("\\^red\\^"), "\u001b[" + terminalBold + ";31m", ""));
        TERM_CODES.put("green", new TermCode(Pattern.compile("\\^green\\^"), "\u001b[" + terminalBold + ";32m", ""));
        TERM_CODES.put("yellow", new TermCode(Pattern.compile("\\^yellow\\^"), "\u001b[" + terminalBold + ";33m", ""));
        TERM_CODES.put("blue", new TermCode(Pattern.compile("\\^blue\\^"), "\u001b[" + terminalBold + ";34m", ""));
        TERM_CODES.put("magenta", new TermCode(Pattern.compile("\\^magenta\\^"), "\u001b[" + terminalBold + ";35m", ""));
        TERM_CODES.put("cyan", new TermCode(Pattern.compile("\\^cyan\\^"), "\u001b[" + terminalBold + ";36m", ""));
        TERM_CODES.put("white", new TermCode(Pattern.compile("\\^white\\^"), "\u001b[" + terminalBold + ";37m", ""));
        Output.drainQueue();
    }

    private static void drainQueue() {
        block5: for (Message message : queue) {
            switch (message.type) {
                case Line: {
                    Output.print(message.message, message.args);
                    continue block5;
                }
                case NoLine: {
                    Output.printNoLine(message.message, message.args);
                    continue block5;
                }
                case Exec: {
                    Output.printFromExec(message.message, message.args);
                    continue block5;
                }
            }
            throw new AssertionError((Object)String.format("Unknown Message.Type %s", new Object[]{message.type}));
        }
    }

    public static void print(String message, Object ... args) {
        if (!inited.get()) {
            queue.add(new Message(message, Message.Type.Line, args));
            return;
        }
        String formatted = Output.resolve(message, args);
        if (formatted == null || !decorated.get() && Output.isPrintFromPly()) {
            return;
        }
        System.out.println(formatted);
    }

    public static void printNoLine(String message, Object ... args) {
        if (!inited.get()) {
            queue.add(new Message(message, Message.Type.NoLine, args));
            return;
        }
        String formatted = Output.resolve(message, args);
        if (formatted == null || !decorated.get() && Output.isPrintFromPly()) {
            return;
        }
        System.out.print(formatted);
    }

    private static boolean isPrintFromPly() {
        String className;
        StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
        return stackTrace.length > 2 && (className = stackTrace[2].getClassName()).startsWith("net.ocheyedan.ply") && !className.startsWith("net.ocheyedan.ply.script");
    }

    static void printFromExec(String message, Object ... args) {
        if (!inited.get()) {
            queue.add(new Message(message, Message.Type.Exec, args));
            return;
        }
        String scriptArg = (String)args[1];
        if (!decorated.get()) {
            System.out.println(scriptArg);
            return;
        }
        boolean noLine = scriptArg.contains("^no_line^");
        boolean noPrefix = scriptArg.contains("^no_prefix^");
        if (noPrefix && noLine) {
            Output.printNoLine("%s", scriptArg.replaceFirst("\\^no_line\\^", "").replaceFirst("\\^no_prefix\\^", ""));
        } else if (noPrefix) {
            Output.print("%s", scriptArg.replaceFirst("\\^no_prefix\\^", ""));
        } else if (noLine) {
            Output.printNoLine(message, args[0], scriptArg.replaceFirst("\\^no_line\\^", ""));
        } else {
            Output.print(message, args);
        }
    }

    public static void print(Throwable t) {
        Output.print("^error^ %s: ^i^^red^%s^r^", t == null ? "Message" : t.getClass().getSimpleName(), t == null ? "" : t.getMessage());
        if (Output.isDebug()) {
            Output.print(StackTraceWriter.convertStackTrace(t, true), new Object[0]);
        } else {
            Output.print("^error^  run with log.levels to see detailed error information: ^b^-Pply.log.levels=+debug^b^", new Object[0]);
        }
    }

    static String resolve(String message, Object[] args) {
        String formatted = String.format(message, args);
        for (String key : TERM_CODES.keySet()) {
            TermCode termCode = TERM_CODES.get(key);
            Matcher matcher = termCode.pattern.matcher(formatted);
            if (!matcher.find()) continue;
            if ("warn".equals(key) && !warnLevel.get() || "info".equals(key) && !infoLevel.get() || "dbug".equals(key) && !dbugLevel.get()) {
                return null;
            }
            if (!decorated.get()) continue;
            String output = Output.isColoredOutput() ? termCode.output : termCode.nonColoredOutput;
            formatted = matcher.replaceAll(output);
        }
        return formatted;
    }

    public static boolean isWarn() {
        return warnLevel.get();
    }

    public static boolean isInfo() {
        return infoLevel.get();
    }

    public static boolean isDebug() {
        return dbugLevel.get();
    }

    public static boolean isColoredOutput() {
        return coloredOutput.get();
    }

    public static boolean isDecorated() {
        return decorated.get();
    }

    public static void enableWarn() {
        warnLevel.set(true);
    }

    public static void enableInfo() {
        infoLevel.set(true);
    }

    public static void enableDebug() {
        dbugLevel.set(true);
    }

    private Output() {
    }

    static {
        if ("ply".equals(System.getenv("ply_ply.invoker"))) {
            Output.init();
        }
    }

    private static final class Message {
        private final String message;
        private final Type type;
        private final Object[] args;

        private Message(String message, Type type, Object[] args) {
            this.message = message;
            this.type = type;
            this.args = args;
        }

        private static enum Type {
            Line,
            NoLine,
            Exec;

        }
    }

    private static final class TermCode {
        private final Pattern pattern;
        private final String output;
        private final String nonColoredOutput;

        private TermCode(Pattern pattern, String output, String nonColoredOutput) {
            this.pattern = pattern;
            this.output = output;
            this.nonColoredOutput = nonColoredOutput;
        }
    }

    private static final class StackTraceWriter
    extends Writer {
        private final boolean appendOutputError;
        private final StringBuffer buffer = new StringBuffer();

        static String convertStackTrace(Throwable t, boolean appendOutputError) {
            StackTraceWriter writer = new StackTraceWriter(appendOutputError);
            t.printStackTrace(new PrintWriter(writer));
            return writer.toString().replaceAll("%", "%%");
        }

        private StackTraceWriter(boolean appendOutputError) {
            this.appendOutputError = appendOutputError;
            if (this.appendOutputError) {
                this.buffer.append("^error^ ");
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.appendOutputError) {
                for (int i = off; i < off + len; ++i) {
                    char character = cbuf[i];
                    this.buffer.append(character);
                    if (character != '\n') continue;
                    this.buffer.append("^error^ ");
                }
            } else {
                this.buffer.append(cbuf, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

