/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply;

import java.util.Collection;
import java.util.Iterator;

public final class Iter {
    public static <T> Sized<T> sized(T[] array) {
        return array == null ? null : new ArrayIterable(array);
    }

    public static <T> Sized<T> sized(Collection<T> collection) {
        return collection == null ? null : new CollectionIterable(collection);
    }

    private Iter() {
    }

    private static final class CollectionIterable<T>
    implements Sized<T> {
        private final Collection<T> collection;

        private CollectionIterable(Collection<T> collection) {
            this.collection = collection;
        }

        @Override
        public Iterator<T> iterator() {
            return this.collection.iterator();
        }

        @Override
        public int size() {
            return this.collection.size();
        }
    }

    private static final class ArrayIterable<T>
    implements Sized<T> {
        private final T[] array;

        private ArrayIterable(T[] array) {
            this.array = array;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < ArrayIterable.this.array.length;
                }

                @Override
                public T next() {
                    return ArrayIterable.this.array[this.index++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }

    public static interface Sized<T>
    extends Iterable<T> {
        public int size();
    }
}

