/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;

public final class DependencyCopy {
    public static void main(String[] args) {
        PropFile resolvedProperties = Deps.getResolvedProperties((boolean)false);
        String toDirPath = Props.get((String)"dir", (Context)Context.named((String)"depcopy")).value();
        if (toDirPath.isEmpty()) {
            Output.print((String)"^warn^ The ^b^depcopy.dir^r^ property is null, skipping dependency copying.", (Object[])new Object[0]);
            return;
        }
        File copyToDir = new File(toDirPath);
        FileUtil.delete((File)copyToDir);
        DependencyCopy.copyDependencies(resolvedProperties, copyToDir);
    }

    protected static void copyDependencies(PropFile resolvedProperties, File copyToDir) {
        copyToDir.mkdirs();
        for (PropFile.Prop resolvedKey : resolvedProperties.props()) {
            if (DependencyAtom.isTransient((String)resolvedKey.name)) continue;
            File dependency = new File(resolvedKey.value());
            File to = FileUtil.fromParts((String[])new String[]{copyToDir.getPath(), dependency.getName()});
            FileUtil.copy((File)dependency, (File)to);
        }
    }
}

