/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.exec;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.exec.Execution;

final class ExecutionWrapper {
    private final long start;
    private final String scriptName;
    private final String outputScriptName;
    final Execution execution;
    private final AtomicBoolean errorOnInvoke;

    ExecutionWrapper(Execution execution, long start) {
        this.execution = execution;
        this.start = start;
        this.scriptName = Output.isDebug() ? ExecutionWrapper.buildScriptName(execution.executionArgs) : "";
        this.outputScriptName = ExecutionWrapper.buildExecutionName(execution);
        this.errorOnInvoke = new AtomicBoolean(false);
    }

    void invoke() {
        try {
            this.execution.invoke(this.scriptName);
        }
        catch (IOException ioe) {
            this.errorOnInvoke.set(true);
            Output.print((String)"^error^ executing script ^green^%s^r^", (Object[])new Object[]{this.execution.script.unparsedName});
            Output.print((Throwable)ioe);
        }
    }

    boolean waitFor() {
        if (this.errorOnInvoke.get()) {
            return false;
        }
        try {
            int result = this.execution.waitFor(this.outputScriptName);
            ExecutionWrapper.printTime(this.start, this.outputScriptName);
            if (result == 0) {
                return true;
            }
            Output.print((String)"^error^ script ^green^%s^r^ failed [ exit code = %d ].", (Object[])new Object[]{this.execution.script.unparsedName, result});
        }
        catch (IOException ioe) {
            Output.print((String)"^error^ executing script ^green^%s^r^", (Object[])new Object[]{this.execution.script.unparsedName});
            Output.print((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            Output.print((Throwable)ie);
        }
        return false;
    }

    private static float printTime(long start, String script) {
        long end = System.currentTimeMillis();
        float seconds = (float)(end - start) / 1000.0f;
        Output.print((String)"^dbug^ executed ^b^%s^r^ in ^b^%.3f seconds^r^.", (Object[])new Object[]{script, Float.valueOf(seconds)});
        return seconds;
    }

    private static String buildExecutionName(Execution execution) {
        String name = execution.name;
        String scope = execution.script.scope.getScriptPrefix();
        if (!name.equals(execution.script.scope.name)) {
            return scope + name;
        }
        return name;
    }

    private static String buildScriptName(String[] cmdArgs) {
        StringBuilder buffer = new StringBuilder();
        for (String cmdArg : cmdArgs) {
            buffer.append(cmdArg);
            buffer.append(" ");
        }
        buffer.replace(buffer.length() - 1, buffer.length(), "");
        return buffer.toString();
    }
}

