/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.exec;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.OutputExt;
import net.ocheyedan.ply.PwdUtil;
import net.ocheyedan.ply.cmd.build.Script;
import net.ocheyedan.ply.exec.StdinProcessPipe;
import net.ocheyedan.ply.props.Context;

public class Execution {
    protected static final ThreadLocal<StdinProcessPipe> STDIN_PROCESS_PIPE = new ThreadLocal<StdinProcessPipe>(){

        @Override
        protected StdinProcessPipe initialValue() {
            return new StdinProcessPipe();
        }
    };
    public final String name;
    public final Script script;
    public final String[] executionArgs;
    protected final AtomicReference<ProcessBuilder> processBuilder;
    protected final AtomicReference<BufferedReader> processStdout;
    protected final AtomicReference<Process> process;

    public Execution(String name, Script script, String[] executionArgs) {
        this.name = name;
        this.script = script;
        this.executionArgs = executionArgs;
        this.processBuilder = new AtomicReference();
        this.processStdout = new AtomicReference();
        this.process = new AtomicReference();
    }

    public Execution augment(String[] with) {
        String[] args = new String[this.executionArgs.length + with.length];
        System.arraycopy(this.executionArgs, 0, args, 0, this.executionArgs.length);
        System.arraycopy(with, 0, args, this.executionArgs.length, with.length);
        return new Execution(this.name, this.script, args);
    }

    public Execution with(String executable) {
        String[] args = new String[this.executionArgs.length];
        System.arraycopy(this.executionArgs, 1, args, 1, this.executionArgs.length - 1);
        args[0] = executable;
        return new Execution(this.name, this.script, args);
    }

    public String getEnvKey(String prefix, Context context, String propName) {
        return prefix + context.name + "." + propName;
    }

    public String getEnvKeyId() {
        return "execution";
    }

    void preInvoke(File projectRoot, Map<String, String> supplementalEnvironment) {
        ProcessBuilder processBuilder = new ProcessBuilder(this.executionArgs).redirectErrorStream(true).directory(projectRoot);
        Map<String, String> environment = processBuilder.environment();
        environment.putAll(supplementalEnvironment);
        this.processBuilder.set(processBuilder);
    }

    void invoke(String scriptName) throws IOException {
        Output.print((String)"^dbug^ invoking %s", (Object[])new Object[]{scriptName});
        Process process = this.processBuilder.get().start();
        this.process.set(process);
        STDIN_PROCESS_PIPE.get().startPipe(process.getOutputStream());
        this.processStdout.set(new BufferedReader(new InputStreamReader(process.getInputStream())));
    }

    int waitFor(String outputScriptName) throws IOException, InterruptedException {
        String processStdoutLine;
        while ((processStdoutLine = this.processStdout.get().readLine()) != null) {
            char[] pwd;
            PwdUtil.Request request = PwdUtil.isPwdRequest((String)processStdoutLine);
            OutputExt.printFromExec("[^green^%s^r^] %s", outputScriptName, request.getLine());
            if (!request.isPwd()) continue;
            Console console = System.console();
            if (console != null) {
                pwd = console.readPassword();
            } else {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                pwd = reader.readLine().toCharArray();
            }
            STDIN_PROCESS_PIPE.get().write(pwd);
            Arrays.fill(pwd, ' ');
        }
        int result = this.process.get().waitFor();
        STDIN_PROCESS_PIPE.get().pausePipe();
        return result;
    }

    void kill() {
        if (this.process.get() != null) {
            this.process.get().destroy();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execution execution = (Execution)o;
        if (this.script != null ? !this.script.equals(execution.script) : execution.script != null) {
            return false;
        }
        return Arrays.equals(this.executionArgs, execution.executionArgs);
    }

    public int hashCode() {
        int result = this.script != null ? this.script.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.executionArgs);
        return result;
    }
}

