/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.exec;

import java.io.File;
import java.util.List;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.cmd.build.ShellScript;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.exec.ExecutionWrapper;
import net.ocheyedan.ply.exec.JvmExecution;
import net.ocheyedan.ply.exec.ShellExecution;
import net.ocheyedan.ply.props.PropsExt;

public final class Exec {
    public static boolean invoke(File projectPlyDir, List<Execution> executions) {
        File projectRoot = FileUtil.fromParts((String[])new String[]{projectPlyDir.getPath(), ".."});
        ExecutionWrapper running = null;
        ExecutionWrapper queued = null;
        for (Execution execution : executions) {
            if (!Exec.waitFor(running, queued)) {
                return false;
            }
            running = Exec.invoke(queued);
            queued = Exec.preInvoke(execution, projectRoot);
        }
        if (!Exec.waitFor(running, queued)) {
            return false;
        }
        running = Exec.invoke(queued);
        return Exec.waitFor(running, null);
    }

    private static ExecutionWrapper preInvoke(Execution execution, File projectRoot) {
        File projectConfigDir = FileUtil.fromParts((String[])new String[]{projectRoot.getPath(), ".ply", "config"});
        execution = Exec.handleNonNativeExecutable(execution, projectConfigDir);
        long start = System.currentTimeMillis();
        execution.preInvoke(projectRoot, PropsExt.getPropsForEnv(execution, projectConfigDir, execution.script.scope));
        return new ExecutionWrapper(execution, start);
    }

    private static ExecutionWrapper invoke(ExecutionWrapper queued) {
        if (queued != null) {
            queued.invoke();
        }
        return queued;
    }

    private static boolean waitFor(ExecutionWrapper running, ExecutionWrapper queued) {
        if (running != null && !running.waitFor()) {
            if (queued != null) {
                queued.execution.kill();
            }
            return false;
        }
        return true;
    }

    private static Execution handleNonNativeExecutable(Execution execution, File configDirectory) {
        String executable = execution.executionArgs[0];
        if (execution.script instanceof ShellScript || executable.endsWith(".sh")) {
            return ShellExecution.createShellExecutable(execution, configDirectory);
        }
        if (executable.endsWith(".jar")) {
            return JvmExecution.createJarExecutable(execution, configDirectory);
        }
        if (executable.endsWith(".clj")) {
            return JvmExecution.createClojureExecutable(execution, configDirectory);
        }
        return execution;
    }
}

