/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.Usage;
import net.ocheyedan.ply.cmd.config.Config;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public class Get
extends Config {
    static final String QUOTED_DECORATOR = Pattern.quote("_^$f$^_");
    static final String QUOTED_DECORATOR_SCOPED = Pattern.quote("_^$fs$^_");
    static final String QUOTED_DECORATOR_END = Pattern.quote("_$^f^$_");
    static final String QUOTED_DECORATOR_REPL = Matcher.quoteReplacement("^b^");
    static final String QUOTED_DECORATOR_SCOPED_REPL = Matcher.quoteReplacement("^r^^magenta^");
    static final String QUOTED_DECORATOR_END_REPL = Matcher.quoteReplacement("^r^^cyan^");

    public Get(Args args) {
        super(args);
    }

    @Override
    protected void runAfterAssumptionsCheck() {
        Opts opts = this.parse(this.args);
        if (opts == null) {
            new Usage(this.args).run();
            return;
        }
        this.print(PlyUtil.LOCAL_CONFIG_DIR, opts.context, opts.scope, opts.propName, opts.unfiltered);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void print(File configurationDirectory, Context context, Scope scope, String propName, boolean unfiltered) {
        Map contextMap = Props.get((Scope)scope, (File)configurationDirectory);
        if (context == null) {
            ArrayList contexts = new ArrayList(contextMap.keySet());
            Collections.sort(contexts);
            Result result = Result.NOTHING;
            for (Context currentContext : contexts) {
                result = result.or(this.printContext(currentContext, scope, ((PropFileChain)contextMap.get(currentContext)).props(), propName, unfiltered));
            }
            if (result.printedSomething) {
                this.printAppendix(scope, result);
                return;
            }
            this.printNothingMessage(context, propName);
            return;
        }
        Result result = Result.NOTHING;
        if (contextMap.containsKey(context)) {
            result = result.or(this.printContext(context, scope, ((PropFileChain)contextMap.get(context)).props(), propName, unfiltered));
            if (result.printedSomething) {
                this.printAppendix(scope, result);
                return;
            }
        }
        this.printNothingMessage(context, propName);
    }

    protected Opts parse(Args args) {
        Scope scope = Scope.Default;
        int scopeIndex = args.args.get(0).indexOf(":");
        if (scopeIndex != -1) {
            scope = Scope.named((String)args.args.get(0).substring(0, scopeIndex));
        }
        switch (args.args.size()) {
            case 1: {
                return new Opts(scope, null, null, false);
            }
            case 2: {
                if ("--unfiltered".equals(args.args.get(1))) {
                    return new Opts(scope, null, null, true);
                }
                return new Opts(scope, null, args.args.get(1), false);
            }
            case 3: {
                if ("from".equals(args.args.get(1))) {
                    return new Opts(scope, new Context(args.args.get(2)), null, false);
                }
                if ("--unfiltered".equals(args.args.get(2))) {
                    return new Opts(scope, null, args.args.get(1), true);
                }
                return null;
            }
            case 4: {
                if ("from".equals(args.args.get(2))) {
                    return new Opts(scope, new Context(args.args.get(3)), args.args.get(1), false);
                }
                if ("from".equals(args.args.get(1)) && "--unfiltered".equals(args.args.get(3))) {
                    return new Opts(scope, new Context(args.args.get(2)), null, true);
                }
                return null;
            }
            case 5: {
                if (!"from".equals(args.args.get(2)) || !"--unfiltered".equals(args.args.get(4))) break;
                return new Opts(scope, new Context(args.args.get(3)), args.args.get(1), true);
            }
        }
        return null;
    }

    protected Result printContext(Context context, Scope scope, Iterable<PropFile.Prop> props, String likePropName, boolean unfiltered) {
        if (props == null) {
            return Result.NOTHING;
        }
        List<PropFile.Prop> properties = this.collect(props);
        Collections.sort(properties);
        boolean printedHeader = false;
        boolean printedSomething = false;
        boolean printedDecorated = false;
        boolean printedScopedDecorated = false;
        for (PropFile.Prop prop : properties) {
            String value;
            if (likePropName != null && !this.matches(prop, likePropName)) continue;
            if (!printedHeader) {
                Output.print((String)"Properties from ^b^%s^r^", (Object[])new Object[]{context.name});
                printedHeader = true;
            }
            if (unfiltered) {
                value = prop.unfilteredValue;
            } else {
                String decoratedValue = prop.valueDecorated();
                printedDecorated |= decoratedValue.contains("_^$f$^_");
                printedScopedDecorated |= decoratedValue.contains("_^$fs$^_");
                value = this.getDecoratedValue(decoratedValue);
            }
            Output.print((String)"   ^b^%s^r^ = ^cyan^%s^r^%s", (Object[])new Object[]{prop.name, value, this.getSuffix(prop, scope)});
            printedSomething = true;
        }
        return new Result(printedSomething, printedDecorated, printedScopedDecorated);
    }

    protected String getDecoratedValue(String decoratedValue) {
        return decoratedValue.replaceAll(QUOTED_DECORATOR, QUOTED_DECORATOR_REPL).replaceAll(QUOTED_DECORATOR_SCOPED, QUOTED_DECORATOR_SCOPED_REPL).replaceAll(QUOTED_DECORATOR_END, QUOTED_DECORATOR_END_REPL);
    }

    protected List<PropFile.Prop> collect(Iterable<PropFile.Prop> props) {
        ArrayList<PropFile.Prop> properties = new ArrayList<PropFile.Prop>();
        for (PropFile.Prop prop : props) {
            if (!this.accept(prop)) continue;
            properties.add(prop);
        }
        return properties;
    }

    protected boolean matches(PropFile.Prop prop, String likePropName) {
        if (likePropName.equals(prop.name)) {
            return true;
        }
        if (likePropName.startsWith("*")) {
            return prop.name.endsWith(likePropName.substring(1));
        }
        if (likePropName.endsWith("*")) {
            return prop.name.startsWith(likePropName.substring(0, likePropName.length() - 1));
        }
        return false;
    }

    protected boolean accept(PropFile.Prop prop) {
        return prop.loc() != PropFile.Loc.System;
    }

    protected String getSuffix(PropFile.Prop prop, Scope scope) {
        if (!Scope.Default.equals((Object)scope) && !Scope.Default.equals((Object)prop.scope())) {
            return " ^magenta^**^r^";
        }
        return "";
    }

    protected String getNothingMessageSuffix() {
        return " locally (try ^b^get-all^r^)";
    }

    protected void printAppendix(Scope scope, Result result) {
        if (Output.isColoredOutput() && result.printedSomethingDecorated) {
            Output.print((String)"Text in ^cyan^^b^bold^r^ are parameter replacements (use ^b^--unfiltered^r^ to see parameters; ^b^ply %s--unfiltered^r^)", (Object[])new Object[]{this.args.toString()});
        }
        if (Output.isColoredOutput() && result.printedSomethingScopedDecorated) {
            Output.print((String)"Text in ^magenta^magenta^r^ are parameter replacements from scope %s", (Object[])new Object[]{scope.name});
        }
        if (!Scope.Default.equals((Object)scope)) {
            Output.print((String)"^magenta^**^r^ indicates %s-scoped property.", (Object[])new Object[]{scope.name});
        }
    }

    protected void printNothingMessage(Context context, String propName) {
        if (context == null) {
            if (propName == null) {
                Output.print((String)"No properties in any context found%s.", (Object[])new Object[]{this.getNothingMessageSuffix()});
            } else {
                Output.print((String)"No property like ^b^%s^r^ found in any context%s.", (Object[])new Object[]{propName, this.getNothingMessageSuffix()});
            }
        } else if (propName == null) {
            Output.print((String)"No context ^b^%s^r^ found%s.", (Object[])new Object[]{context, this.getNothingMessageSuffix()});
        } else {
            Output.print((String)"No property like ^b^%s^r^ found in context ^b^%s^r^%s.", (Object[])new Object[]{propName, context, this.getNothingMessageSuffix()});
        }
    }

    static class Result {
        static final Result NOTHING = new Result(false, false, false);
        final boolean printedSomething;
        final boolean printedSomethingDecorated;
        final boolean printedSomethingScopedDecorated;

        Result(boolean printedSomething, boolean printedSomethingDecorated, boolean printedSomethingScopedDecorated) {
            this.printedSomething = printedSomething;
            this.printedSomethingDecorated = printedSomethingDecorated;
            this.printedSomethingScopedDecorated = printedSomethingScopedDecorated;
        }

        Result or(Result result) {
            return new Result(this.printedSomething | result.printedSomething, this.printedSomethingDecorated | result.printedSomethingDecorated, this.printedSomethingScopedDecorated | result.printedSomethingScopedDecorated);
        }
    }

    static class Opts {
        final Scope scope;
        final Context context;
        final String propName;
        final boolean unfiltered;

        Opts(Scope scope, Context context, String propName, boolean unfiltered) {
            this.scope = scope;
            this.context = context;
            this.propName = propName;
            this.unfiltered = unfiltered;
        }
    }
}

