/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.props.Scope;

public class Script {
    public final String name;
    public final String unparsedName;
    public final Scope scope;
    final List<String> arguments;
    final File location;

    public static List<String> splitScript(String script) {
        if (script == null) {
            return Collections.emptyList();
        }
        ArrayList<String> matchList = new ArrayList<String>();
        char[] characters = script.toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean within = false;
        boolean escaped = false;
        char withinChar = '\u0000';
        block5: for (char character : characters) {
            switch (character) {
                case ' ': {
                    if (!within) {
                        matchList.add(buffer.toString());
                        buffer = new StringBuilder();
                    } else {
                        buffer.append(character);
                    }
                    escaped = false;
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    if (!escaped && !within) {
                        within = true;
                        withinChar = character;
                        if (character != '`') continue block5;
                        buffer.append(character);
                        continue block5;
                    }
                    if (!escaped && within && character == withinChar) {
                        within = false;
                        if (character != '`') continue block5;
                        buffer.append(character);
                        continue block5;
                    }
                    buffer.append(character);
                    escaped = false;
                    continue block5;
                }
                case '\\': {
                    escaped = true;
                    buffer.append(character);
                    continue block5;
                }
                default: {
                    escaped = false;
                    buffer.append(character);
                }
            }
        }
        if (buffer.length() > 0) {
            matchList.add(buffer.toString());
        }
        return matchList;
    }

    static Script parse(String script, Scope defaultScope) {
        Scope scope;
        if (script == null || !script.contains(":")) {
            return script == null || script.isEmpty() ? null : Script.parseArgs(script, defaultScope, script);
        }
        String unparsedName = script;
        int scopeIndex = -1;
        block4: for (char character : script.toCharArray()) {
            ++scopeIndex;
            switch (character) {
                case ':': {
                    break block4;
                }
                case ' ': 
                case '\"': 
                case '\'': 
                case '`': {
                    scopeIndex = -1;
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (scopeIndex == -1) {
            scope = defaultScope;
        } else if (scopeIndex == 0) {
            scope = Scope.Default;
        } else {
            scope = new Scope(script.substring(0, scopeIndex));
            script = script.substring(scopeIndex + 1);
        }
        return Script.parseArgs(script, scope, unparsedName);
    }

    static Script parseArgs(String script, Scope scope, String unparsedName) {
        List<String> scripts = Script.splitScript(script);
        if (scripts == null || scripts.isEmpty()) {
            throw new AssertionError((Object)String.format("Parsing %s should have created at least one script.", script));
        }
        if (scripts.size() == 1) {
            return new Script(scripts.get(0), scope, unparsedName);
        }
        script = scripts.remove(0);
        return new Script(script, scope, scripts, unparsedName);
    }

    Script(String name, Scope scope, String unparsedName) {
        this(name, scope, Collections.emptyList(), unparsedName, null);
    }

    Script(String name, Scope scope, List<String> arguments, String unparsedName) {
        this(name, scope, arguments, unparsedName, null);
    }

    Script(String name, Scope scope, List<String> arguments, String unparsedName, File location) {
        this.name = name;
        this.scope = scope;
        this.arguments = new ArrayList<String>(arguments);
        this.unparsedName = unparsedName;
        this.location = location;
    }

    Script with(File location) {
        return new Script(this.name, this.scope, this.arguments, this.unparsedName, location);
    }

    List<Execution> convert() {
        return this.convert(this.name);
    }

    protected List<Execution> convert(String overriddenExecutionName) {
        if (this.location == null || !this.location.canExecute()) {
            Output.print((String)"^error^ Found script ^b^%s^r^%s but it is not executable.", (Object[])new Object[]{this.name, Scope.Default.equals((Object)this.scope) ? "" : String.format(" (in scope ^b^%s^r^)", this.scope)});
            throw new SystemExit(1);
        }
        String[] executableArgs = new String[this.arguments.size() + 1];
        executableArgs[0] = FileUtil.getCanonicalPath((File)this.location);
        for (int i = 1; i < executableArgs.length; ++i) {
            executableArgs[i] = this.arguments.get(i - 1);
        }
        ArrayList<Execution> executions = new ArrayList<Execution>(1);
        executions.add(new Execution(overriddenExecutionName, this, executableArgs));
        return executions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Script script = (Script)o;
        if (this.name != null ? !this.name.equals(script.name) : script.name != null) {
            return false;
        }
        return this.scope == null ? script.scope == null : this.scope.equals((Object)script.scope);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }
}

