/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd.build;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.build.Alias;
import net.ocheyedan.ply.cmd.build.Script;
import net.ocheyedan.ply.cmd.build.ShellScript;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.props.AdHoc;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.PropsExt;
import net.ocheyedan.ply.props.Scope;

final class Module {
    private final Args args;
    private final File configDirectory;
    private final AtomicReference<String> scriptsPath;

    static List<Execution> resolve(Args args, File configDirectory) {
        return new Module(args, configDirectory).resolve();
    }

    Module(Args args, File configDirectory) {
        this.args = args;
        this.configDirectory = configDirectory;
        this.scriptsPath = new AtomicReference<Object>(null);
    }

    List<Execution> resolve() {
        List<Script> scripts = this.convertArgsToScripts();
        if (this.handleAdHoc(scripts)) {
            PropsExt.invalidateFilteredCaches(this.configDirectory);
        }
        return this.convertScriptsToExecutions(scripts);
    }

    private boolean handleAdHoc(List<Script> scripts) {
        boolean hasAdHocPropsFromAliases = false;
        for (Script script : scripts) {
            if (!(script instanceof Alias)) continue;
            Alias alias = (Alias)script;
            List<String> adHocProps = alias.adHocProps;
            boolean bl = hasAdHocPropsFromAliases = hasAdHocPropsFromAliases || this.handleAdHoc(alias.scripts);
            if (adHocProps == null || adHocProps.isEmpty()) continue;
            AdHoc.add(adHocProps);
            hasAdHocPropsFromAliases = true;
        }
        return hasAdHocPropsFromAliases;
    }

    List<Script> convertArgsToScripts() {
        ArrayList<Script> scripts = new ArrayList<Script>(this.args.args.size());
        for (String arg : this.args.args) {
            Script parse = Script.parse(arg, Scope.Default);
            Alias alias = Alias.getAlias(this.configDirectory, parse.scope, parse.name);
            if (alias != null) {
                this.processAlias(alias.augment(parse.arguments, parse.unparsedName), scripts);
                continue;
            }
            this.processScript(parse, scripts, arg);
        }
        return scripts;
    }

    List<Execution> convertScriptsToExecutions(List<Script> scripts) {
        ArrayList<Execution> executions = new ArrayList<Execution>(scripts.size());
        for (Script script : scripts) {
            executions.addAll(script.convert());
        }
        return executions;
    }

    void processScript(Script script, List<Script> scripts, String unparsed) {
        Script resolvedScript = this.doesScriptExist(script);
        if (resolvedScript != null) {
            scripts.add(resolvedScript);
        } else if (!scripts.isEmpty()) {
            scripts.get((int)(scripts.size() - 1)).arguments.add(unparsed);
        } else {
            Output.print((String)"^error^ Could not find script ^b^%s^r^%s.", (Object[])new Object[]{script.name, Scope.Default.equals((Object)script.scope) ? "" : String.format(" (in scope ^b^%s^r^)", script.scope)});
            Output.print((String)"^info^    Place ^b^%s^r^ script into the project's scripts directory (current scripts' directory: ^b^ply %sget-all scripts.dir from project^r^).", (Object[])new Object[]{script.name, script.scope.getScriptPrefix()});
            Output.print((String)"^info^    Or make ^b^%s^r^ an alias (^b^ply set %s%s=xxxx in aliases^r^).", (Object[])new Object[]{script.name, script.scope.getScriptPrefix(), script.name});
            throw new SystemExit(1);
        }
    }

    void processAlias(Alias alias, List<Script> scripts) {
        ArrayList<Script> aliasesProcessedScripts = new ArrayList<Script>(alias.scripts.size());
        for (Script script : alias.scripts) {
            if (script instanceof Alias) {
                this.processAlias((Alias)script, aliasesProcessedScripts);
                continue;
            }
            this.processScript(script, aliasesProcessedScripts, script.unparsedName);
        }
        scripts.add(alias.with(aliasesProcessedScripts));
    }

    Script doesScriptExist(Script script) {
        String projectScriptPath = this.getProjectScriptPath();
        String systemScriptPath = FileUtil.getCanonicalPath((File)PlyUtil.SYSTEM_SCRIPTS_DIR);
        File location = FileUtil.fromParts((String[])new String[]{projectScriptPath, script.name});
        if (location.exists()) {
            return script.with(location);
        }
        location = FileUtil.fromParts((String[])new String[]{systemScriptPath, script.name});
        if (location.exists()) {
            return script.with(location);
        }
        if (script.name.startsWith("`") && script.name.endsWith("`")) {
            return new ShellScript(script);
        }
        return null;
    }

    String getProjectScriptPath() {
        if (this.scriptsPath.get() != null) {
            return this.scriptsPath.get();
        }
        String projectScriptsDir = Props.get((String)"scripts.dir", (Context)Context.named((String)"project"), (Scope)Props.getScope(), (File)this.configDirectory).value();
        String scriptsDir = projectScriptsDir.isEmpty() ? FileUtil.pathFromParts((String[])new String[]{".", "scripts"}) : projectScriptsDir;
        String projectConfigPath = FileUtil.getCanonicalPath((File)this.configDirectory);
        String projectScriptPath = FileUtil.getCanonicalPath((File)FileUtil.fromParts((String[])new String[]{projectConfigPath, "..", "..", scriptsDir}));
        this.scriptsPath.set(projectScriptPath);
        return projectScriptPath;
    }
}

