/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Iter;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.Args;
import net.ocheyedan.ply.cmd.CommandLineParser;
import net.ocheyedan.ply.cmd.build.Script;
import net.ocheyedan.ply.exec.Execution;
import net.ocheyedan.ply.graph.DirectedAcyclicGraph;
import net.ocheyedan.ply.graph.Graph;
import net.ocheyedan.ply.graph.Vertex;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public final class Alias
extends Script {
    static final Map<String, Resolver> cache = new HashMap<String, Resolver>();
    final List<Script> scripts;
    final List<String> adHocProps;

    static Alias getAlias(File configDirectory, Scope scope, String named) {
        Map<String, Alias> aliases = Alias.getAliases(configDirectory, scope);
        return aliases.get(named);
    }

    static Map<String, Alias> getAliases(File configDirectory, Scope scope) {
        String cacheKey = FileUtil.getCanonicalPath((File)configDirectory);
        if (cache.containsKey(cacheKey)) {
            return cache.get(cacheKey).getAliases(scope);
        }
        Resolver resolver = new Resolver(configDirectory);
        cache.put(cacheKey, resolver);
        return resolver.getAliases(scope);
    }

    Alias(String name, Scope scope, List<Script> scripts, List<String> arguments, List<String> adHocProps, String unparsed) {
        super(name, scope, arguments, unparsed);
        this.scripts = scripts;
        this.adHocProps = new ArrayList<String>(adHocProps);
    }

    @Override
    Script with(File location) {
        throw new UnsupportedOperationException("An Alias cannot have a location!");
    }

    @Override
    List<Execution> convert() {
        ArrayList<Execution> executions = new ArrayList<Execution>(this.scripts.size());
        for (Script script : this.scripts) {
            executions.addAll(script.convert(this.name));
        }
        if (!this.arguments.isEmpty()) {
            Execution last = (Execution)executions.get(executions.size() - 1);
            last = last.augment(this.arguments.toArray(new String[this.arguments.size()]));
            executions.set(executions.size() - 1, last);
        }
        return executions;
    }

    @Override
    protected List<Execution> convert(String overriddenExecutionName) {
        return this.convert();
    }

    Alias with(List<Script> scripts) {
        return new Alias(this.name, this.scope, scripts, this.arguments, this.adHocProps, this.unparsedName);
    }

    Alias augment(List<String> arguments, String unparsedName) {
        ArrayList<String> copiedArguments = new ArrayList<String>(this.arguments);
        copiedArguments.addAll(arguments);
        return new Alias(this.name, this.scope, this.scripts, copiedArguments, this.adHocProps, unparsedName);
    }

    static final class Resolver {
        final Map<Scope, Map<String, Alias>> cache = new HashMap<Scope, Map<String, Alias>>();
        final Map<Scope, Map<String, PropFile.Prop>> mappedPropCache = new HashMap<Scope, Map<String, PropFile.Prop>>();
        final File configDirectory;

        Resolver(File configDirectory) {
            this.configDirectory = configDirectory;
        }

        Map<String, Alias> getAliases(Scope scope) {
            if (this.cache.containsKey(scope)) {
                return this.cache.get(scope);
            }
            Map<String, PropFile.Prop> unparsedAliases = this.getUnparsedAliases(scope);
            HashMap<String, Alias> map = new HashMap<String, Alias>(unparsedAliases.size());
            for (PropFile.Prop prop : unparsedAliases.values()) {
                try {
                    Script parsed = Script.parse(prop.name, scope);
                    this.parseAlias(scope, parsed, prop.value(), unparsedAliases, (DirectedAcyclicGraph<String>)new DirectedAcyclicGraph(), map, Collections.<String>emptyList());
                }
                catch (CircularReference cr) {
                    Output.print((String)"^error^ Alias (^b^%s^r^) contains a circular reference (run '^b^ply get %s from aliases^r^' to analyze).", (Object[])new Object[]{cr.alias, cr.alias});
                    throw new SystemExit(1);
                }
            }
            this.cache.put(scope, map);
            return map;
        }

        Alias parseAlias(Scope scope, Script parsed, String value, Map<String, PropFile.Prop> unparsedAliases, DirectedAcyclicGraph<String> cycleDetector, Map<String, Alias> parsedAliases, List<String> adHocProps) {
            cycleDetector.addVertex((Object)parsed.name);
            Args args = CommandLineParser.parseArgs((Iter.Sized<String>)Iter.sized(Script.splitScript(value)));
            List<String> unparsedScripts = args.args;
            ArrayList<String> augmentedAdHocProps = new ArrayList<String>(adHocProps);
            augmentedAdHocProps.addAll(args.adHocProps);
            List<Script> scripts = this.parse(scope, parsed.scope, parsed.name, unparsedScripts, unparsedAliases, cycleDetector, parsedAliases);
            Alias alias = new Alias(parsed.name, parsed.scope, scripts, parsed.arguments, augmentedAdHocProps, parsed.unparsedName);
            parsedAliases.put(parsed.name, alias);
            return alias;
        }

        private List<Script> parse(Scope originalScope, Scope scope, String name, List<String> scripts, Map<String, PropFile.Prop> unparsedAliases, DirectedAcyclicGraph<String> cycleDetector, Map<String, Alias> parsedAliases) {
            ArrayList<Script> parsedScripts = new ArrayList<Script>(scripts.size());
            Vertex aliasVertex = cycleDetector.getVertex((Object)name);
            for (String script : scripts) {
                Script parsed = Script.parse(script, scope);
                Vertex scriptVertex = cycleDetector.addVertex((Object)parsed.name);
                try {
                    cycleDetector.addEdge(aliasVertex, scriptVertex);
                }
                catch (Graph.CycleException gce) {
                    throw new CircularReference(parsed.name);
                }
                if (!parsed.scope.equals((Object)originalScope)) {
                    Map<String, PropFile.Prop> scopedUnparsedAliases = this.getUnparsedAliases(parsed.scope);
                    if (scopedUnparsedAliases.containsKey(parsed.name)) {
                        Alias alias = this.parseAlias(parsed.scope, parsed, scopedUnparsedAliases.get(parsed.name).value(), scopedUnparsedAliases, (DirectedAcyclicGraph<String>)new DirectedAcyclicGraph(), new HashMap<String, Alias>(), Collections.<String>emptyList());
                        parsedScripts.add(alias.augment(parsed.arguments, parsed.unparsedName));
                        continue;
                    }
                    parsedScripts.add(parsed);
                    continue;
                }
                if (parsedAliases.containsKey(parsed.name)) {
                    parsedScripts.add(parsedAliases.get(parsed.name).augment(parsed.arguments, parsed.unparsedName));
                    continue;
                }
                if (unparsedAliases.containsKey(parsed.name)) {
                    Alias alias = this.parseAlias(parsed.scope, parsed, unparsedAliases.get(parsed.name).value(), unparsedAliases, cycleDetector, parsedAliases, Collections.<String>emptyList());
                    parsedScripts.add(alias.augment(parsed.arguments, parsed.unparsedName));
                    continue;
                }
                parsedScripts.add(parsed);
            }
            return parsedScripts;
        }

        private Map<String, PropFile.Prop> getUnparsedAliases(Scope scope) {
            if (this.mappedPropCache.containsKey(scope)) {
                return this.mappedPropCache.get(scope);
            }
            PropFileChain chain = Props.get((Context)Context.named((String)"aliases"), (Scope)scope, (File)this.configDirectory);
            HashMap<String, PropFile.Prop> map = new HashMap<String, PropFile.Prop>();
            for (PropFile.Prop prop : chain.props()) {
                map.put(prop.name, prop);
            }
            this.mappedPropCache.put(scope, map);
            return map;
        }
    }

    static final class CircularReference
    extends RuntimeException {
        final String alias;

        CircularReference(String alias) {
            this.alias = alias;
        }
    }
}

