/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.cmd;

import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.cmd.Args;

public abstract class Command
implements Runnable {
    public final Args args;

    protected Command(Args args) {
        this.args = args;
    }

    public static abstract class ProjectReliant
    extends SystemReliant {
        protected ProjectReliant(Args args) {
            super(args);
        }

        @Override
        protected void checkAssumptions() {
            super.checkAssumptions();
            if (!PlyUtil.LOCAL_CONFIG_DIR.exists()) {
                Output.print((String)"^warn^ not a ply project (or any of the parent directories), please initialize first: ^b^ply init^r^.", (Object[])new Object[0]);
                throw new SystemExit(1);
            }
        }
    }

    public static abstract class SystemReliant
    extends Command {
        protected SystemReliant(Args args) {
            super(args);
        }

        @Override
        public final void run() {
            this.runBeforeAssumptionsCheck();
            this.checkAssumptions();
            this.runAfterAssumptionsCheck();
        }

        protected abstract void runAfterAssumptionsCheck();

        protected abstract void runBeforeAssumptionsCheck();

        protected void checkAssumptions() {
            if (!PlyUtil.SYSTEM_CONFIG_DIR.exists()) {
                Output.print((String)"^error^ the ply install directory is corrupt, please re-install.", (Object[])new Object[0]);
                throw new SystemExit(1);
            }
        }
    }
}

