/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.IOException;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.jna.JnaAccessor;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.script.JarPackageScript;
import net.ocheyedan.ply.script.PackagingScript;

public class WarPackageScript
extends JarPackageScript
implements PackagingScript {
    @Override
    protected String getType() {
        return "war";
    }

    @Override
    protected String[] getIncludes(String compileDir, String resourceDir) {
        String manifestFile = WarPackageScript.getManifestFilePath();
        String explodedWarPath = this.getExplodedWarDirPath();
        return new String[]{manifestFile, "-C", explodedWarPath, "."};
    }

    @Override
    protected void preprocess() {
        super.preprocess();
        String buildDir = this.getBuildDir();
        File explodedWarDir = new File(this.getExplodedWarDirPath());
        explodedWarDir.mkdirs();
        String webappDir = Props.get((String)"webapp.dir", (Context)Context.named((String)"package")).value();
        FileUtil.copyDir((File)FileUtil.fromParts((String[])new String[]{webappDir}), (File)explodedWarDir);
        FileUtil.copyDir((File)FileUtil.fromParts((String[])new String[]{buildDir, "META-INF"}), (File)FileUtil.fromParts((String[])new String[]{explodedWarDir.getPath(), "META-INF"}));
        String buildPath = Props.get((String)"build.path", (Context)Context.named((String)"compiler")).value();
        String resBuildPath = Props.get((String)"res.build.dir", (Context)Context.named((String)"project")).value();
        File buildPathDir = new File(buildPath);
        File resBuildPathDir = new File(resBuildPath);
        if (buildPathDir.exists()) {
            FileUtil.copyDir((File)buildPathDir, (File)FileUtil.fromParts((String[])new String[]{explodedWarDir.getPath(), "WEB-INF", "classes"}));
        }
        if (resBuildPathDir.exists()) {
            FileUtil.copyDir((File)resBuildPathDir, (File)FileUtil.fromParts((String[])new String[]{explodedWarDir.getPath(), "WEB-INF", "classes"}));
        }
        PropFile resolvedProperties = Deps.getResolvedProperties((boolean)false);
        Output.print((String)"^info^ Copying dependencies for war file.", (Object[])new Object[0]);
        this.copyDependencies(resolvedProperties, FileUtil.fromParts((String[])new String[]{explodedWarDir.getPath(), "WEB-INF", "lib"}));
    }

    protected String getExplodedWarDirPath() {
        String explodedWarDir = Props.get((String)"exploded.war.dir", (Context)Context.named((String)"package")).value();
        if (explodedWarDir.endsWith(".war")) {
            explodedWarDir = explodedWarDir.substring(0, explodedWarDir.length() - 4);
        }
        return explodedWarDir;
    }

    protected void copyDependencies(PropFile resolvedProperties, File copyToDir) {
        copyToDir.mkdirs();
        for (PropFile.Prop resolvedKey : resolvedProperties.props()) {
            if (DependencyAtom.isTransient((String)resolvedKey.name)) continue;
            File dependency = new File(resolvedKey.value());
            File to = FileUtil.fromParts((String[])new String[]{copyToDir.getPath(), dependency.getName()});
            if (to.exists()) continue;
            if (JnaAccessor.getCUnixLibrary() != null) {
                JnaAccessor.getCUnixLibrary().symlink(dependency.getPath(), to.getPath());
                continue;
            }
            FileUtil.copy((File)dependency, (File)to);
        }
    }

    @Override
    protected int postprocess(int exitCode) throws IOException, InterruptedException {
        int sourceExitCode = this.packageSources();
        return sourceExitCode | exitCode;
    }
}

