/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashSet;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Props;

public final class ResourcesScript {
    public static void main(String[] args) {
        FilenameFilter excluding;
        PropFile.Prop resourcesDirProp = Props.get((String)"res.dir", (Context)Context.named((String)"project"));
        PropFile.Prop resourcesBuildDirProp = Props.get((String)"res.build.dir", (Context)Context.named((String)"project"));
        String resourcesExclusionPropValue = Props.get((String)"exclude", (Context)Context.named((String)"resources")).value();
        if (PropFile.Prop.Empty.equals((Object)resourcesDirProp) || PropFile.Prop.Empty.equals((Object)resourcesBuildDirProp)) {
            Output.print((String)"^error^ Could not find properties 'project.res.dir' or 'project.res.build.dir'", (Object[])new Object[0]);
            System.exit(1);
        }
        String[] split = resourcesExclusionPropValue.split(",");
        final HashSet<String> exclusions = new HashSet<String>(Arrays.asList(split));
        File resDir = new File(resourcesDirProp.value());
        if (!resDir.exists()) {
            Output.print((String)"^dbug^ No resources to copy.", (Object[])new Object[0]);
            return;
        }
        File resBuildDir = new File(resourcesBuildDirProp.value());
        FilenameFilter filenameFilter = excluding = exclusions.isEmpty() ? null : new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return exclusions.contains(name);
            }
        };
        if (!FileUtil.copyDir((File)resDir, (File)resBuildDir, (FilenameFilter)excluding)) {
            Output.print((String)"^error^ Could not copy resources directory (%s) to resources build directory (%s).", (Object[])new Object[]{resourcesDirProp.value(), resourcesBuildDirProp.value()});
            System.exit(1);
        }
    }

    private ResourcesScript() {
    }
}

