/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.script;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.SlowTaskThread;
import net.ocheyedan.ply.SystemExit;
import net.ocheyedan.ply.dep.ConflictingVersionVisitor;
import net.ocheyedan.ply.dep.Dep;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.Deps;
import net.ocheyedan.ply.dep.Repos;
import net.ocheyedan.ply.dep.RepositoryRegistry;
import net.ocheyedan.ply.graph.DirectedAcyclicGraph;
import net.ocheyedan.ply.graph.Graph;
import net.ocheyedan.ply.graph.Vertex;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.PropFiles;
import net.ocheyedan.ply.props.Props;
import net.ocheyedan.ply.props.Scope;

public class DependencyManager {
    private static final String TRANSIENT_PRINT = " ^black^[transient]^r^";

    public static void main(String[] args) {
        if (args == null || args.length > 0 && "--usage".equals(args[0])) {
            DependencyManager.usage();
            return;
        }
        Scope scope = Scope.named((String)Props.get((String)"scope", (Context)Context.named((String)"ply")).value());
        Context projectContext = Context.named((String)"project");
        if (args.length > 1 && "add".equals(args[0])) {
            DependencyManager.addDependency(args[1], scope);
        } else if (args.length > 1 && "rm".equals(args[0])) {
            DependencyManager.removeDependency(args[1], scope);
        } else if (args.length > 1 && "exclude".equals(args[0])) {
            DependencyManager.excludeDependency(args[1], scope);
        } else if (args.length == 1 && "exclude-min".equals(args[0])) {
            DependencyManager.excludeMinimum(scope);
        } else if (args.length == 1 && "list".equals(args[0])) {
            PropFile dependencies = DependencyManager.getDependencies(scope);
            int size = dependencies.size();
            if (size > 0) {
                Output.print((String)"Project ^b^%s^r^ has ^b^%d^r^ %sdependenc%s: ", (Object[])new Object[]{Props.get((String)"name", (Context)projectContext).value(), size, scope.getPrettyPrint(), size == 1 ? "y" : "ies"});
                List<PropFile.Prop> sorted = DependencyManager.collect(dependencies.props(), size);
                Collections.sort(sorted);
                for (PropFile.Prop dep : sorted) {
                    String value = dep.value();
                    boolean transientDep = DependencyAtom.isTransient((String)value);
                    if (transientDep) {
                        value = DependencyAtom.stripTransient((String)value);
                    }
                    Output.print((String)"  %s:%s%s", (Object[])new Object[]{dep.name, value, transientDep ? TRANSIENT_PRINT : ""});
                }
            } else {
                Output.print((String)"Project ^b^%s^r^ has no %sdependencies.", (Object[])new Object[]{Props.get((String)"name", (Context)projectContext).value(), scope.getPrettyPrint()});
            }
        } else if (args.length == 1 && "tree".equals(args[0])) {
            List dependencies = Deps.parse((PropFile)DependencyManager.getDependencies(scope), null);
            if (dependencies.isEmpty()) {
                Output.print((String)"Project ^b^%s^r^ has no %sdependencies.", (Object[])new Object[]{Props.get((String)"name", (Context)projectContext).value(), scope.getPrettyPrint()});
            } else {
                HashSet exclusions = new HashSet(Deps.parseExclusions((PropFile)DependencyManager.getExclusions(scope), null));
                DirectedAcyclicGraph depGraph = Deps.getDependencyGraph((List)dependencies, exclusions, (RepositoryRegistry)DependencyManager.createRepositoryList(null, null));
                int size = dependencies.size();
                int graphSize = depGraph.getRootVertices().size();
                if (graphSize > size) {
                    throw new AssertionError((Object)"Dependency graph's root-vertices should not be greater than the specified dependencies.");
                }
                String sizeExplanation = size != graphSize ? String.format(" [ actually %d; %d of which %s pulled in transitively ]", size, size - graphSize, size - graphSize > 1 ? "are" : "is") : "";
                Output.print((String)"Project ^b^%s^r^ has ^b^%d^r^ direct %sdependenc%s%s: ", (Object[])new Object[]{Props.get((String)"name", (Context)projectContext).value(), graphSize, scope.getPrettyPrint(), size == 1 ? "y" : "ies", sizeExplanation});
                DependencyManager.printDependencyGraph(depGraph.getRootVertices(), "", 0, new HashSet<Vertex<Dep>>());
            }
        } else if (args.length > 1 && "resolve-classifiers".equals(args[0])) {
            String[] classifiers = args[1].split(",");
            PropFile dependencies = DependencyManager.getDependencies(scope);
            PropFile exclusions = DependencyManager.getExclusions(scope);
            for (String classifier : classifiers) {
                DependencyManager.resolveDependencies(dependencies, exclusions, classifier, false);
            }
        } else if (args.length == 0) {
            PropFile dependencies = DependencyManager.getDependencies(scope);
            PropFile exclusions = DependencyManager.getExclusions(scope);
            int size = dependencies.size();
            int exclusionsSize = DependencyManager.getExclusionsSize(exclusions);
            if (size > 0) {
                String exclusionsDescription = "";
                if (exclusionsSize > 0) {
                    exclusionsDescription = String.format(" (with ^b^%d^r^ exclusion%s)", exclusionsSize, exclusionsSize == 1 ? "" : "s");
                }
                Output.print((String)"Resolving ^b^%d^r^ %sdependenc%s for ^b^%s^r^%s.", (Object[])new Object[]{size, scope.getPrettyPrint(), size == 1 ? "y" : "ies", Props.get((String)"name", (Context)projectContext).value(), exclusionsDescription});
                PropFile dependencyFiles = DependencyManager.resolveDependencies(dependencies, exclusions, null, true);
                DependencyManager.storeResolvedDependenciesFile(dependencyFiles, scope);
            }
        } else {
            DependencyManager.usage();
        }
    }

    private static List<PropFile.Prop> collect(Iterable<PropFile.Prop> deps, int expectedSize) {
        ArrayList<PropFile.Prop> props = new ArrayList<PropFile.Prop>(expectedSize);
        for (PropFile.Prop dep : deps) {
            props.add(dep);
        }
        return props;
    }

    private static int getExclusionsSize(PropFile exclusions) {
        int size = exclusions.size();
        for (PropFile.Prop exclusion : exclusions.props()) {
            size += DependencyManager.countMatches(exclusion.value(), ' ');
        }
        return size;
    }

    private static int countMatches(String value, char character) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = value.indexOf(character, index)) != -1) {
            ++count;
            ++index;
        }
        return count;
    }

    private static void addDependency(String dependency, Scope scope) {
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        DependencyAtom atom = DependencyAtom.parse((String)dependency, error);
        if (atom == null) {
            Output.print((String)"^error^ Dependency ^b^%s^r^ ^b^%s^r^ (format namespace:name:version[:artifactName]).", (Object[])new Object[]{dependency, error.get()});
            throw new SystemExit(1);
        }
        PropFile dependencies = DependencyManager.loadDependenciesFile(scope);
        if (dependencies.contains(atom.getPropertyName())) {
            PropFile.Prop existingDep = dependencies.get(atom.getPropertyName());
            DependencyAtom existing = Deps.parse((PropFile.Prop)existingDep);
            if (existing == null) {
                Output.print((String)"^error^ Could not parse dependency atom, %s=%s, listed in dependencies%s.properties.", (Object[])new Object[]{existingDep.name, existingDep.value(), scope.getFileSuffix()});
            } else {
                if (existing.equals((Object)atom)) {
                    Output.print((String)"Project already depends upon %s%s, skipping.", (Object[])new Object[]{atom.toString(), !Scope.Default.equals((Object)scope) ? String.format(" (in scope %s)", scope.getPrettyPrint()) : ""});
                    return;
                }
                Output.print((String)"^warn^ overriding %sdependency %s; was %s now is %s.", (Object[])new Object[]{scope.getPrettyPrint(), atom.getPropertyName(), dependencies.get(atom.getPropertyName()).value(), atom.getPropertyValue()});
                PropFile.Prop existingProp = dependencies.remove(atom.getPropertyName());
                Deps.addChangedDependency((Scope)scope, (DependencyAtom)Deps.parse((PropFile.Prop)existingProp));
            }
        }
        dependencies.add(atom.getPropertyName(), atom.getPropertyValue());
        final List dependencyAtoms = Deps.parse((PropFile)dependencies, null);
        PropFile exclusions = DependencyManager.getExclusions(scope);
        final HashSet exclusionAtoms = new HashSet(Deps.parseExclusions((PropFile)exclusions, null));
        final RepositoryRegistry repositoryRegistry = DependencyManager.createRepositoryList(Deps.getProjectDep(), dependencyAtoms);
        DirectedAcyclicGraph<Dep> resolvedDeps = DependencyManager.invokeWithSlowResolutionThread(new Callable<DirectedAcyclicGraph<Dep>>(){

            @Override
            public DirectedAcyclicGraph<Dep> call() throws Exception {
                return Deps.getDependencyGraph((List)dependencyAtoms, (Set)exclusionAtoms, (RepositoryRegistry)repositoryRegistry);
            }
        }, String.format("^b^Hang tight,^r^ %s has a lot of dependencies. ^b^Ply^r^'s downloading them...", dependency));
        if (resolvedDeps != null) {
            DependencyManager.storeDependenciesFile(dependencies, scope);
        }
        Output.print((String)"Added dependency %s%s", (Object[])new Object[]{atom.toString(), !Scope.Default.equals((Object)scope) ? String.format(" (in scope %s)", scope.getPrettyPrint()) : ""});
    }

    private static void removeDependency(String dependency, Scope scope) {
        DependencyAtom atom = DependencyAtom.parse((String)dependency, null);
        if (atom == null) {
            String[] split = dependency.split(":");
            if (split.length < 2) {
                Output.print((String)"^error^ Dependency ^b^%s^r^ ^b^%s^r^ (format namespace:name[:version:artifactName]).", (Object[])new Object[]{dependency, split.length == 1 ? "name" : "namespace and name"});
                System.exit(1);
            }
            atom = new DependencyAtom(split[0], split[1], null);
        }
        if (Props.get((String)atom.getPropertyName(), (Context)Context.named((String)"dependencies")).value().isEmpty()) {
            Output.print((String)"^warn^ Could not find %sdependency; given %s:%s", (Object[])new Object[]{scope.getPrettyPrint(), atom.getPropertyName(), atom.getPropertyValue()});
        } else {
            PropFile dependencies = DependencyManager.loadDependenciesFile(scope);
            PropFile.Prop existing = dependencies.remove(atom.getPropertyName());
            DependencyManager.storeDependenciesFile(dependencies, scope);
            Deps.addChangedDependency((Scope)scope, (DependencyAtom)Deps.parse((PropFile.Prop)existing));
            Output.print((String)"Removed dependency %s%s", (Object[])new Object[]{atom.toString(), !Scope.Default.equals((Object)scope) ? String.format(" (in scope %s)", scope.getPrettyPrint()) : ""});
        }
    }

    private static void excludeDependency(String dependency, Scope scope) {
        DependencyAtom atom = DependencyAtom.parse((String)dependency, null);
        if (atom == null) {
            String[] split = dependency.split(":");
            if (split.length < 2) {
                Output.print((String)"^error^ Dependency ^b^%s^r^ ^b^%s^r^ (format namespace:name[:version:artifactName]).", (Object[])new Object[]{dependency, split.length == 1 ? "name" : "namespace and name"});
                System.exit(1);
            }
            atom = new DependencyAtom(split[0], split[1], null);
        }
        PropFile exclusions = DependencyManager.loadExclusionsFile(scope);
        DependencyManager.exclude(atom, exclusions);
        DependencyManager.storeExclusionsFile(exclusions, scope);
        Output.print((String)"Excluded dependency %s%s", (Object[])new Object[]{atom.toString(), !Scope.Default.equals((Object)scope) ? String.format(" (in scope %s)", scope.getPrettyPrint()) : ""});
    }

    private static void excludeMinimum(Scope scope) {
        PropFile exclusions = DependencyManager.getExclusions(scope);
        int excluded = 0;
        int totalExclusions = 0;
        while ((excluded = DependencyManager.excludeMinimumForCurrentExclusions(scope, exclusions)) != 0) {
            exclusions = DependencyManager.loadExclusionsFile(scope);
            totalExclusions += excluded;
        }
        Output.print((String)"Excluded %d dependencies%s", (Object[])new Object[]{totalExclusions, !Scope.Default.equals((Object)scope) ? String.format(" (in scope %s)", scope.getPrettyPrint()) : ""});
    }

    private static int excludeMinimumForCurrentExclusions(Scope scope, PropFile exclusions) {
        PropFile dependencies = DependencyManager.getDependencies(scope);
        final HashSet foundExclusions = new HashSet();
        DependencyManager.resolveDependenciesImmediately(dependencies, exclusions, null, false, new ConflictingVersionVisitor(){

            public void visit(Dep diffVersionDep, Dep resolvedDep, Vertex<Dep> parentVertex, DependencyAtom dependencyAtom, Graph<Dep> graph) {
                Vertex diffVersionParent = graph.getVertex((Object)diffVersionDep).getAnyParent();
                String diffVersionPath = Deps.getPathAsString((Vertex)diffVersionParent, (DependencyAtom)diffVersionDep.dependencyAtom);
                String path = Deps.getPathAsString(parentVertex, (DependencyAtom)dependencyAtom);
                DependencyAtom lower = Deps.getMinimumVersion((DependencyAtom)diffVersionDep.dependencyAtom, (DependencyAtom)resolvedDep.dependencyAtom);
                if (lower == null) {
                    Output.print((String)"^warn^ Could not determine lower of the two versions for ^b^%s^r^ [ ^yellow^%s^r^ ] and [ ^yellow^%s^r^ ].", (Object[])new Object[]{resolvedDep.toString(), diffVersionDep.dependencyAtom.getPropertyValue(), resolvedDep.dependencyAtom.getPropertyValue()});
                    Output.print((String)"^warn^   ^b^%s^r^ => %s", (Object[])new Object[]{diffVersionDep.dependencyAtom.getPropertyValue(), diffVersionPath == null ? "<direct dependency>" : diffVersionPath});
                    Output.print((String)"^warn^   ^b^%s^r^ => %s", (Object[])new Object[]{resolvedDep.dependencyAtom.getPropertyValue(), path == null ? "<direct dependency>" : path});
                    Output.print((String)"^warn^ You can manually resolve this by excluding one of these versions from your project's dependency graph: ^b^ply dep exclude^r^ [ ^b^%s^r^ | ^b^%s^r^ ]", (Object[])new Object[]{diffVersionDep.toVersionString(), resolvedDep.toVersionString()});
                    return;
                }
                if (lower == resolvedDep.dependencyAtom && path == null || lower == diffVersionDep.dependencyAtom && diffVersionPath == null) {
                    Output.print((String)"^warn^ Directly depending upon a lower version than found elsewhere in the dependency graph for ^b^%s^r^ [ ^yellow^%s^r^ ] and [ ^yellow^%s^r^ ].", (Object[])new Object[]{resolvedDep.toString(), diffVersionDep.dependencyAtom.getPropertyValue(), resolvedDep.dependencyAtom.getPropertyValue()});
                    Output.print((String)"^warn^   ^b^%s^r^ => %s", (Object[])new Object[]{diffVersionDep.dependencyAtom.getPropertyValue(), diffVersionPath == null ? "<direct dependency>" : diffVersionPath});
                    Output.print((String)"^warn^   ^b^%s^r^ => %s", (Object[])new Object[]{resolvedDep.dependencyAtom.getPropertyValue(), path == null ? "<direct dependency>" : path});
                    Output.print((String)"^warn^ Either remove the direct dependency or manually exclude the higher version.", (Object[])new Object[0]);
                    return;
                }
                Output.print((String)"^info^ Excluding ^b^%s^r^ version ^b^%s^r^ (as it is less than version ^b^%s^r^)", (Object[])new Object[]{lower.getPropertyName(), lower.getPropertyValue(), lower == diffVersionDep.dependencyAtom ? resolvedDep.dependencyAtom.getPropertyValue() : diffVersionDep.dependencyAtom.getPropertyValue()});
                foundExclusions.add(lower);
            }
        });
        PropFile exclusionsPropFile = DependencyManager.loadExclusionsFile(scope);
        for (DependencyAtom foundExclusion : foundExclusions) {
            DependencyManager.exclude(foundExclusion, exclusionsPropFile);
        }
        DependencyManager.storeExclusionsFile(exclusionsPropFile, scope);
        return foundExclusions.size();
    }

    private static void exclude(DependencyAtom atom, PropFile exclusions) {
        if (exclusions.contains(atom.getPropertyName())) {
            String versions = String.format("%s %s", exclusions.get(atom.getPropertyName()).value(), atom.getPropertyValue());
            exclusions.set(atom.getPropertyName(), versions);
        } else {
            exclusions.add(atom.getPropertyName(), atom.getPropertyValue());
        }
    }

    private static RepositoryRegistry createRepositoryList(DependencyAtom dependencyAtom, List<DependencyAtom> dependencyAtoms) {
        try {
            return Repos.createRepositoryRegistry((File)PlyUtil.LOCAL_CONFIG_DIR, (Scope)Props.getScope(), (DependencyAtom)dependencyAtom, dependencyAtoms);
        }
        catch (SystemExit se) {
            System.exit(se.exitCode);
            throw new AssertionError((Object)"Not reachable");
        }
    }

    private static PropFile resolveDependencies(final PropFile dependencies, final PropFile exclusions, final String classifier, final boolean failMissingDependency) {
        return DependencyManager.invokeWithSlowResolutionThread(new Callable<PropFile>(){

            @Override
            public PropFile call() throws Exception {
                return DependencyManager.resolveDependenciesImmediately(dependencies, exclusions, classifier, failMissingDependency, null);
            }
        }, "^b^Hang tight,^r^ your project needs a lot of dependencies. ^b^Ply^r^'s downloading them...");
    }

    private static PropFile resolveDependenciesImmediately(PropFile dependencies, PropFile exclusions, String classifier, boolean failMissingDependency, ConflictingVersionVisitor conflictingVersionVisitor) {
        DependencyAtom self = Deps.getProjectDep();
        List dependencyAtoms = Deps.parse((PropFile)dependencies, (String)classifier);
        HashSet exclusionAtoms = new HashSet(Deps.parseExclusions((PropFile)exclusions, (String)classifier));
        RepositoryRegistry repositoryRegistry = DependencyManager.createRepositoryList(self, dependencyAtoms);
        DirectedAcyclicGraph dependencyGraph = conflictingVersionVisitor != null ? Deps.getDependencyGraph((List)dependencyAtoms, exclusionAtoms, (RepositoryRegistry)repositoryRegistry, (String)classifier, (boolean)failMissingDependency, (ConflictingVersionVisitor)conflictingVersionVisitor) : Deps.getDependencyGraph((List)dependencyAtoms, exclusionAtoms, (RepositoryRegistry)repositoryRegistry, (String)classifier, (boolean)failMissingDependency);
        return Deps.convertToResolvedPropertiesFile((DirectedAcyclicGraph)dependencyGraph);
    }

    private static <T> T invokeWithSlowResolutionThread(Callable<T> callable, String message) {
        try {
            return (T)SlowTaskThread.after((long)2000L).warn(message).onlyIfNotLoggingInfo().whenDoing(callable).start();
        }
        catch (Exception e) {
            Output.print((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    private static PropFile getDependencies(Scope scope) {
        PropFileChain nonScopedDependencies = Props.get((Context)Context.named((String)"dependencies"));
        PropFile scopedDependencies = new PropFile(Context.named((String)"dependencies"), scope, PropFile.Loc.Local);
        if (!scope.name.isEmpty() && "test".equals(scope.name)) {
            DependencyAtom self = DependencyAtom.parse((String)Props.get((String)"nonscoped.artifact.name", (Context)Context.named((String)"project")).value(), null);
            if (self == null) {
                throw new AssertionError((Object)"Could not determine the project information.");
            }
            scopedDependencies.add(self.namespace + ":" + self.name, self.version + ":" + self.getArtifactName());
        }
        for (PropFile.Prop dependency : nonScopedDependencies.props()) {
            scopedDependencies.add(dependency.name, dependency.value());
        }
        return scopedDependencies;
    }

    private static PropFile getExclusions(Scope scope) {
        PropFileChain exclusions = Props.get((Context)Context.named((String)"exclusions"), (Scope)scope);
        PropFile scopedExclusions = new PropFile(Context.named((String)"exclusions"), scope, PropFile.Loc.Local);
        for (PropFile.Prop exclusion : exclusions.props()) {
            if (scopedExclusions.contains(exclusion.name)) {
                String versions = String.format("%s %s", scopedExclusions.get(exclusion.name).value(), exclusion.value());
                scopedExclusions.set(exclusion.name, versions);
                continue;
            }
            scopedExclusions.add(exclusion.name, exclusion.value());
        }
        return scopedExclusions;
    }

    private static PropFile loadDependenciesFile(Scope scope) {
        return DependencyManager.loadFile(scope, "dependencies", true);
    }

    private static PropFile loadExclusionsFile(Scope scope) {
        return DependencyManager.loadFile(scope, "exclusions", false);
    }

    private static PropFile loadFile(Scope scope, String fileName, boolean create) {
        String localDir = Props.get((String)"project.dir", (Context)Context.named((String)"ply")).value();
        String loadPath = localDir + (localDir.endsWith(File.separator) ? "" : File.separator) + "config" + File.separator + fileName + scope.getFileSuffix() + ".properties";
        return PropFiles.load((String)loadPath, (boolean)create, (boolean)false);
    }

    private static void storeDependenciesFile(PropFile dependencies, Scope scope) {
        String localDir = Props.get((String)"project.dir", (Context)Context.named((String)"ply")).value();
        String storePath = localDir + (localDir.endsWith(File.separator) ? "" : File.separator) + "config" + File.separator + "dependencies" + scope.getFileSuffix() + ".properties";
        if (!PropFiles.store((PropFile)dependencies, (String)storePath, (boolean)true)) {
            System.exit(1);
        }
    }

    private static void storeExclusionsFile(PropFile exclusions, Scope scope) {
        String localDir = Props.get((String)"project.dir", (Context)Context.named((String)"ply")).value();
        String storePath = localDir + (localDir.endsWith(File.separator) ? "" : File.separator) + "config" + File.separator + "exclusions" + scope.getFileSuffix() + ".properties";
        if (!PropFiles.store((PropFile)exclusions, (String)storePath, (boolean)true)) {
            System.exit(1);
        }
    }

    private static void storeResolvedDependenciesFile(PropFile resolvedDependencies, Scope scope) {
        String storePath = DependencyManager.getBuildDirStorePath("resolved-deps", scope);
        if (!PropFiles.store((PropFile)resolvedDependencies, (String)storePath, (boolean)true)) {
            System.exit(1);
        }
    }

    private static String getBuildDirStorePath(String name, Scope scope) {
        String buildDirPath = Props.get((String)"build.dir", (Context)Context.named((String)"project")).value();
        return buildDirPath + (buildDirPath.endsWith(File.separator) ? "" : File.separator) + name + scope.getFileSuffix() + ".properties";
    }

    private static void printDependencyGraph(List<Vertex<Dep>> vertices, String indent, int depth, Set<Vertex<Dep>> encountered) {
        if (vertices == null || vertices.isEmpty()) {
            return;
        }
        for (Vertex<Dep> vertex : vertices) {
            int currentDepth = depth;
            boolean enc = encountered.contains(vertex);
            if (!enc) {
                encountered.add(vertex);
            }
            Dep dep = (Dep)vertex.getValue();
            String namespace = dep.dependencyAtom.namespace;
            String name = dep.dependencyAtom.name;
            String version = dep.dependencyAtom.getPropertyValueWithoutTransient();
            Output.print((String)"%s%s^grey^%s:^r^^b^%s:%s^r^%s%s", (Object[])new Object[]{indent, DependencyManager.getDepthSubscript(depth), namespace, name, version, dep.dependencyAtom.transientDep ? TRANSIENT_PRINT : "", enc ? " (already printed)" : ""});
            if (enc || dep.dependencyAtom.transientDep) continue;
            DependencyManager.printDependencyGraph(vertex.getChildren(), String.format("  %s %s", PlyUtil.isUnicodeSupported() ? "\u2937" : "\\", indent), ++currentDepth, encountered);
        }
    }

    private static String getDepthSubscript(int depth) {
        switch (depth) {
            case 0: {
                return PlyUtil.isUnicodeSupported() ? "\u2080 " : "0 ";
            }
            case 1: {
                return PlyUtil.isUnicodeSupported() ? "\u2081 " : "1 ";
            }
            case 2: {
                return PlyUtil.isUnicodeSupported() ? "\u2082 " : "2 ";
            }
            case 3: {
                return PlyUtil.isUnicodeSupported() ? "\u2083 " : "3 ";
            }
            case 4: {
                return PlyUtil.isUnicodeSupported() ? "\u2084 " : "4 ";
            }
            case 5: {
                return PlyUtil.isUnicodeSupported() ? "\u2085 " : "5 ";
            }
            case 6: {
                return PlyUtil.isUnicodeSupported() ? "\u2086 " : "6 ";
            }
            case 7: {
                return PlyUtil.isUnicodeSupported() ? "\u2087 " : "7 ";
            }
            case 8: {
                return PlyUtil.isUnicodeSupported() ? "\u2088 " : "8 ";
            }
            case 9: {
                return PlyUtil.isUnicodeSupported() ? "\u2089 " : "9 ";
            }
        }
        return PlyUtil.isUnicodeSupported() ? "\u2089\u208a " : "9+ ";
    }

    private static void usage() {
        Output.print((String)"dep [--usage] <^b^command^r^>", (Object[])new Object[0]);
        Output.print((String)"  where ^b^command^r^ is either:", (Object[])new Object[0]);
        Output.print((String)"    ^b^add <dep-atom>^r^ : adds dep-atom to the list of dependencies (within scope) (or replacing the version if it already exists).", (Object[])new Object[0]);
        Output.print((String)"    ^b^rm <dep-atom>^r^ : removes dep-atom from the list of dependencies (within scope).", (Object[])new Object[0]);
        Output.print((String)"    ^b^exclude <dep-atom>^r^ : excludes dep-atom from the list of dependencies (within scope).", (Object[])new Object[0]);
        Output.print((String)"    ^b^exclude-min^r^ : for any conflicting versions, excludes the minimum version (within scope).", (Object[])new Object[0]);
        Output.print((String)"    ^b^list^r^ : list all direct dependencies (within scope excluding transitive dependencies).", (Object[])new Object[0]);
        Output.print((String)"    ^b^tree^r^ : print all dependencies in a tree view (within scope including transitive dependencies).", (Object[])new Object[0]);
        Output.print((String)"    ^b^resolve-classifiers <classifiers>^r^ : resolves dependencies with each of the (comma delimited) classifiers.", (Object[])new Object[0]);
        Output.print((String)"  ^b^dep-atom^r^ is namespace:name:version[:artifactName] (artifactName is optional and defaults to name-version.jar).", (Object[])new Object[0]);
        Output.print((String)"  if no command is passed then dependency resolution is done for all dependencies against the known repositories.", (Object[])new Object[0]);
        Output.print((String)"  Dependencies can be grouped by ^b^scope^r^ (i.e. test).  The default scope is null.", (Object[])new Object[0]);
    }
}

