/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ocheyedan.ply.PlyUtil;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.Filter;
import net.ocheyedan.ply.props.Loader;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Scope;

public final class Props {
    public static Map<Context, PropFileChain> get() {
        return Props.get(Props.getScope(), PlyUtil.LOCAL_CONFIG_DIR);
    }

    public static Map<Context, PropFileChain> get(Scope scope) {
        return Props.get(scope, PlyUtil.LOCAL_CONFIG_DIR);
    }

    public static Map<Context, PropFileChain> get(Scope scope, File configurationDirectory) {
        return Props.get(scope, configurationDirectory, false);
    }

    public static Map<Context, PropFileChain> get(Scope scope, File configurationDirectory, boolean ignoreCache) {
        Map<Scope, Map<Context, PropFileChain>> loaded = Loader.load(configurationDirectory, ignoreCache);
        if (loaded == null || !loaded.containsKey(scope)) {
            if (loaded != null && !Scope.Default.equals(scope) && loaded.containsKey(Scope.Default)) {
                return loaded.get(Scope.Default);
            }
            return Collections.emptyMap();
        }
        return loaded.get(scope);
    }

    public static Map<Scope, Map<Context, PropFileChain>> get(File configurationDirectory) {
        Map<Scope, Map<Context, PropFileChain>> loaded = Loader.load(configurationDirectory);
        if (loaded == null) {
            return Collections.emptyMap();
        }
        return loaded;
    }

    public static PropFileChain get(Context context) {
        return Props.get(context, Props.getScope(), PlyUtil.LOCAL_CONFIG_DIR);
    }

    public static PropFileChain get(Context context, Scope scope) {
        return Props.get(context, scope, PlyUtil.LOCAL_CONFIG_DIR);
    }

    public static PropFileChain get(Context context, Scope scope, File configurationDirectory) {
        return Props.get(context, scope, configurationDirectory, false);
    }

    public static PropFileChain get(Context context, Scope scope, File configurationDirectory, boolean ignoreCache) {
        Map<Context, PropFileChain> loaded = Props.get(scope, configurationDirectory, ignoreCache);
        if (loaded.containsKey(context)) {
            return loaded.get(context);
        }
        return new PropFileChain(Collections.<Context, PropFileChain>emptyMap());
    }

    public static PropFile.Prop get(String named, Context context) {
        return Props.get(named, context, Props.getScope(), PlyUtil.LOCAL_CONFIG_DIR);
    }

    public static PropFile.Prop get(String named, Context context, Scope scope) {
        return Props.get(named, context, scope, PlyUtil.LOCAL_CONFIG_DIR);
    }

    public static PropFile.Prop get(String named, Context context, Scope scope, File configurationDirectory) {
        return Props.get(named, context, scope, configurationDirectory, false);
    }

    public static PropFile.Prop get(String named, Context context, Scope scope, File configurationDirectory, boolean ignoreCache) {
        PropFileChain chain = Props.get(context, scope, configurationDirectory, ignoreCache);
        return chain.get(named);
    }

    public static Scope getScope() {
        String scope = System.getenv("ply_ply.scope");
        return scope == null ? Scope.Default : new Scope(scope);
    }

    static void addAdHoc(Scope scope, Context context, PropFile adHocPropFile) {
        PropFileChain chain;
        Map<Scope, Map<Context, PropFileChain>> loaded = Loader.load(PlyUtil.LOCAL_CONFIG_DIR);
        Map<Context, PropFileChain> contexts = loaded.get(scope);
        if (contexts == null) {
            contexts = new ConcurrentHashMap<Context, PropFileChain>();
            loaded.put(scope, contexts);
        }
        if ((chain = contexts.get(context)) == null) {
            chain = new PropFileChain(contexts);
            contexts.put(context, chain);
        }
        chain.set(adHocPropFile, PropFile.Loc.AdHoc);
        if (Scope.Default.equals(scope)) {
            for (Scope otherScope : loaded.keySet()) {
                if (Scope.Default.equals(otherScope)) continue;
                Props.addAdHoc(otherScope, context, adHocPropFile);
            }
        }
    }

    static void invalidateFilteredCaches(File configDirectory) {
        Map<Scope, Map<Context, PropFileChain>> loaded = Loader.load(configDirectory);
        for (Scope scope : loaded.keySet()) {
            Map<Context, PropFileChain> contexts = loaded.get(scope);
            for (Context context : contexts.keySet()) {
                PropFileChain chain = contexts.get(context);
                chain.invalidateFilteredCache();
            }
        }
        Filter.clearCache();
    }

    private Props() {
    }
}

