/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.io.BufferedReader;
import java.io.IOException;
import net.ocheyedan.ply.props.PropFile;

public interface PropFileReader {
    public static final PropFileReader Default = new PropFileReader(){

        @Override
        public void load(BufferedReader reader, PropFile into) throws IOException {
            String line;
            if (reader == null || into == null) {
                throw new NullPointerException("The BufferedReader and PropFile cannot be null.");
            }
            StringBuilder commentsBuffer = new StringBuilder();
            ParseResult parsing = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() && parsing == null) continue;
                if (line.startsWith("#")) {
                    if (commentsBuffer.length() > 0) {
                        commentsBuffer.append("\n");
                    }
                    commentsBuffer.append(line.substring(1));
                    continue;
                }
                ParseResult parsedLine = this.parse(line);
                if (parsing != null) {
                    if (!parsedLine.key.isEmpty()) {
                        throw new Invalid(parsedLine.key, into.context().name, "Properties may only have one key.");
                    }
                    parsing = new ParseResult(false, parsing.key, String.format("%s%s", parsing.value, parsedLine.value));
                } else {
                    parsing = parsedLine;
                }
                if (!parsedLine.complete.booleanValue()) continue;
                if (parsing.key.isEmpty()) {
                    throw new Invalid(line, into.context().name, "Keys must be non-empty.");
                }
                if (into.contains(parsing.key)) {
                    throw new Invalid(parsing.key, into.context().name, "Keys must be unique.");
                }
                into.add(parsing.key.trim(), parsing.value.trim(), commentsBuffer.toString());
                parsing = null;
                commentsBuffer = new StringBuilder();
            }
        }

        private ParseResult parse(String line) {
            String value;
            StringBuilder buffer = new StringBuilder();
            String key = "";
            boolean isEscaped = false;
            block5: for (char character : line.toCharArray()) {
                switch (character) {
                    case '\\': {
                        isEscaped = true;
                        continue block5;
                    }
                    case '=': {
                        if (isEscaped || !key.isEmpty()) {
                            buffer.append('=');
                        } else {
                            key = buffer.toString();
                            buffer = new StringBuilder();
                        }
                        isEscaped = false;
                        continue block5;
                    }
                    case ' ': 
                    case ':': {
                        if (isEscaped && key.isEmpty()) {
                            isEscaped = false;
                        }
                    }
                    default: {
                        if (isEscaped) {
                            buffer.append('\\');
                        }
                        buffer.append(character);
                        isEscaped = false;
                    }
                }
            }
            if (isEscaped) {
                buffer.append('\\');
            }
            if ((value = buffer.toString()).endsWith("\\")) {
                return new ParseResult(false, key, value.substring(0, value.length() - 1));
            }
            return new ParseResult(true, key, value);
        }

        class ParseResult {
            private final Boolean complete;
            private final String key;
            private final String value;

            ParseResult(Boolean complete, String key, String value) {
                this.complete = complete;
                this.key = key;
                this.value = value;
            }
        }
    };

    public void load(BufferedReader var1, PropFile var2) throws Invalid, IOException;

    public static final class Invalid
    extends RuntimeException {
        final String invalidEntry;
        final String fileName;

        Invalid(String invalidEntry, String fileName, String message) {
            super(message);
            this.invalidEntry = invalidEntry;
            this.fileName = fileName;
        }
    }
}

