/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.props;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.PropFileChain;
import net.ocheyedan.ply.props.Scope;

public final class Filter {
    public static final String DECORATOR = "_^$f$^_";
    public static final String DECORATOR_SCOPED = "_^$fs$^_";
    public static final String DECORATOR_END = "_$^f^$_";
    private static final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> cacheDecorated = new ConcurrentHashMap<String, String>();
    private static final Pattern propertyPlaceholderRegex = Pattern.compile("\\$\\{(.*?)\\}");
    private static final Set<String> resolvingCacheKeys = new HashSet<String>(2, 1.0f);

    public static PropFile.Prop filter(PropFile.Prop unfiltered, String uniqueIdentifier, Map<Context, PropFileChain> filterConsultant) throws Circular {
        if (unfiltered == null || uniqueIdentifier == null || filterConsultant == null) {
            throw new NullPointerException(String.format("Parameters may not be null [ toFilter = %s | uniqueIdentifier = %s | filterConsultant = %s ].", unfiltered == null ? "null" : "prop", uniqueIdentifier, filterConsultant == null ? "null" : "map"));
        }
        FilterResult filterResult = Filter._filter(unfiltered.unfilteredValue, unfiltered.context(), uniqueIdentifier, filterConsultant);
        if (Output.isDebug() && filterResult.filtered) {
            String toFilter = unfiltered.value();
            String truncatedToFilter = toFilter.length() > 80 ? toFilter.substring(0, 80) + " [truncated]" : toFilter;
            String truncatedFiltered = filterResult.filteredResult.length() > 80 ? filterResult.filteredResult.substring(0, 80) + " [truncated]" : filterResult.filteredResult;
            Output.print("^dbug^ filtered ^b^%s^r^ to ^b^%s^r^ [ in %s%s ].", truncatedToFilter, truncatedFiltered, unfiltered.context(), Scope.Default.equals(unfiltered.scope()) ? "" : String.format(" with %s scope", unfiltered.scope().name));
        }
        return unfiltered.with(filterResult.filteredResult, filterResult.filteredResultMarked);
    }

    public static String filter(String toFilter, Context context, String uniqueIdentifier, Map<Context, PropFileChain> filterConsultant) throws Circular {
        FilterResult result = Filter._filter(toFilter, context, uniqueIdentifier, filterConsultant);
        return result.filteredResult;
    }

    private static FilterResult _filter(String toFilter, Context context, String uniqueIdentifier, Map<Context, PropFileChain> filterConsultant) throws Circular {
        if (toFilter == null || filterConsultant == null || context == null || uniqueIdentifier == null) {
            throw new NullPointerException(String.format("Parameters may not be null [ toFilter = %s | context = %s | uniqueIdentifier = %s | filterConsultant = %s ].", toFilter, context, uniqueIdentifier, filterConsultant == null ? "null" : "map"));
        }
        if (!toFilter.contains("${")) {
            return new FilterResult(toFilter, toFilter, false);
        }
        String cacheKey = Filter.getKey(toFilter, uniqueIdentifier);
        if (cache.containsKey(cacheKey)) {
            return new FilterResult(cache.get(cacheKey), cacheDecorated.get(cacheKey), false);
        }
        if (!resolvingCacheKeys.add(cacheKey)) {
            throw new Circular();
        }
        String filtered = toFilter;
        String filteredMarked = toFilter;
        Matcher matcher = propertyPlaceholderRegex.matcher(toFilter);
        while (matcher.find()) {
            String replacement;
            PropFile.Prop resolved;
            String propertyPlaceholder = matcher.group(1);
            PropFileChain chain = filterConsultant.get(context);
            if (chain != null && (resolved = chain.get(propertyPlaceholder)) != PropFile.Prop.Empty) {
                filtered = filtered.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(resolved.value()));
                boolean scoped = Filter.isScoped(resolved);
                filteredMarked = filteredMarked.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(String.format("%s%s%s", scoped ? DECORATOR_SCOPED : DECORATOR, resolved.value(), DECORATOR_END)));
                continue;
            }
            int contextIndex = propertyPlaceholder.indexOf(".");
            if (contextIndex != -1) {
                PropFile.Prop resolved2;
                Context contextWithinPropertyPlaceholder = Context.named(propertyPlaceholder.substring(0, contextIndex));
                String propertyPlaceholderWithoutContext = propertyPlaceholder.substring(contextIndex + 1);
                chain = filterConsultant.get(contextWithinPropertyPlaceholder);
                if (chain != null && (resolved2 = chain.get(propertyPlaceholderWithoutContext)) != PropFile.Prop.Empty) {
                    filtered = filtered.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(resolved2.value()));
                    boolean scoped = Filter.isScoped(resolved2);
                    filteredMarked = filteredMarked.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(String.format("%s%s%s", scoped ? DECORATOR_SCOPED : DECORATOR, resolved2.value(), DECORATOR_END)));
                    continue;
                }
            }
            if ((replacement = System.getProperty(propertyPlaceholder)) != null) {
                filtered = filtered.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(replacement));
                filteredMarked = filteredMarked.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(String.format("%s%s%s", DECORATOR, replacement, DECORATOR_END)));
                continue;
            }
            replacement = System.getenv(propertyPlaceholder);
            if (replacement != null) {
                filtered = filtered.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(replacement));
                filteredMarked = filteredMarked.replaceAll(Pattern.quote("${" + propertyPlaceholder + "}"), Matcher.quoteReplacement(String.format("%s%s%s", DECORATOR, replacement, DECORATOR_END)));
                continue;
            }
            Output.print("^warn^ No filter-value found for property ^b^%s^r^", propertyPlaceholder);
        }
        cache.put(cacheKey, filtered);
        cacheDecorated.put(cacheKey, filteredMarked);
        resolvingCacheKeys.remove(cacheKey);
        return new FilterResult(filtered, filteredMarked, true);
    }

    private static boolean isScoped(PropFile.Prop prop) {
        return !Scope.Default.equals(prop.scope());
    }

    private static String getKey(String unfiltered, String uniqueIdentifier) {
        return String.format("%s#%s", unfiltered, uniqueIdentifier);
    }

    static void clearCache() {
        cache.clear();
    }

    private Filter() {
    }

    private static final class FilterResult {
        private final String filteredResult;
        private final String filteredResultMarked;
        private final boolean filtered;

        private FilterResult(String filteredResult, String filteredResultMarked, boolean filtered) {
            this.filteredResult = filteredResult;
            this.filteredResultMarked = filteredResultMarked;
            this.filtered = filtered;
        }
    }

    public static final class Circular
    extends RuntimeException {
    }
}

