/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.mvn;

import java.util.Comparator;
import java.util.Map;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.mvn.MavenMetadataParser;

public final class Version {
    public static final Comparator<String> MAVEN_VERSION_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String[] parts2;
            String[] parts1 = this.getParts(o1);
            int major = this.compareNumber(parts1[0], (parts2 = this.getParts(o2))[0]);
            if (major != 0) {
                return major;
            }
            int minor = this.compareNumber(parts1[1], parts2[1]);
            if (minor != 0) {
                return minor;
            }
            int revision = this.compareNumber(parts1[2], parts2[2]);
            if (revision != 0) {
                return revision;
            }
            String qualifier1 = parts1[3];
            String qualifier2 = parts2[3];
            if (qualifier1.isEmpty() && !qualifier2.isEmpty()) {
                return 1;
            }
            if (!qualifier1.isEmpty() && qualifier2.isEmpty()) {
                return -1;
            }
            int qualifier = qualifier1.compareTo(qualifier2);
            if (qualifier != 0) {
                return qualifier;
            }
            return this.compareNumber(parts1[4], parts2[4]);
        }

        private String[] getParts(String val) {
            String[] parts = new String[5];
            StringBuilder buffer = new StringBuilder();
            int index = -1;
            int partsIndex = 0;
            while (++index < val.length()) {
                char character = val.charAt(index);
                if (character == '.' || character == '-') {
                    parts[partsIndex++] = buffer.toString();
                    buffer = new StringBuilder();
                    if (character == '-') {
                        while (partsIndex < 3) {
                            parts[partsIndex++] = "0";
                        }
                    }
                    if (partsIndex != 4) continue;
                    parts[partsIndex++] = index + 1 < val.length() ? val.substring(index + 1) : "";
                    break;
                }
                buffer.append(character);
            }
            if (buffer.length() > 0) {
                parts[partsIndex++] = buffer.toString();
            }
            while (partsIndex < 5) {
                String part = partsIndex == 3 ? "" : "0";
                parts[partsIndex++] = part;
            }
            return parts;
        }

        private int compareNumber(String n1, String n2) {
            Integer num2;
            Integer num1;
            try {
                num1 = Integer.parseInt(n1);
            }
            catch (NumberFormatException nfe) {
                num1 = 0;
            }
            try {
                num2 = Integer.parseInt(n2);
            }
            catch (NumberFormatException nfe) {
                num2 = 0;
            }
            return num1.compareTo(num2);
        }
    };

    public static String resolve(String version, String baseResource, Map<String, String> headers) throws Invalid, UnsupportedRangeSet {
        String latest;
        String upper;
        int index;
        if (version == null || !version.startsWith("[") && !version.startsWith("(")) {
            return version;
        }
        boolean inclusiveStart = version.startsWith("[");
        boolean inclusiveEnd = version.endsWith("]");
        for (index = 0; index < version.length() && version.charAt(index) != ','; ++index) {
        }
        if (index == version.length()) {
            --index;
        }
        String lower = version.substring(1, index);
        int lowerEnd = index + 1;
        if (index == version.length() - 1) {
            upper = lower;
        } else {
            char cur;
            while ((cur = version.charAt(++index)) != ')' && cur != ']') {
            }
            upper = version.substring(lowerEnd, index);
            if (version.length() != index + 1) {
                throw new UnsupportedRangeSet();
            }
        }
        lower = lower.trim();
        upper = upper.trim();
        if (lower.isEmpty() && upper.isEmpty()) {
            throw new Invalid();
        }
        if (inclusiveEnd && !upper.isEmpty()) {
            return upper;
        }
        MavenMetadataParser parser = new MavenMetadataParser();
        MavenMetadataParser.Metadata metadata = parser.parseMetadata(baseResource, headers);
        if (metadata == null || metadata.latest == null && metadata.versions == null) {
            Output.print("^warn^ Could not resolve the 'maven-metadata.xml' file from the repository at %s", baseResource);
            return null;
        }
        String string = latest = metadata.latest == null ? metadata.versions.get(metadata.versions.size() - 1) : metadata.latest;
        if (!lower.isEmpty() && !Version.withinLowerBound(inclusiveStart, lower, latest)) {
            Output.print("^warn^ Version ^b^%s^r^ falls outside of lower bound restriction: ^b^%s%s^r^", latest, inclusiveStart ? "[" : "(", lower);
            return null;
        }
        if (upper.isEmpty()) {
            return latest;
        }
        int compare = MAVEN_VERSION_COMPARATOR.compare(upper, latest);
        if (compare <= 0) {
            if (metadata.versions != null) {
                for (int i = metadata.versions.size() - 1; i > -1; --i) {
                    latest = metadata.versions.get(i);
                    if (MAVEN_VERSION_COMPARATOR.compare(upper, latest) <= 0) continue;
                    if (!lower.isEmpty() && !Version.withinLowerBound(inclusiveStart, lower, latest)) {
                        Output.print("^warn^ All available versions fall outside of lower bound restriction: ^b^%s%s^r^", inclusiveStart ? "[" : "(", lower);
                        return null;
                    }
                    return latest;
                }
            }
            Output.print("^warn^ All available versions fall outside of upper bound restriction: ^b^%s%s^r^", upper, inclusiveEnd ? "[" : "(");
            return null;
        }
        return latest;
    }

    private static boolean withinLowerBound(boolean inclusiveStart, String lower, String latest) {
        int compare = MAVEN_VERSION_COMPARATOR.compare(lower, latest);
        return compare <= 0 && (inclusiveStart || compare != 0);
    }

    private Version() {
    }

    public static class UnsupportedRangeSet
    extends RuntimeException {
    }

    public static class Invalid
    extends RuntimeException {
    }
}

