/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.mvn;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.ocheyedan.ply.FileUtil;
import net.ocheyedan.ply.Output;
import net.ocheyedan.ply.dep.DependencyAtom;
import net.ocheyedan.ply.dep.RepositoryAtom;
import net.ocheyedan.ply.input.Resource;
import net.ocheyedan.ply.input.Resources;
import net.ocheyedan.ply.mvn.MavenPom;
import net.ocheyedan.ply.mvn.Version;
import net.ocheyedan.ply.props.Context;
import net.ocheyedan.ply.props.PropFile;
import net.ocheyedan.ply.props.Scope;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MavenPomParser {
    public MavenPom parsePom(String pomUrlPath, RepositoryAtom repositoryAtom) {
        try {
            ParseResult result = this.parse(pomUrlPath, repositoryAtom);
            PropFile deps = new PropFile(Context.named("dependencies"), PropFile.Loc.Local);
            PropFile testDeps = new PropFile(Context.named("dependencies"), Scope.named("test"), PropFile.Loc.Local);
            Map resolvedDeps = result.resolveDeps(this, repositoryAtom);
            for (Object scope : resolvedDeps.keySet()) {
                Map scopedResolvedDeps = (Map)resolvedDeps.get(scope);
                PropFile scopedDeps = "test".equals(scope) ? testDeps : deps;
                for (String dependencyKey : scopedResolvedDeps.keySet()) {
                    FilterPair filtered = this.filterMavenDependency(new FilterPair(dependencyKey, (String)scopedResolvedDeps.get(dependencyKey)), result.mavenProperties);
                    scopedDeps.add(filtered.key, filtered.value);
                }
            }
            PropFile repos = new PropFile(Context.named("repositories"), PropFile.Loc.Local);
            for (String repoUrl : result.mavenRepositoryUrls) {
                String filteredRepoUrl = repoUrl;
                if (filteredRepoUrl.contains("${")) {
                    for (String mavenProperty : result.mavenProperties.keySet()) {
                        filteredRepoUrl = MavenPomParser.filter(filteredRepoUrl, mavenProperty, result.mavenProperties);
                    }
                }
                RepositoryAtom repoAtom = RepositoryAtom.parse("maven:" + filteredRepoUrl);
                repos.add(repoAtom.getPropertyName(), repoAtom.getPropertyValue());
            }
            PropFile modules = new PropFile(Context.named("submodules"), PropFile.Loc.Local);
            for (String module : result.modules) {
                modules.add(module, "");
            }
            return new MavenPom((String)result.mavenProperties.get("project.groupId"), (String)result.mavenProperties.get("project.artifactId"), (String)result.mavenProperties.get("project.version"), (String)result.mavenProperties.get("project.packaging"), deps, testDeps, repos, modules, (String)result.mavenProperties.get("project.build.directory"), (String)result.mavenProperties.get("project.build.outputDirectory"), (String)result.mavenProperties.get("project.build.finalName"), (String)result.mavenProperties.get("project.build.sourceDirectory"), (String)result.mavenProperties.get("project.build.testOutputDirectory"), (String)result.mavenProperties.get("project.build.testSourceDirectory"));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private FilterPair filterMavenDependency(FilterPair filterPair, Map<String, String> mavenProperties) {
        String filteredKey = filterPair.key;
        String filteredValue = filterPair.value;
        String originalKey = filteredKey;
        String originalValue = filteredValue;
        if (originalKey.contains("${") || originalValue.contains("${")) {
            for (String mavenProperty : mavenProperties.keySet()) {
                filteredKey = MavenPomParser.filter(filteredKey, mavenProperty, mavenProperties);
                filteredValue = MavenPomParser.filter(filteredValue, mavenProperty, mavenProperties);
            }
        }
        FilterPair filtered = new FilterPair(filteredKey, filteredValue);
        if (!filteredKey.equals(originalKey) && filteredKey.contains("${") || !filteredValue.equals(originalValue) && filteredValue.contains("${")) {
            return this.filterMavenDependency(filtered, mavenProperties);
        }
        return filtered;
    }

    public ParseResult parse(String pomUrlPath, RepositoryAtom repositoryAtom) throws ParserConfigurationException, IOException, SAXException {
        ParseResult parseResult = new ParseResult();
        PomUri pomUri = new PomUri(null, pomUrlPath, false);
        this.parse(pomUri, repositoryAtom, parseResult);
        return parseResult;
    }

    private void parse(PomUri pomUri, RepositoryAtom repositoryAtom, ParseResult parseResult) throws ParserConfigurationException, IOException, SAXException {
        if (pomUri.relativeUrl != null && !pomUri.relativeUrl.isEmpty()) {
            try {
                this.parse(pomUri.relativeUrl, pomUri, repositoryAtom, parseResult);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.parse(pomUri.uri, pomUri, repositoryAtom, parseResult);
    }

    private void parse(String pomUrlPath, PomUri pomUri, RepositoryAtom repositoryAtom, ParseResult parseResult) throws ParserConfigurationException, IOException, SAXException {
        Map<String, String> headers = repositoryAtom.getAuthHeaders();
        Resource pomResource = Resources.parse(pomUrlPath, headers);
        try {
            InputStream stream = pomResource.open();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            NodeList pomChildren = document.getDocumentElement().getChildNodes();
            PomUri parentPomUri = null;
            AtomicReference<String> parentVersion = new AtomicReference<String>("");
            String localVersion = null;
            AtomicReference<String> parentGroupId = new AtomicReference<String>("");
            String localGroupId = null;
            String localArtifactId = null;
            String packaging = null;
            for (int i = 0; i < pomChildren.getLength(); ++i) {
                Node child = pomChildren.item(i);
                String nodeName = child.getNodeName();
                if ("dependencyManagement".equals(nodeName)) {
                    this.parseDependencyManagement(child, parseResult, repositoryAtom);
                    continue;
                }
                if ("dependencies".equals(nodeName)) {
                    this.parseDependencies(child, parseResult, repositoryAtom, false);
                    continue;
                }
                if ("repositories".equals(nodeName)) {
                    this.parseRepositories(child, parseResult);
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.parseProperties(child, parseResult);
                    continue;
                }
                if ("groupId".equals(nodeName) && !"${parent.groupId}".equals(child.getTextContent().trim())) {
                    localGroupId = child.getTextContent().trim();
                    continue;
                }
                if ("artifactId".equals(nodeName)) {
                    localArtifactId = child.getTextContent().trim();
                    continue;
                }
                if ("version".equals(nodeName) && !"${parent.version}".equals(child.getTextContent().trim())) {
                    localVersion = Version.resolve(child.getTextContent().trim(), this.getMetadataBaseUrl(pomUrlPath), headers);
                    continue;
                }
                if ("packaging".equals(nodeName)) {
                    packaging = child.getTextContent().trim();
                    continue;
                }
                if ("parent".equals(nodeName)) {
                    parentPomUri = this.parseParentPomUrlPath(child, repositoryAtom, pomUri, parentGroupId, parentVersion);
                    continue;
                }
                if ("build".equals(nodeName)) {
                    this.parseBuild(child, parseResult);
                    continue;
                }
                if (pomUri.parsingAsParent || !"modules".equals(nodeName)) continue;
                this.parseModules(child, parseResult);
            }
            if (parentVersion.get() != null && !parseResult.mavenProperties.containsKey("project.parent.version")) {
                parseResult.mavenProperties.put("project.parent.version", parentVersion.get());
            }
            if (!parseResult.mavenProperties.containsKey("project.groupId")) {
                parseResult.mavenProperties.put("project.groupId", localGroupId != null ? localGroupId : parentGroupId.get());
                parseResult.mavenProperties.put("pom.groupId", localGroupId != null ? localGroupId : parentGroupId.get());
            }
            if (!parseResult.mavenProperties.containsKey("project.artifactId")) {
                parseResult.mavenProperties.put("project.artifactId", localArtifactId);
                parseResult.mavenProperties.put("pom.artifactId", localArtifactId);
            }
            if (!parseResult.mavenProperties.containsKey("project.version")) {
                String version = localVersion != null ? localVersion : parentVersion.get();
                version = MavenPomParser.filterVersion(version, parseResult);
                parseResult.mavenProperties.put("project.version", version);
                parseResult.mavenProperties.put("pom.version", version);
            }
            if (!parseResult.mavenProperties.containsKey("project.packaging")) {
                parseResult.mavenProperties.put("project.packaging", packaging);
            }
            if (parentPomUri != null) {
                this.filterLocalProjectProperties(parseResult);
                this.parse(parentPomUri, repositoryAtom, parseResult);
                String version = (String)parseResult.mavenProperties.get("project.version");
                version = MavenPomParser.filterVersion(version, parseResult);
                parseResult.mavenProperties.put("project.version", version);
            }
        }
        catch (SAXParseException saxpe) {
            Output.print("^error^ Could not parse %s", pomUrlPath);
            InputStream stream = pomResource.open();
            if (stream != null) {
                String line;
                Output.print("^dbug^   From content:", new Object[0]);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                boolean likelyRedirect = false;
                while ((line = reader.readLine()) != null) {
                    if (line != null && line.contains("<html>")) {
                        likelyRedirect = true;
                    }
                    Output.print("^dbug^   %s", line);
                }
                if (likelyRedirect) {
                    Output.print("^error^ Received unexpected response from host; ^red^perhaps internet is not connected.^r^", new Object[0]);
                    throw new RuntimeException(saxpe);
                }
            }
            throw saxpe;
        }
        finally {
            pomResource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMavenImport(ParseResult.Incomplete incomplete, ParseResult importParse, String pomUrlPath, RepositoryAtom repositoryAtom, ParseResult parseResult) throws ParserConfigurationException, IOException, SAXException {
        Map<String, String> headers = repositoryAtom.getAuthHeaders();
        Resource pomResource = Resources.parse(pomUrlPath, headers);
        try {
            InputStream stream = pomResource.open();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            NodeList pomChildren = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < pomChildren.getLength(); ++i) {
                Node child = pomChildren.item(i);
                String nodeName = child.getNodeName();
                if (!"dependencyManagement".equals(nodeName)) continue;
                this.parseDependencyManagementForImport(incomplete, importParse, child, parseResult, repositoryAtom);
            }
        }
        finally {
            pomResource.close();
        }
    }

    private String getMetadataBaseUrl(String pomUrlPath) {
        int index = pomUrlPath.lastIndexOf("/");
        if (index == -1) {
            return null;
        }
        String url = pomUrlPath.substring(0, index);
        if ((index = url.lastIndexOf("/")) == -1) {
            return null;
        }
        return url.substring(0, index);
    }

    private String getMetadataBaseUrl(RepositoryAtom repositoryAtom, String groupId, String artifactId) {
        String repoUrl = repositoryAtom.getPropertyName();
        return repoUrl + (repoUrl.endsWith("/") ? "" : "/") + groupId.replaceAll("\\.", "/") + "/" + artifactId;
    }

    private void parseDependencyManagement(Node dependencyManagementNode, ParseResult parseResult, RepositoryAtom repositoryAtom) {
        NodeList dependencyManagementChildren = dependencyManagementNode.getChildNodes();
        for (int i = 0; i < dependencyManagementChildren.getLength(); ++i) {
            Node dependenciesNode = dependencyManagementChildren.item(i);
            if (!"dependencies".equals(dependenciesNode.getNodeName())) continue;
            this.parseDependencies(dependenciesNode, parseResult, repositoryAtom, true);
            break;
        }
    }

    private void parseDependencyManagementForImport(ParseResult.Incomplete incomplete, ParseResult importParse, Node dependencyManagementNode, ParseResult parseResult, RepositoryAtom repositoryAtom) {
        NodeList dependencyManagementChildren = dependencyManagementNode.getChildNodes();
        for (int i = 0; i < dependencyManagementChildren.getLength(); ++i) {
            Node dependenciesNode = dependencyManagementChildren.item(i);
            if (!"dependencies".equals(dependenciesNode.getNodeName())) continue;
            this.parseDependenciesForImport(incomplete, importParse, dependenciesNode, parseResult, repositoryAtom);
            break;
        }
    }

    private void parseDependencies(Node dependenciesNode, ParseResult parseResult, RepositoryAtom repositoryAtom, boolean resolutionOnly) {
        NodeList dependencies = dependenciesNode.getChildNodes();
        for (int i = 0; i < dependencies.getLength(); ++i) {
            if (!"dependency".equals(dependencies.item(i).getNodeName())) continue;
            NodeList dependencyNode = dependencies.item(i).getChildNodes();
            String groupId = "";
            String artifactId = "";
            String version = "";
            String classifier = "";
            String type = "";
            String scope = "";
            String optional = "";
            Boolean systemPath = null;
            for (int j = 0; j < dependencyNode.getLength(); ++j) {
                Node child = dependencyNode.item(j);
                if ("groupId".equals(child.getNodeName())) {
                    groupId = child.getTextContent().trim();
                    continue;
                }
                if ("artifactId".equals(child.getNodeName())) {
                    artifactId = child.getTextContent().trim();
                    continue;
                }
                if ("version".equals(child.getNodeName())) {
                    version = child.getTextContent().trim();
                    continue;
                }
                if ("classifier".equals(child.getNodeName())) {
                    classifier = child.getTextContent().trim();
                    continue;
                }
                if ("type".equals(child.getNodeName())) {
                    type = child.getTextContent().trim();
                    continue;
                }
                if ("scope".equals(child.getNodeName())) {
                    scope = child.getTextContent().trim();
                    continue;
                }
                if ("optional".equals(child.getNodeName())) {
                    optional = child.getTextContent().trim();
                    continue;
                }
                if ("systemPath".equals(child.getNodeName())) {
                    systemPath = true;
                    continue;
                }
                if (!"exclusions".equals(dependencies.item(i).getNodeName())) continue;
            }
            version = Version.resolve(version, this.getMetadataBaseUrl(repositoryAtom, groupId, artifactId), repositoryAtom.getAuthHeaders());
            parseResult.addDep(groupId, artifactId, version, classifier, type, scope, optional, systemPath, false, resolutionOnly);
        }
    }

    private void parseDependenciesForImport(ParseResult.Incomplete incomplete, ParseResult importParse, Node dependenciesNode, ParseResult parseResult, RepositoryAtom repositoryAtom) {
        NodeList dependencies = dependenciesNode.getChildNodes();
        for (int i = 0; i < dependencies.getLength(); ++i) {
            if (!"dependency".equals(dependencies.item(i).getNodeName())) continue;
            NodeList dependencyNode = dependencies.item(i).getChildNodes();
            String groupId = "";
            String artifactId = "";
            String version = "";
            String classifier = "";
            String type = "";
            for (int j = 0; j < dependencyNode.getLength(); ++j) {
                Node child = dependencyNode.item(j);
                if ("groupId".equals(child.getNodeName())) {
                    groupId = child.getTextContent().trim();
                    continue;
                }
                if ("artifactId".equals(child.getNodeName())) {
                    artifactId = child.getTextContent().trim();
                    continue;
                }
                if ("version".equals(child.getNodeName())) {
                    version = child.getTextContent().trim();
                    continue;
                }
                if ("classifier".equals(child.getNodeName())) {
                    classifier = child.getTextContent().trim();
                    continue;
                }
                if (!"type".equals(child.getNodeName())) continue;
                type = child.getTextContent().trim();
            }
            if (!parseResult.containsDep(groupId, artifactId, classifier, type)) continue;
            version = Version.resolve(version, this.getMetadataBaseUrl(repositoryAtom, groupId, artifactId), repositoryAtom.getAuthHeaders());
            String filteredVersion = MavenPomParser.filterVersion(version, importParse);
            Output.print("^dbug^ Importing version %s for %s:%s (from import scope dependency %s:%s)", filteredVersion, groupId, artifactId, incomplete.groupId, incomplete.artifactId);
            parseResult.replaceVersion(groupId, artifactId, classifier, type, filteredVersion);
        }
    }

    private void parseRepositories(Node repositoriesNode, ParseResult parseResult) {
        NodeList repositories = repositoriesNode.getChildNodes();
        for (int i = 0; i < repositories.getLength(); ++i) {
            if (!"repository".equals(repositories.item(i).getNodeName())) continue;
            NodeList repositoryNode = repositories.item(i).getChildNodes();
            String repoUrl = "";
            String layout = "";
            for (int j = 0; j < repositoryNode.getLength(); ++j) {
                Node child = repositoryNode.item(j);
                if ("url".equals(child.getNodeName())) {
                    repoUrl = child.getTextContent().trim();
                    continue;
                }
                if (!"layout".equals(child.getNodeName())) continue;
                layout = child.getTextContent().trim();
            }
            if (!repoUrl.isEmpty() && (layout.isEmpty() || "default".equals(layout))) {
                parseResult.addRepo(repoUrl);
                continue;
            }
            if (layout.isEmpty()) continue;
            Output.print("^warn^ Found a repository [ %s ] however its layout [ ^b^%s^r^ ] is not supported, skipping.", repoUrl, layout);
        }
    }

    private void parseBuild(Node buildNode, ParseResult parseResult) {
        NodeList build = buildNode.getChildNodes();
        for (int i = 0; i < build.getLength(); ++i) {
            Node child = build.item(i);
            String nodeName = child.getNodeName();
            if ("directory".equals(nodeName)) {
                parseResult.mavenProperties.put("project.build.directory", child.getTextContent().trim());
                continue;
            }
            if ("outputDirectory".equals(nodeName)) {
                parseResult.mavenProperties.put("project.build.outputDirectory", child.getTextContent().trim());
                continue;
            }
            if ("sourceDirectory".equals(nodeName)) {
                parseResult.mavenProperties.put("project.build.sourceDirectory", child.getTextContent().trim());
                continue;
            }
            if ("testOutputDirectory".equals(nodeName)) {
                parseResult.mavenProperties.put("project.build.testOutputDirectory", child.getTextContent().trim());
                continue;
            }
            if ("testSourceDirectory".equals(nodeName)) {
                parseResult.mavenProperties.put("project.build.testSourceDirectory", child.getTextContent().trim());
                continue;
            }
            if (!"finalName".equals(nodeName)) continue;
            parseResult.mavenProperties.put("project.build.finalName", child.getTextContent().trim());
        }
    }

    private void parseModules(Node modulesNode, ParseResult parseResult) {
        NodeList modules = modulesNode.getChildNodes();
        for (int i = 0; i < modules.getLength(); ++i) {
            if (!"module".equals(modules.item(i).getNodeName())) continue;
            Node moduleNode = modules.item(i);
            parseResult.modules.add(moduleNode.getTextContent());
        }
    }

    private void filterLocalProjectProperties(ParseResult parseResult) {
        if (!parseResult.mavenProperties.containsKey("project.version") && !parseResult.mavenProperties.containsKey("project.groupId")) {
            return;
        }
        HashMap<String, ParseResult.Incomplete> filteredDeps = new HashMap<String, ParseResult.Incomplete>(parseResult.mavenIncompleteDeps.size());
        Iterator iterator = parseResult.mavenIncompleteDeps.keySet().iterator();
        while (iterator.hasNext()) {
            String dependencyKey;
            String filteredDependencyKey = dependencyKey = (String)iterator.next();
            ParseResult.Incomplete incomplete = (ParseResult.Incomplete)parseResult.mavenIncompleteDeps.get(dependencyKey);
            filteredDependencyKey = MavenPomParser.filter(filteredDependencyKey, "project.groupId", parseResult.mavenProperties);
            filteredDependencyKey = MavenPomParser.filter(filteredDependencyKey, "pom.groupId", parseResult.mavenProperties);
            incomplete.groupId = MavenPomParser.filter(incomplete.groupId, "project.groupId", parseResult.mavenProperties);
            incomplete.groupId = MavenPomParser.filter(incomplete.groupId, "pom.groupId", parseResult.mavenProperties);
            incomplete.version = MavenPomParser.filter(incomplete.version, "project.version", parseResult.mavenProperties);
            incomplete.version = MavenPomParser.filter(incomplete.version, "pom.version", parseResult.mavenProperties);
            filteredDeps.put(filteredDependencyKey, incomplete);
        }
        parseResult.mavenIncompleteDeps.clear();
        parseResult.mavenIncompleteDeps.putAll(filteredDeps);
    }

    private static String filter(String toFilter, String filterValue, Map<String, String> replacementMap) {
        if (toFilter == null || filterValue == null) {
            return toFilter;
        }
        if (toFilter.contains("${" + filterValue + "}")) {
            try {
                return toFilter.replaceAll(Pattern.quote("${" + filterValue + "}"), Matcher.quoteReplacement(replacementMap.get(filterValue)));
            }
            catch (IllegalArgumentException iae) {
                Output.print("^error^ Error filtering '^b^%s^r^' with '^b^%s^r^'.", filterValue, replacementMap.get(filterValue));
                Output.print(iae);
            }
        }
        return toFilter;
    }

    private static String filterVersion(String version, ParseResult parseResult) {
        if (version.contains("${") && version.endsWith("}")) {
            String propertyKey = version.substring(2, version.length() - 1);
            if (parseResult.mavenProperties.containsKey(propertyKey)) {
                version = MavenPomParser.filter(version, propertyKey, parseResult.mavenProperties);
            }
        }
        return version;
    }

    private void parseProperties(Node propertiesNode, ParseResult parseResult) {
        NodeList properties = propertiesNode.getChildNodes();
        for (int i = 0; i < properties.getLength(); ++i) {
            Node child = properties.item(i);
            if (parseResult.mavenProperties.containsKey(child.getNodeName())) continue;
            parseResult.mavenProperties.put(child.getNodeName(), child.getTextContent().trim());
        }
    }

    private PomUri parseParentPomUrlPath(Node parent, RepositoryAtom repositoryAtom, PomUri self, AtomicReference<String> parentGroupId, AtomicReference<String> parentVersion) {
        NodeList children = parent.getChildNodes();
        String groupId = "";
        String artifactId = "";
        String version = "";
        String relativePath = "";
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("groupId".equals(child.getNodeName())) {
                groupId = child.getTextContent().trim();
                parentGroupId.set(groupId);
                continue;
            }
            if ("artifactId".equals(child.getNodeName())) {
                artifactId = child.getTextContent().trim();
                continue;
            }
            if ("version".equals(child.getNodeName())) {
                version = child.getTextContent().trim();
                parentVersion.set(version);
                continue;
            }
            if (!"relativePath".equals(child.getNodeName())) continue;
            relativePath = child.getTextContent().trim();
        }
        PomUri pomUri = this.createPomUriWithoutRelativePath(repositoryAtom, true, groupId, artifactId, version);
        parentVersion.set(Version.resolve(parentVersion.get(), this.getMetadataBaseUrl(pomUri.uri), repositoryAtom.getAuthHeaders()));
        if (relativePath.isEmpty()) {
            String currentDir = self.relativeUrl == null || self.relativeUrl.isEmpty() ? "../" : self.relativeUrl;
            relativePath = FileUtil.pathFromParts(currentDir, artifactId, "pom.xml");
        }
        return new PomUri(relativePath, pomUri.uri, true);
    }

    private PomUri createPomUriWithoutRelativePath(RepositoryAtom repositoryAtom, boolean parsingAsParent, String groupId, String artifactId, String version) {
        String endPath;
        String startPath = repositoryAtom.getPropertyName();
        if (!startPath.endsWith("/") && !startPath.endsWith("\\")) {
            startPath = startPath + File.separator;
        }
        if ((endPath = groupId.replaceAll(Pattern.quote("."), Matcher.quoteReplacement(File.separator)) + File.separator + artifactId + File.separator + version + File.separator + artifactId + "-" + version + ".pom").startsWith("/") || endPath.startsWith("\\")) {
            endPath = endPath.substring(1, endPath.length());
        }
        String pomUrlPath = startPath + endPath;
        return new PomUri(null, pomUrlPath, parsingAsParent);
    }

    private static class FilterPair {
        private final String key;
        private final String value;

        public FilterPair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class PomUri {
        private final String relativeUrl;
        private final String uri;
        private final boolean parsingAsParent;

        private PomUri(String relativeUrl, String uri, boolean parsingAsParent) {
            this.relativeUrl = relativeUrl;
            this.uri = uri;
            this.parsingAsParent = parsingAsParent;
        }
    }

    private static class ParseResult {
        private final Map<String, String> mavenProperties = new HashMap<String, String>();
        private final Map<String, Incomplete> mavenIncompleteDeps = new HashMap<String, Incomplete>();
        private final Set<String> mavenRepositoryUrls = new HashSet<String>(2);
        private final Set<String> modules = new HashSet<String>(4);

        private ParseResult() {
        }

        private String getKey(String groupId, String artifactId, String classifier, String type) {
            return groupId + ":" + artifactId + ":" + (type == null ? "" : type) + ":" + (classifier == null ? "" : classifier);
        }

        private boolean containsDep(String groupId, String artifactId, String classifier, String type) {
            String key = this.getKey(groupId, artifactId, classifier, type);
            return this.mavenIncompleteDeps.containsKey(key);
        }

        private void replaceVersion(String groupId, String artifactId, String classifier, String type, String version) {
            String key = this.getKey(groupId, artifactId, classifier, type);
            Incomplete incomplete = this.mavenIncompleteDeps.get(key);
            if (incomplete != null) {
                incomplete.version = version;
            }
        }

        private void addDep(String groupId, String artifactId, String version, String classifier, String type, String scope, String optional, Boolean systemPath, boolean overrideExisting, boolean resolutionOnly) {
            String key = this.getKey(groupId, artifactId, classifier, type);
            if (this.mavenIncompleteDeps.containsKey(key)) {
                Incomplete incomplete = this.mavenIncompleteDeps.get(key);
                incomplete.version = overrideExisting || incomplete.version == null || incomplete.version.isEmpty() ? version : incomplete.version;
                incomplete.classifier = overrideExisting || incomplete.classifier == null || incomplete.classifier.isEmpty() ? classifier : incomplete.classifier;
                incomplete.type = overrideExisting || incomplete.type == null || incomplete.type.isEmpty() ? type : incomplete.type;
                incomplete.scope = overrideExisting || incomplete.scope == null || incomplete.scope.isEmpty() ? scope : incomplete.scope;
                incomplete.optional = overrideExisting || incomplete.optional == null || incomplete.optional.isEmpty() ? optional : incomplete.optional;
                incomplete.systemPath = overrideExisting || incomplete.systemPath == null ? systemPath : incomplete.systemPath;
                if (incomplete.resolutionOnly && !resolutionOnly) {
                    incomplete.resolutionOnly = false;
                }
            } else {
                this.mavenIncompleteDeps.put(key, new Incomplete(groupId, artifactId, version, classifier, type, scope, optional, systemPath, resolutionOnly));
            }
        }

        private void addRepo(String repoUrl) {
            this.mavenRepositoryUrls.add(repoUrl);
        }

        private static boolean shouldSkip(String scope, Boolean systemPath) {
            if (systemPath != null && systemPath.booleanValue()) {
                return true;
            }
            return scope != null && !scope.isEmpty() && "system".equals(scope);
        }

        private Map<String, Map<String, String>> resolveDeps(MavenPomParser parser, RepositoryAtom repositoryAtom) throws ParserConfigurationException, IOException, SAXException {
            this.resolveImports(parser, repositoryAtom);
            HashMap<String, Map<String, String>> deps = new HashMap<String, Map<String, String>>(this.mavenIncompleteDeps.size());
            for (Incomplete incomplete : this.mavenIncompleteDeps.values()) {
                incomplete.complete(deps, this);
            }
            return deps;
        }

        private void resolveImports(MavenPomParser parser, RepositoryAtom repositoryAtom) throws ParserConfigurationException, IOException, SAXException {
            for (Incomplete incomplete : this.mavenIncompleteDeps.values()) {
                if (!"import".equals(incomplete.scope)) continue;
                String filteredVersion = MavenPomParser.filterVersion(incomplete.version, this);
                Output.print("^dbug^ Dependency has import scope - importing dependencyManagement deps for %s:%s:%s [ pre-filtered version %s ]", incomplete.groupId, incomplete.artifactId, filteredVersion, incomplete.version);
                PomUri pomUri = parser.createPomUriWithoutRelativePath(repositoryAtom, true, incomplete.groupId, incomplete.artifactId, filteredVersion);
                ParseResult importParse = new ParseResult();
                parser.parse(pomUri, repositoryAtom, importParse);
                parser.parseMavenImport(incomplete, importParse, pomUri.uri, repositoryAtom, this);
            }
        }

        private static class Incomplete {
            private String groupId;
            private String artifactId;
            private String version;
            private String classifier;
            private String type;
            private String scope;
            private String optional;
            private Boolean systemPath;
            private boolean resolutionOnly;

            private Incomplete(String groupId, String artifactId, String version, String classifier, String type, String scope, String optional, Boolean systemPath, boolean resolutionOnly) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.classifier = classifier;
                this.type = type;
                this.scope = scope;
                this.optional = optional;
                this.systemPath = systemPath;
                this.resolutionOnly = resolutionOnly;
            }

            private void complete(Map<String, Map<String, String>> placement, ParseResult parseResult) {
                DependencyAtom atom;
                boolean transientDep;
                if (this.resolutionOnly || ParseResult.shouldSkip(this.scope, this.systemPath)) {
                    return;
                }
                String projectGroupId = (String)parseResult.mavenProperties.get("project.groupId");
                if ((this.version == null || this.version.isEmpty()) && projectGroupId != null && projectGroupId.equals(this.groupId)) {
                    this.version = (String)parseResult.mavenProperties.get("project.version");
                }
                if (this.version == null || this.version.isEmpty()) {
                    Output.print("^warn^ Encountered dependency without a version - %s:%s%s", this.groupId, this.artifactId, String.format("%s%s", this.classifier != null && !this.classifier.isEmpty() ? ":" + this.classifier : "", this.type != null && !this.type.isEmpty() ? ":" + this.type : ""));
                }
                boolean bl = transientDep = "provided".equals(this.scope) || Boolean.valueOf(this.optional) != false;
                if (this.classifier.isEmpty() && (this.type.isEmpty() || "jar".equals(this.type))) {
                    atom = new DependencyAtom(this.groupId, this.artifactId, this.version, transientDep);
                } else {
                    String artifactName = this.artifactId + "-" + this.version + (this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + (this.type.isEmpty() ? "jar" : this.type);
                    atom = new DependencyAtom(this.groupId, this.artifactId, this.version, artifactName, transientDep);
                }
                String plyScope = "test".equals(this.scope) ? "test" : "";
                Map<String, String> scopedPlacement = placement.get(plyScope);
                if (scopedPlacement == null) {
                    scopedPlacement = new HashMap<String, String>();
                    placement.put(plyScope, scopedPlacement);
                }
                scopedPlacement.put(atom.getPropertyName(), atom.getPropertyValue());
            }
        }
    }
}

