/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.mvn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.ocheyedan.ply.input.Resource;
import net.ocheyedan.ply.input.Resources;
import net.ocheyedan.ply.mvn.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenMetadataParser {
    public Metadata parseMetadata(String baseUrl, Map<String, String> headers) {
        if (baseUrl == null) {
            return null;
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        try {
            return this.parse(baseUrl + "maven-metadata.xml", headers);
        }
        catch (IOException ioe) {
            try {
                return this.parse(baseUrl + "metadata.xml", headers);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metadata parse(String metadataXmlUrl, Map<String, String> headers) throws IOException, ParserConfigurationException, SAXException {
        Resource resource = Resources.parse(metadataXmlUrl, headers);
        try {
            Metadata metadata = this.parse(resource);
            return metadata;
        }
        finally {
            resource.close();
        }
    }

    private Metadata parse(Resource resource) throws IOException, ParserConfigurationException, SAXException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(resource.open());
        NodeList metadataChildren = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < metadataChildren.getLength(); ++i) {
            Node child = metadataChildren.item(i);
            String nodeName = child.getNodeName();
            if (!"versioning".equals(nodeName)) continue;
            return this.parseVersioning(child);
        }
        throw new AssertionError((Object)String.format("Could not parse metadata file %s.", resource.name()));
    }

    private Metadata parseVersioning(Node versioning) {
        String latest = null;
        List<String> versions = null;
        NodeList versioningChildren = versioning.getChildNodes();
        for (int i = 0; i < versioningChildren.getLength(); ++i) {
            Node child = versioningChildren.item(i);
            if ("latest".equals(child.getNodeName())) {
                latest = child.getTextContent();
                continue;
            }
            if (!"versions".equals(child.getNodeName())) continue;
            versions = this.parseVersions(child);
        }
        return new Metadata(latest, versions);
    }

    private List<String> parseVersions(Node versionsNode) {
        NodeList versionsChildren = versionsNode.getChildNodes();
        ArrayList<String> versions = new ArrayList<String>(versionsChildren.getLength());
        for (int i = 0; i < versionsChildren.getLength(); ++i) {
            Node version = versionsChildren.item(i);
            if (!"version".equals(version.getNodeName())) continue;
            versions.add(version.getTextContent());
        }
        Collections.sort(versions, Version.MAVEN_VERSION_COMPARATOR);
        return versions;
    }

    public static final class Metadata {
        public final String latest;
        public final List<String> versions;

        public Metadata(String latest, List<String> versions) {
            this.latest = latest;
            this.versions = versions;
        }
    }
}

