/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.input;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.ocheyedan.ply.input.ClasspathResource;
import net.ocheyedan.ply.input.FileResource;
import net.ocheyedan.ply.input.Resource;
import net.ocheyedan.ply.input.UrlResource;

public final class Resources {
    private static final AtomicReference<ClassLoader> LOADER = new AtomicReference<ClassLoader>(Resources.class.getClassLoader());

    public static void setResourcesLoader(ClassLoader classLoader) {
        LOADER.set(classLoader);
    }

    public static Resource parse(String resource, Map<String, String> headers) {
        if (resource == null) {
            return null;
        }
        if (resource.startsWith("http:") || resource.startsWith("https:")) {
            try {
                return new UrlResource(resource, headers);
            }
            catch (MalformedURLException murle) {
                throw new RuntimeException(murle);
            }
        }
        if (resource.startsWith("classpath:")) {
            return new ClasspathResource(resource.substring(10), LOADER.get());
        }
        return new FileResource(resource);
    }

    private Resources() {
    }
}

