/*
 * Decompiled with CFR 0.152.
 */
package net.ocheyedan.ply.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Vertex<T> {
    private final List<Vertex<T>> parents = new ArrayList<Vertex<T>>();
    private final List<Vertex<T>> children = new ArrayList<Vertex<T>>();
    private final T value;

    Vertex(T value) {
        this.value = value;
    }

    void addEdgeTo(Vertex<T> vertex) {
        if (!this.children.contains(vertex)) {
            this.children.add(vertex);
        }
    }

    void addEdgeFrom(Vertex<T> vertex) {
        if (!this.parents.contains(vertex)) {
            this.parents.add(vertex);
        }
    }

    void removeEdgeTo(Vertex<T> vertex) {
        this.children.remove(vertex);
    }

    void removeEdgeFrom(Vertex<T> vertex) {
        this.parents.remove(vertex);
    }

    public boolean hasEdgeTo(Vertex<T> to) {
        return this.children.contains(to);
    }

    public boolean hasEdgeFrom(Vertex<T> from) {
        return this.parents.contains(from);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parents.isEmpty();
    }

    public Vertex<T> getAnyParent() {
        return this.parents.isEmpty() ? null : this.parents.get(0);
    }

    public T getValue() {
        return this.value;
    }

    public boolean isConnected() {
        return this.isLeaf() || this.isRoot();
    }

    public List<Vertex<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String toString() {
        return this.value == null ? "" : this.value.toString();
    }

    public String toExtendedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.toString());
        for (Vertex<T> child : this.children) {
            if (buffer.length() > this.toString().length()) {
                buffer.append("\n\t");
            }
            buffer.append(" -> ");
            buffer.append(child.toExtendedString());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex vertex = (Vertex)o;
        return this.value == null ? vertex.value == null : this.value.equals(vertex.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }
}

